/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl;

import java.io.IOException;
import net.savignano.thirdparty.org.bouncycastle.tls.ProtocolVersion;
import net.savignano.thirdparty.org.bouncycastle.tls.SecurityParameters;
import net.savignano.thirdparty.org.bouncycastle.tls.TlsFatalAlert;
import net.savignano.thirdparty.org.bouncycastle.tls.TlsUtils;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.TlsCipher;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.TlsCryptoParameters;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.TlsDecodeResult;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.TlsEncodeResult;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.TlsHMAC;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.TlsBlockCipherImpl;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.TlsImplUtils;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.TlsSuiteHMac;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.TlsSuiteMac;
import net.savignano.thirdparty.org.bouncycastle.util.Pack;

public class TlsBlockCipher
implements TlsCipher {
    protected final TlsCryptoParameters cryptoParams;
    protected final byte[] randomData;
    protected final boolean encryptThenMAC;
    protected final boolean useExplicitIV;
    protected final boolean acceptExtraPadding;
    protected final boolean useExtraPadding;
    protected final TlsBlockCipherImpl decryptCipher;
    protected final TlsBlockCipherImpl encryptCipher;
    protected final TlsSuiteMac readMac;
    protected final TlsSuiteMac writeMac;

    public TlsBlockCipher(TlsCryptoParameters cryptoParams, TlsBlockCipherImpl encryptCipher, TlsBlockCipherImpl decryptCipher, TlsHMAC clientMac, TlsHMAC serverMac, int cipherKeySize) throws IOException {
        TlsBlockCipherImpl serverCipher;
        TlsBlockCipherImpl clientCipher;
        SecurityParameters securityParameters = cryptoParams.getSecurityParametersHandshake();
        ProtocolVersion negotiatedVersion = securityParameters.getNegotiatedVersion();
        if (TlsImplUtils.isTLSv13(negotiatedVersion)) {
            throw new TlsFatalAlert(80);
        }
        this.cryptoParams = cryptoParams;
        this.randomData = cryptoParams.getNonceGenerator().generateNonce(256);
        this.encryptThenMAC = securityParameters.isEncryptThenMAC();
        this.useExplicitIV = TlsImplUtils.isTLSv11(negotiatedVersion);
        this.acceptExtraPadding = !negotiatedVersion.isSSL();
        this.useExtraPadding = securityParameters.isExtendedPadding() && ProtocolVersion.TLSv10.isEqualOrEarlierVersionOf(negotiatedVersion) && (this.encryptThenMAC || !securityParameters.isTruncatedHMac());
        this.encryptCipher = encryptCipher;
        this.decryptCipher = decryptCipher;
        if (cryptoParams.isServer()) {
            clientCipher = decryptCipher;
            serverCipher = encryptCipher;
        } else {
            clientCipher = encryptCipher;
            serverCipher = decryptCipher;
        }
        int key_block_size = 2 * cipherKeySize + clientMac.getMacLength() + serverMac.getMacLength();
        if (!this.useExplicitIV) {
            key_block_size += clientCipher.getBlockSize() + serverCipher.getBlockSize();
        }
        byte[] key_block = TlsImplUtils.calculateKeyBlock(cryptoParams, key_block_size);
        int offset = 0;
        clientMac.setKey(key_block, offset, clientMac.getMacLength());
        serverMac.setKey(key_block, offset += clientMac.getMacLength(), serverMac.getMacLength());
        clientCipher.setKey(key_block, offset += serverMac.getMacLength(), cipherKeySize);
        serverCipher.setKey(key_block, offset += cipherKeySize, cipherKeySize);
        offset += cipherKeySize;
        int clientIVLength = clientCipher.getBlockSize();
        int serverIVLength = serverCipher.getBlockSize();
        if (this.useExplicitIV) {
            clientCipher.init(new byte[clientIVLength], 0, clientIVLength);
            serverCipher.init(new byte[serverIVLength], 0, serverIVLength);
        } else {
            clientCipher.init(key_block, offset, clientIVLength);
            serverCipher.init(key_block, offset += clientIVLength, serverIVLength);
            offset += serverIVLength;
        }
        if (offset != key_block_size) {
            throw new TlsFatalAlert(80);
        }
        if (cryptoParams.isServer()) {
            this.writeMac = new TlsSuiteHMac(cryptoParams, serverMac);
            this.readMac = new TlsSuiteHMac(cryptoParams, clientMac);
        } else {
            this.writeMac = new TlsSuiteHMac(cryptoParams, clientMac);
            this.readMac = new TlsSuiteHMac(cryptoParams, serverMac);
        }
    }

    public int getCiphertextDecodeLimit(int plaintextLimit) {
        int blockSize = this.decryptCipher.getBlockSize();
        int macSize = this.readMac.getSize();
        int maxPadding = 256;
        return this.getCiphertextLength(blockSize, macSize, maxPadding, plaintextLimit);
    }

    public int getCiphertextEncodeLimit(int plaintextLength, int plaintextLimit) {
        int blockSize = this.encryptCipher.getBlockSize();
        int macSize = this.writeMac.getSize();
        int maxPadding = this.useExtraPadding ? 256 : blockSize;
        return this.getCiphertextLength(blockSize, macSize, maxPadding, plaintextLength);
    }

    public int getPlaintextLimit(int ciphertextLimit) {
        int blockSize = this.encryptCipher.getBlockSize();
        int macSize = this.writeMac.getSize();
        int plaintextLimit = ciphertextLimit;
        if (this.encryptThenMAC) {
            plaintextLimit -= macSize;
            plaintextLimit -= plaintextLimit % blockSize;
        } else {
            plaintextLimit -= plaintextLimit % blockSize;
            plaintextLimit -= macSize;
        }
        --plaintextLimit;
        if (this.useExplicitIV) {
            plaintextLimit -= blockSize;
        }
        return plaintextLimit;
    }

    public TlsEncodeResult encodePlaintext(long seqNo, short contentType, ProtocolVersion recordVersion, int headerAllocation, byte[] plaintext, int offset, int len) throws IOException {
        int blockSize = this.encryptCipher.getBlockSize();
        int macSize = this.writeMac.getSize();
        int enc_input_length = len;
        if (!this.encryptThenMAC) {
            enc_input_length += macSize;
        }
        int padding_length = blockSize - enc_input_length % blockSize;
        if (this.useExtraPadding) {
            int maxExtraPadBlocks = (256 - padding_length) / blockSize;
            int actualExtraPadBlocks = this.chooseExtraPadBlocks(maxExtraPadBlocks);
            padding_length += actualExtraPadBlocks * blockSize;
        }
        int totalSize = len + macSize + padding_length;
        if (this.useExplicitIV) {
            totalSize += blockSize;
        }
        byte[] outBuf = new byte[headerAllocation + totalSize];
        int outOff = headerAllocation;
        if (this.useExplicitIV) {
            byte[] explicitIV = this.cryptoParams.getNonceGenerator().generateNonce(blockSize);
            System.arraycopy(explicitIV, 0, outBuf, outOff, blockSize);
            outOff += blockSize;
        }
        System.arraycopy(plaintext, offset, outBuf, outOff, len);
        outOff += len;
        if (!this.encryptThenMAC) {
            byte[] mac = this.writeMac.calculateMac(seqNo, contentType, plaintext, offset, len);
            System.arraycopy(mac, 0, outBuf, outOff, mac.length);
            outOff += mac.length;
        }
        byte padByte = (byte)(padding_length - 1);
        for (int i = 0; i < padding_length; ++i) {
            outBuf[outOff++] = padByte;
        }
        this.encryptCipher.doFinal(outBuf, headerAllocation, outOff - headerAllocation, outBuf, headerAllocation);
        if (this.encryptThenMAC) {
            byte[] mac = this.writeMac.calculateMac(seqNo, contentType, outBuf, headerAllocation, outOff - headerAllocation);
            System.arraycopy(mac, 0, outBuf, outOff, mac.length);
            outOff += mac.length;
        }
        if (outOff != outBuf.length) {
            throw new TlsFatalAlert(80);
        }
        return new TlsEncodeResult(outBuf, 0, outBuf.length, contentType);
    }

    public TlsDecodeResult decodeCiphertext(long seqNo, short recordType, ProtocolVersion recordVersion, byte[] ciphertext, int offset, int len) throws IOException {
        boolean badMac;
        int blockSize = this.decryptCipher.getBlockSize();
        int macSize = this.readMac.getSize();
        int minLen = blockSize;
        minLen = this.encryptThenMAC ? (minLen += macSize) : Math.max(minLen, macSize + 1);
        if (this.useExplicitIV) {
            minLen += blockSize;
        }
        if (len < minLen) {
            throw new TlsFatalAlert(50);
        }
        int blocks_length = len;
        if (this.encryptThenMAC) {
            blocks_length -= macSize;
        }
        if (blocks_length % blockSize != 0) {
            throw new TlsFatalAlert(21);
        }
        if (this.encryptThenMAC) {
            byte[] expectedMac = this.readMac.calculateMac(seqNo, recordType, ciphertext, offset, len - macSize);
            boolean bl = badMac = !TlsUtils.constantTimeAreEqual(macSize, expectedMac, 0, ciphertext, offset + len - macSize);
            if (badMac) {
                throw new TlsFatalAlert(20);
            }
        }
        this.decryptCipher.doFinal(ciphertext, offset, blocks_length, ciphertext, offset);
        if (this.useExplicitIV) {
            offset += blockSize;
            blocks_length -= blockSize;
        }
        int totalPad = this.checkPaddingConstantTime(ciphertext, offset, blocks_length, blockSize, this.encryptThenMAC ? 0 : macSize);
        badMac = totalPad == 0;
        int dec_output_length = blocks_length - totalPad;
        if (!this.encryptThenMAC) {
            byte[] expectedMac = this.readMac.calculateMacConstantTime(seqNo, recordType, ciphertext, offset, dec_output_length -= macSize, blocks_length - macSize, this.randomData);
            badMac |= !TlsUtils.constantTimeAreEqual(macSize, expectedMac, 0, ciphertext, offset + dec_output_length);
        }
        if (badMac) {
            throw new TlsFatalAlert(20);
        }
        return new TlsDecodeResult(ciphertext, offset, dec_output_length, recordType);
    }

    public void rekeyDecoder() throws IOException {
        throw new TlsFatalAlert(80);
    }

    public void rekeyEncoder() throws IOException {
        throw new TlsFatalAlert(80);
    }

    public boolean usesOpaqueRecordType() {
        return false;
    }

    protected int checkPaddingConstantTime(byte[] buf, int off, int len, int blockSize, int macSize) {
        int end = off + len;
        byte lastByte = buf[end - 1];
        int padlen = lastByte & 0xFF;
        int totalPad = padlen + 1;
        int dummyIndex = 0;
        int padDiff = 0;
        int totalPadLimit = Math.min(this.acceptExtraPadding ? 256 : blockSize, len - macSize);
        if (totalPad > totalPadLimit) {
            totalPad = 0;
        } else {
            int padPos = end - totalPad;
            do {
                padDiff = (byte)(padDiff | buf[padPos++] ^ lastByte);
            } while (padPos < end);
            dummyIndex = totalPad;
            if (padDiff != 0) {
                totalPad = 0;
            }
        }
        byte[] dummyPad = this.randomData;
        while (dummyIndex < 256) {
            padDiff = (byte)(padDiff | dummyPad[dummyIndex++] ^ lastByte);
        }
        dummyPad[0] = (byte)(dummyPad[0] ^ padDiff);
        return totalPad;
    }

    protected int chooseExtraPadBlocks(int max) {
        byte[] random = this.cryptoParams.getNonceGenerator().generateNonce(4);
        int x = Pack.littleEndianToInt(random, 0);
        int n = this.lowestBitSet(x);
        return Math.min(n, max);
    }

    protected int getCiphertextLength(int blockSize, int macSize, int maxPadding, int plaintextLength) {
        int ciphertextLength = plaintextLength;
        if (this.useExplicitIV) {
            ciphertextLength += blockSize;
        }
        ciphertextLength += maxPadding;
        if (this.encryptThenMAC) {
            ciphertextLength -= ciphertextLength % blockSize;
            ciphertextLength += macSize;
        } else {
            ciphertextLength += macSize;
            ciphertextLength -= ciphertextLength % blockSize;
        }
        return ciphertextLength;
    }

    protected int lowestBitSet(int x) {
        if (x == 0) {
            return 32;
        }
        int n = 0;
        while ((x & 1) == 0) {
            ++n;
            x >>= 1;
        }
        return n;
    }
}

