/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.bc;

import java.io.IOException;
import java.io.OutputStream;
import net.savignano.thirdparty.org.bouncycastle.crypto.CryptoException;
import net.savignano.thirdparty.org.bouncycastle.crypto.Signer;
import net.savignano.thirdparty.org.bouncycastle.crypto.io.SignerOutputStream;
import net.savignano.thirdparty.org.bouncycastle.tls.TlsFatalAlert;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.TlsStreamSigner;
import net.savignano.thirdparty.org.bouncycastle.util.io.TeeOutputStream;

class BcVerifyingStreamSigner
implements TlsStreamSigner {
    private final Signer signer;
    private final Signer verifier;
    private final TeeOutputStream output;

    BcVerifyingStreamSigner(Signer signer, Signer verifier) {
        SignerOutputStream outputSigner = new SignerOutputStream(signer);
        SignerOutputStream outputVerifier = new SignerOutputStream(verifier);
        this.signer = signer;
        this.verifier = verifier;
        this.output = new TeeOutputStream(outputSigner, outputVerifier);
    }

    public OutputStream getOutputStream() throws IOException {
        return this.output;
    }

    public byte[] getSignature() throws IOException {
        try {
            byte[] signature = this.signer.generateSignature();
            if (this.verifier.verifySignature(signature)) {
                return signature;
            }
        }
        catch (CryptoException e) {
            throw new TlsFatalAlert(80, (Throwable)e);
        }
        throw new TlsFatalAlert(80);
    }
}

