/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.bc;

import java.io.IOException;
import net.savignano.thirdparty.org.bouncycastle.math.ec.rfc7748.X25519;
import net.savignano.thirdparty.org.bouncycastle.tls.TlsFatalAlert;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.TlsAgreement;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.TlsSecret;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.bc.BcTlsSecret;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;

public class BcX25519
implements TlsAgreement {
    protected final BcTlsCrypto crypto;
    protected final byte[] privateKey = new byte[32];
    protected final byte[] peerPublicKey = new byte[32];

    public BcX25519(BcTlsCrypto crypto) {
        this.crypto = crypto;
    }

    public byte[] generateEphemeral() throws IOException {
        this.crypto.getSecureRandom().nextBytes(this.privateKey);
        byte[] publicKey = new byte[32];
        X25519.scalarMultBase(this.privateKey, 0, publicKey, 0);
        return publicKey;
    }

    public void receivePeerValue(byte[] peerValue) throws IOException {
        if (peerValue == null || peerValue.length != 32) {
            throw new TlsFatalAlert(47);
        }
        System.arraycopy(peerValue, 0, this.peerPublicKey, 0, 32);
    }

    public TlsSecret calculateSecret() throws IOException {
        try {
            byte[] secret = new byte[32];
            if (!X25519.calculateAgreement(this.privateKey, 0, this.peerPublicKey, 0, secret, 0)) {
                throw new TlsFatalAlert(40);
            }
            BcTlsSecret bcTlsSecret = this.crypto.adoptLocalSecret(secret);
            return bcTlsSecret;
        }
        finally {
            Arrays.fill(this.privateKey, (byte)0);
            Arrays.fill(this.peerPublicKey, (byte)0);
        }
    }
}

