/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.bc;

import java.io.IOException;
import net.savignano.thirdparty.org.bouncycastle.math.ec.rfc7748.X448;
import net.savignano.thirdparty.org.bouncycastle.tls.TlsFatalAlert;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.TlsAgreement;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.TlsSecret;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.bc.BcTlsCrypto;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.bc.BcTlsSecret;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;

public class BcX448
implements TlsAgreement {
    protected final BcTlsCrypto crypto;
    protected final byte[] privateKey = new byte[56];
    protected final byte[] peerPublicKey = new byte[56];

    public BcX448(BcTlsCrypto crypto) {
        this.crypto = crypto;
    }

    public byte[] generateEphemeral() throws IOException {
        this.crypto.getSecureRandom().nextBytes(this.privateKey);
        byte[] publicKey = new byte[56];
        X448.scalarMultBase(this.privateKey, 0, publicKey, 0);
        return publicKey;
    }

    public void receivePeerValue(byte[] peerValue) throws IOException {
        if (peerValue == null || peerValue.length != 56) {
            throw new TlsFatalAlert(47);
        }
        System.arraycopy(peerValue, 0, this.peerPublicKey, 0, 56);
    }

    public TlsSecret calculateSecret() throws IOException {
        try {
            byte[] secret = new byte[56];
            if (!X448.calculateAgreement(this.privateKey, 0, this.peerPublicKey, 0, secret, 0)) {
                throw new TlsFatalAlert(40);
            }
            BcTlsSecret bcTlsSecret = this.crypto.adoptLocalSecret(secret);
            return bcTlsSecret;
        }
        finally {
            Arrays.fill(this.privateKey, (byte)0);
            Arrays.fill(this.peerPublicKey, (byte)0);
        }
    }
}

