/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.jcajce;

import java.io.IOException;
import java.security.PublicKey;
import net.savignano.thirdparty.org.bouncycastle.tls.DigitallySigned;
import net.savignano.thirdparty.org.bouncycastle.tls.SignatureAndHashAlgorithm;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.TlsStreamVerifier;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.TlsVerifier;
import net.savignano.thirdparty.org.bouncycastle.tls.crypto.impl.jcajce.JcaTlsCrypto;

public class JcaTlsEdDSAVerifier
implements TlsVerifier {
    protected final JcaTlsCrypto crypto;
    protected final PublicKey publicKey;
    protected final short algorithmType;
    protected final String algorithmName;

    public JcaTlsEdDSAVerifier(JcaTlsCrypto crypto, PublicKey publicKey, short algorithmType, String algorithmName) {
        if (null == crypto) {
            throw new NullPointerException("crypto");
        }
        if (null == publicKey) {
            throw new NullPointerException("publicKey");
        }
        this.crypto = crypto;
        this.publicKey = publicKey;
        this.algorithmType = algorithmType;
        this.algorithmName = algorithmName;
    }

    public boolean verifyRawSignature(DigitallySigned signature, byte[] hash) throws IOException {
        throw new UnsupportedOperationException();
    }

    public TlsStreamVerifier getStreamVerifier(DigitallySigned signature) throws IOException {
        SignatureAndHashAlgorithm algorithm = signature.getAlgorithm();
        if (algorithm == null || algorithm.getSignature() != this.algorithmType || algorithm.getHash() != 8) {
            throw new IllegalStateException("Invalid algorithm: " + algorithm);
        }
        return this.crypto.createStreamVerifier(this.algorithmName, null, signature.getSignature(), this.publicKey);
    }
}

