/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.key.loader.pgp;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.DirContext;
import net.savignano.cryptography.Constants;
import net.savignano.cryptography.connector.LdapConnector;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.info.InfoData;
import net.savignano.cryptography.key.loader.ALdapLoader;
import net.savignano.cryptography.key.pgp.PgpPublicKey;
import net.savignano.cryptography.util.PgpUtil;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRing;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;

public class PgpGlobalDirectoryLoader
extends ALdapLoader<PgpPublicKey> {
    public static final int INFO_SERVER_INFO = 301;
    public static final int INFO_SERVER_INFO_NOT_AVAILABLE = 302;
    private static final String PGP_KEY_SERVER_DN = "cn=PGPServerInfo";
    private static final String PGP_KEY_DN_FIELD = "pgpBaseKeySpaceDN";
    private static final String PGP_SOFTWARE_FIELD = "pgpSoftware";
    private static final String PGP_USER_ID_FIELD = "pgpUserId";
    private static final String PGP_KEY_FIELD = "pgpKey";
    private static final String PGP_KEY_LEGACY_FIELD = "pgpKeyV2";
    private static final String PGP_DISABLED_FIELD = "pgpDisabled";
    private static final String PGP_REVOKED_FIELD = "pgpRevoked";

    public PgpGlobalDirectoryLoader(LdapConnector connector) {
        super(connector);
        this.setKeySource(EKeySource.KEYSERVER);
    }

    @Override
    public PgpPublicKey loadKey(String email) {
        return this.loadKey(Pair.of(null, (Object)email));
    }

    @Override
    public PgpPublicKey loadKey(Pair<String, String> forId) {
        if (forId != null && forId.getRight() != null) {
            String email = (String)forId.getRight();
            String filter = "(&(pgpUserId=*<" + email + ">)(" + PGP_DISABLED_FIELD + "=0)(" + PGP_REVOKED_FIELD + "=0))";
            return (PgpPublicKey)super.loadKey((Pair<String, String>)Pair.of((Object)filter, (Object)email));
        }
        return (PgpPublicKey)super.loadKey(null);
    }

    @Override
    protected PgpPublicKey loadLdapKey(String userFilter, String email) throws Exception {
        List<Attribute> attributes = this.getKeyAttributes(userFilter, email);
        PgpPublicKey key = this.getKey(attributes, email);
        this.getLog().info("Key for <{}> in LDAP: {}", (Object)email, (Object)key);
        return key;
    }

    private List<Attribute> getKeyAttributes(String filter, String email) throws NamingException {
        DirContext context = this.getConnector().getContext();
        String pgpKeyDn = this.getPgpKeyDn(context);
        List<Attributes> attributes = this.getAttributes(context, pgpKeyDn, filter, new String[]{PGP_KEY_FIELD, PGP_KEY_LEGACY_FIELD}, email);
        ArrayList<Attribute> keyAttributes = new ArrayList<Attribute>();
        for (Attributes attrs : attributes) {
            NamingEnumeration<? extends Attribute> attrsEnum = attrs.getAll();
            while (attrsEnum.hasMore()) {
                keyAttributes.add(attrsEnum.next());
            }
        }
        return keyAttributes;
    }

    private String getPgpKeyDn(DirContext context) throws NamingException {
        List<String> baseDns = this.getBaseDns(context);
        List<String> keyServerInfoDns = this.getKeyServerInfoDns(baseDns);
        Logger log = this.getLog();
        log.debug("Looking up PGP server info in LDAP.");
        for (String keyServerInfoDn : keyServerInfoDns) {
            Attributes attrs;
            log.debug("Looking up PGP server info at: {}", (Object)keyServerInfoDn);
            try {
                attrs = context.getAttributes(keyServerInfoDn, new String[]{PGP_KEY_DN_FIELD, PGP_SOFTWARE_FIELD});
            }
            catch (NameNotFoundException e) {
                log.debug("Pgp server info not found at: " + keyServerInfoDn, (Throwable)e);
                continue;
            }
            log.debug("PGP server info found at: {}", (Object)keyServerInfoDn);
            String serverInfo = (String)attrs.get(PGP_SOFTWARE_FIELD).get();
            log.info("PGP key server software: {}", (Object)serverInfo);
            this.getInfoDataManager().send(new InfoData(301, serverInfo));
            String pgpKeyDn = (String)attrs.get(PGP_KEY_DN_FIELD).get();
            log.debug("DN to search PGP keys in: {}", (Object)pgpKeyDn);
            return pgpKeyDn;
        }
        this.getInfoDataManager().send(new InfoData(302, new Object[0]));
        throw new NamingException("No PGP Server Info found. LDAP does probably not support PGP keys.");
    }

    private List<String> getBaseDns(DirContext context) throws NamingException {
        this.getLog().debug("Looking up naming contexts in LDAP.");
        Attributes attrs = context.getAttributes("", new String[]{"namingContexts"});
        Attribute attr = attrs.get("namingContexts");
        ArrayList<String> baseDns = new ArrayList<String>(attr.size());
        for (int i = 0; i < attr.size(); ++i) {
            String baseDn = (String)attr.get(i);
            this.getLog().trace("Base DN: {}", (Object)baseDn);
            baseDns.add(baseDn);
        }
        return baseDns;
    }

    private List<String> getKeyServerInfoDns(List<String> baseDns) {
        if (baseDns.contains(PGP_KEY_SERVER_DN)) {
            return Collections.singletonList(PGP_KEY_SERVER_DN);
        }
        ArrayList<String> keyServerInfoDns = new ArrayList<String>(baseDns.size());
        for (String baseDn : baseDns) {
            keyServerInfoDns.add("cn=PGPServerInfo," + baseDn);
        }
        return keyServerInfoDns;
    }

    private PgpPublicKey getKey(List<Attribute> attributes, String email) {
        PgpPublicKey bestKey = null;
        for (Attribute attribute : attributes) {
            PgpPublicKey key = this.getKey(attribute, email);
            if (key.getKeyValidity() == EKeyValidity.VALID) {
                bestKey = key;
                break;
            }
            if (key.compareTo(bestKey) >= 0) continue;
            bestKey = key;
        }
        if (bestKey == null) {
            bestKey = this.getValidityKey(EKeyValidity.NOT_FOUND);
        }
        return bestKey;
    }

    private PgpPublicKey getKey(Attribute attribute, String email) {
        String keyString;
        try {
            keyString = (String)attribute.get();
        }
        catch (NamingException e) {
            this.getLog().error("Could not read PGP key. Error message: " + e.getMessage(), (Throwable)e);
            return this.getValidityKey(EKeyValidity.ERROR);
        }
        try {
            PGPPublicKeyRing keyRing = PgpUtil.loadPublicKey(new ByteArrayInputStream(keyString.getBytes(Constants.UTF8_CHARSET)));
            PgpPublicKey key = new PgpPublicKey(keyRing, email);
            key.setKeySource(this.getKeySource());
            return key;
        }
        catch (IOException e) {
            this.getLog().error("Could not load PGP key. Error message: " + e.getMessage(), (Throwable)e);
            return this.getValidityKey(EKeyValidity.ERROR);
        }
    }

    @Override
    public ECryptographyType getCryptography() {
        return ECryptographyType.PGP;
    }

    @Override
    protected PgpPublicKey getValidityKey(EKeyValidity validity) {
        return new PgpPublicKey(validity, this.getKeySource());
    }
}

