/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.key.pgp;

import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeyPurpose;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.key.ACryptographyKey;
import net.savignano.cryptography.key.IPublicCryptographyKey;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgpValidationKey
extends ACryptographyKey<PGPPublicKeyRingCollection>
implements IPublicCryptographyKey<PGPPublicKeyRingCollection> {
    private static final Logger log = LoggerFactory.getLogger(PgpValidationKey.class);
    private PGPPublicKeyRingCollection coll;

    public PgpValidationKey(PGPPublicKeyRingCollection coll) {
        super(EKeyPurpose.VALIDATION, ECryptographyType.PGP);
        this.coll = coll;
        if (coll == null) {
            log.warn("Public key was <null>.");
            this.setKeyValidity(EKeyValidity.INVALID);
        }
    }

    public PgpValidationKey(EKeyValidity validity) {
        this(validity, EKeySource.UNKNOWN);
    }

    public PgpValidationKey(EKeyValidity validity, EKeySource keySource) {
        super(EKeyPurpose.VALIDATION, ECryptographyType.PGP);
        this.setKeyValidity(validity);
        this.setKeySource(keySource);
    }

    @Override
    public PGPPublicKeyRingCollection getKey() {
        return this.coll;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(200);
        builder.append("PGP Validation Key. ");
        builder.append("Key Validity: ");
        builder.append((Object)this.getKeyValidity());
        builder.append("; Key Purpose: ");
        builder.append((Object)this.getKeyPurpose());
        builder.append("; Key Source: ");
        builder.append((Object)this.getKeySource());
        return builder.toString();
    }
}

