/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.key.smime;

import java.security.PrivateKey;
import java.security.cert.CertificateException;
import java.security.cert.CertificateExpiredException;
import java.security.cert.CertificateNotYetValidException;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.List;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeyPurpose;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.key.ACryptographyKey;
import net.savignano.cryptography.key.ISecretCryptographyKey;
import net.savignano.cryptography.util.SmimeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmimeSignKey
extends ACryptographyKey<PrivateKey>
implements ISecretCryptographyKey<PrivateKey> {
    private static final Logger log = LoggerFactory.getLogger(SmimeSignKey.class);
    private PrivateKey privateKey;
    private X509Certificate publicCert;
    private final List<X509Certificate> intermediateCerts = new ArrayList<X509Certificate>();

    public SmimeSignKey(PrivateKey privateKey, X509Certificate publicCert) {
        this(privateKey, publicCert, null);
    }

    public SmimeSignKey(PrivateKey privateKey, X509Certificate publicCert, String email) {
        super(EKeyPurpose.SIGNING, ECryptographyType.SMIME);
        this.privateKey = privateKey;
        this.publicCert = publicCert;
        if (privateKey == null) {
            log.warn("Private key was <null>.");
            this.setKeyValidity(EKeyValidity.INVALID);
            return;
        }
        if (publicCert == null) {
            log.warn("Public certificate was <null>.");
            this.setKeyValidity(EKeyValidity.INVALID);
            return;
        }
        if (!SmimeUtil.isCertForPurpose(publicCert, this.getKeyPurpose())) {
            log.debug("Certificate cannot be used for purpose: {}", (Object)this.getKeyPurpose());
            this.setKeyValidity(EKeyValidity.INVALID);
        }
        try {
            if (email == null || SmimeUtil.isCertForEmail(publicCert, email)) {
                publicCert.checkValidity();
            } else {
                log.debug("Email <{}> does not match emails for certificate.", (Object)email);
                this.setKeyValidity(EKeyValidity.INVALID);
            }
        }
        catch (CertificateExpiredException e) {
            log.warn("Certificate with serial number {} is invalid because it expired at: {}", (Object)SmimeUtil.getSerialNumber(publicCert), (Object)publicCert.getNotAfter());
            this.setKeyValidity(EKeyValidity.INVALID);
        }
        catch (CertificateNotYetValidException e) {
            log.warn("Certificate with serial number {} is invalid because it only becomes valid at: {}", (Object)SmimeUtil.getSerialNumber(publicCert), (Object)publicCert.getNotBefore());
            this.setKeyValidity(EKeyValidity.INVALID);
        }
        catch (CertificateException e) {
            log.error("Could not check that email <" + email + "> matches certificate with serial number " + SmimeUtil.getSerialNumber(publicCert) + ".", (Throwable)e);
            this.setKeyValidity(EKeyValidity.ERROR);
        }
    }

    public SmimeSignKey(EKeyValidity validity) {
        this(validity, EKeySource.UNKNOWN);
    }

    public SmimeSignKey(EKeyValidity validity, EKeySource source) {
        super(EKeyPurpose.SIGNING, ECryptographyType.SMIME);
        this.setKeyValidity(validity);
        this.setKeySource(source);
    }

    @Override
    public PrivateKey getKey() {
        return this.privateKey;
    }

    public X509Certificate getPublicCert() {
        return this.publicCert;
    }

    public List<X509Certificate> getIntermediateCerts() {
        return this.intermediateCerts;
    }

    @Override
    public void destroy() {
        this.setKeyValidity(EKeyValidity.INVALID);
        this.privateKey = null;
        this.publicCert = null;
    }

    @Override
    public boolean isDestroyed() {
        return this.privateKey == null && this.publicCert == null && this.getKeyValidity() == EKeyValidity.INVALID;
    }

    @Override
    public String toString() {
        StringBuilder builder = new StringBuilder(200);
        builder.append("S/MIME Sign Key. ");
        builder.append("Key Validity: ");
        builder.append((Object)this.getKeyValidity());
        builder.append("; Key Purpose: ");
        builder.append((Object)this.getKeyPurpose());
        builder.append("; Key Source: ");
        builder.append((Object)this.getKeySource());
        builder.append("; Private Key: ");
        builder.append(this.privateKey);
        builder.append("; Public Certificate: ");
        builder.append(this.publicCert);
        builder.append("; Intermediate Certificates: ");
        builder.append(this.intermediateCerts);
        return builder.toString();
    }
}

