/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.mail.decrypt;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.security.GeneralSecurityException;
import java.util.Iterator;
import java.util.regex.Pattern;
import java.util.regex.PatternSyntaxException;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimePart;
import javax.mail.util.ByteArrayDataSource;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.key.pgp.PgpDecryptionKey;
import net.savignano.cryptography.mail.IKeyProvider;
import net.savignano.cryptography.mail.decrypt.AMailDecryptor;
import net.savignano.cryptography.mail.visitor.ManipulateMessageVisitor;
import net.savignano.cryptography.mail.visitor.ResultMessageVisitor;
import net.savignano.cryptography.util.MessageUtil;
import net.savignano.cryptography.util.PgpUtil;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyEncryptedData;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPUtil;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.bc.BcPublicKeyDataDecryptorFactory;
import org.slf4j.LoggerFactory;

public class PgpMailDecryptor
extends AMailDecryptor<PgpDecryptionKey, Long> {
    private static final String CONTENT_TYPE_PGP_ENCRYPTED_PART1 = "application/pgp-encrypted";
    private static final String CONTENT_TYPE_PGP_ENCRYPTED_PART2 = "application/octet-stream";
    private boolean checkInline;
    private String binaryRegex;
    private boolean preferredAlgorithmUsed;

    public static final boolean isMessageEncrypted(Message message) {
        if (!(message instanceof MimeMessage)) {
            return false;
        }
        ResultMessageVisitor<Boolean> visitor = new ResultMessageVisitor<Boolean>(Boolean.valueOf(false)){

            @Override
            protected void handlePart(MimePart part) throws Exception {
                if (((Boolean)this.getResult()).booleanValue()) {
                    return;
                }
                if (PgpMailDecryptor.isPgpEncrypted(part)) {
                    this.setResult(true);
                }
            }
        };
        try {
            visitor.visit((MimeMessage)message);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(PgpMailDecryptor.class).error(e.getMessage(), (Throwable)e);
        }
        return (Boolean)visitor.getResult();
    }

    private static final boolean isPgpEncrypted(MimePart part) throws MessagingException {
        ContentType contentType = new ContentType(part.getContentType());
        if (contentType.match("multipart/encrypted")) {
            return CONTENT_TYPE_PGP_ENCRYPTED_PART1.equalsIgnoreCase(contentType.getParameter("protocol"));
        }
        return false;
    }

    public static final boolean isMessageEncryptedInline(Message message) {
        if (!(message instanceof MimeMessage)) {
            return false;
        }
        ResultMessageVisitor<Boolean> visitor = new ResultMessageVisitor<Boolean>(Boolean.valueOf(false)){

            @Override
            protected void handlePart(MimePart part) throws Exception {
                if (((Boolean)this.getResult()).booleanValue()) {
                    return;
                }
                if (PgpMailDecryptor.isEncryptedInlineText((Part)part)) {
                    this.setResult(true);
                } else if (PgpMailDecryptor.isEncryptedInlineAttachment(part)) {
                    this.setResult(true);
                }
            }
        };
        try {
            visitor.visit((MimeMessage)message);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(PgpMailDecryptor.class).error(e.getMessage(), (Throwable)e);
        }
        return (Boolean)visitor.getResult();
    }

    private static final boolean isEncryptedInlineText(Part part) throws MessagingException, IOException {
        if (part.isMimeType("text/plain")) {
            try (InputStream is = part.getInputStream();){
                boolean bl = PgpUtil.isPgpArmored(is, "-----BEGIN PGP MESSAGE-----");
                return bl;
            }
        }
        return false;
    }

    private static final boolean isEncryptedInlineAttachment(MimePart part) throws MessagingException, IOException {
        if ("attachment".equalsIgnoreCase(part.getDisposition())) {
            try (InputStream is = part.getInputStream();){
                boolean bl = PgpUtil.isPgpArmored(is, "-----BEGIN PGP MESSAGE-----");
                return bl;
            }
        }
        return false;
    }

    public static final boolean isMessageEncryptedBinary(Message message, String binaryRegex) {
        if (!(message instanceof MimeMessage)) {
            return false;
        }
        final Pattern binaryPattern = PgpMailDecryptor.getBinaryPattern(binaryRegex);
        if (binaryPattern == null) {
            return false;
        }
        ResultMessageVisitor<Boolean> visitor = new ResultMessageVisitor<Boolean>(Boolean.valueOf(false)){

            @Override
            protected void handlePart(MimePart part) throws Exception {
                if (((Boolean)this.getResult()).booleanValue()) {
                    return;
                }
                if (PgpMailDecryptor.isMatchingAttachment(part, binaryPattern)) {
                    this.setResult(true);
                }
            }
        };
        try {
            visitor.visit((MimeMessage)message);
        }
        catch (Exception e) {
            LoggerFactory.getLogger(PgpMailDecryptor.class).error(e.getMessage(), (Throwable)e);
        }
        return (Boolean)visitor.getResult();
    }

    private static final boolean isMatchingAttachment(MimePart part, Pattern binaryPattern) throws MessagingException {
        if ("attachment".equalsIgnoreCase(part.getDisposition())) {
            String fileName = part.getFileName();
            return fileName != null && binaryPattern.matcher(fileName).matches();
        }
        return false;
    }

    private static final Pattern getBinaryPattern(String regex) {
        if (regex != null) {
            try {
                return Pattern.compile(regex, 2);
            }
            catch (PatternSyntaxException e) {
                LoggerFactory.getLogger(PgpMailDecryptor.class).error(e.getMessage(), (Throwable)e);
            }
        }
        return null;
    }

    public PgpMailDecryptor(Session session) {
        super(session, ECryptographyType.PGP);
    }

    @Override
    protected void decrypt(MimeMessage msg, IKeyProvider<Long, PgpDecryptionKey> keyProvider) throws Exception {
        DecryptVisitor visitor = new DecryptVisitor(this.getSession(), keyProvider, this.isCheckInline(), PgpMailDecryptor.getBinaryPattern(this.getBinaryRegex()));
        visitor.visit(msg);
        this.preferredAlgorithmUsed = visitor.isPreferredAlgorithmUsed();
        if (visitor.isChanged()) {
            this.includeDecryptionHeader(msg);
            msg.saveChanges();
        }
    }

    @Override
    protected IKeyProvider<Long, PgpDecryptionKey> toProvider(PgpDecryptionKey key) {
        return l -> l.longValue() == key.getKey().getKeyID() ? key : new PgpDecryptionKey(EKeyValidity.NOT_FOUND);
    }

    public boolean isCheckInline() {
        return this.checkInline;
    }

    public void setCheckInline(boolean checkInline) {
        this.checkInline = checkInline;
    }

    public String getBinaryRegex() {
        return this.binaryRegex;
    }

    public void setBinaryRegex(String binaryRegex) {
        this.binaryRegex = binaryRegex;
    }

    public boolean isPreferredAlgorithmUsed() {
        return this.preferredAlgorithmUsed;
    }

    private static final class DecryptVisitor
    extends ManipulateMessageVisitor {
        private final Session session;
        private final IKeyProvider<Long, PgpDecryptionKey> keyProvider;
        private final boolean inline;
        private final Pattern binaryPattern;
        private boolean preferredAlgorithmUsed;

        public DecryptVisitor(Session session, IKeyProvider<Long, PgpDecryptionKey> keyProvider, boolean inline, Pattern binaryPattern) {
            this.session = session;
            this.keyProvider = keyProvider;
            this.inline = inline;
            this.binaryPattern = binaryPattern;
        }

        @Override
        protected void handlePart(MimePart part) throws Exception {
            if (PgpMailDecryptor.isPgpEncrypted(part)) {
                if (this.sanityCheck(part)) {
                    this.decryptPgp((Part)part, (Multipart)part.getContent());
                    this.setChanged(true);
                }
            } else if (this.checkInline() && PgpMailDecryptor.isEncryptedInlineText((Part)part)) {
                this.decryptPgpInlineText(part);
                this.setChanged(true);
            } else if (this.checkInline() && PgpMailDecryptor.isEncryptedInlineAttachment(part)) {
                this.decryptPgpInlineAttachment(part);
                this.setChanged(true);
            } else if (this.checkBinary() && PgpMailDecryptor.isMatchingAttachment(part, this.getBinaryPattern())) {
                this.decryptPgpBinaryAttachment(part);
                this.setChanged(true);
            }
        }

        private boolean sanityCheck(MimePart part) throws MessagingException, IOException {
            Multipart mp;
            if (!part.isMimeType("multipart/encrypted")) {
                this.getLog().warn("PGP encryption does not have expected content type. Found: {}", (Object)part.getContentType());
            }
            if ((mp = (Multipart)part.getContent()).getCount() != 2) {
                this.getLog().warn("PGP encryption does not have expected part count. Two expected, but found: {}", (Object)mp.getCount());
                return false;
            }
            String contentType = mp.getContentType();
            if (contentType == null || !contentType.startsWith("multipart/encrypted")) {
                this.getLog().warn("PGP encryption does not have expected content type. Found: {}", (Object)mp.getContentType());
                return false;
            }
            if (!mp.getBodyPart(0).isMimeType(PgpMailDecryptor.CONTENT_TYPE_PGP_ENCRYPTED_PART1)) {
                this.getLog().warn("PGP encryption version part does not have expected content type. Found: {}", (Object)mp.getBodyPart(0).getContentType());
                return false;
            }
            if (!mp.getBodyPart(1).isMimeType(PgpMailDecryptor.CONTENT_TYPE_PGP_ENCRYPTED_PART2)) {
                this.getLog().warn("PGP encryption content part does not have expected content type. Found: {}", (Object)mp.getBodyPart(1).getContentType());
                return false;
            }
            return true;
        }

        private void decryptPgp(Part parentPart, Multipart contentPart) throws MessagingException, IOException {
            this.getLog().debug("Decrypting PGP message.");
            BodyPart part = contentPart.getBodyPart(1);
            byte[] decrypted = this.decryptPart((Part)part);
            MimeMessage parsed = new MimeMessage(this.getSession(), (InputStream)new ByteArrayInputStream(decrypted));
            MessageUtil.movePart((Part)parsed, parentPart);
            MessageUtil.copyAllHeaders((Part)parsed, parentPart);
        }

        private void decryptPgpInlineText(MimePart part) throws MessagingException, IOException {
            this.getLog().debug("Decrypting inline text.");
            byte[] decrypted = this.decryptPart((Part)part);
            ContentType contentType = new ContentType(part.getContentType());
            String charset = contentType.getParameter("charset");
            charset = charset == null ? "UTF-8" : charset;
            part.setText(new String(decrypted, charset), charset);
        }

        private void decryptPgpInlineAttachment(MimePart part) throws MessagingException, IOException {
            this.getLog().debug("Decrypting inline attachment. File name: {}", (Object)part.getFileName());
            byte[] decrypted = this.decryptPart((Part)part);
            this.setDecryptedContent(part, decrypted);
        }

        private void decryptPgpBinaryAttachment(MimePart part) throws MessagingException, IOException {
            byte[] decrypted;
            this.getLog().debug("Decrypting binary attachment. File name: {}", (Object)part.getFileName());
            try {
                decrypted = this.decryptPart((Part)part);
            }
            catch (IOException | MessagingException e) {
                this.getLog().debug("Could not decrypt binary attachment. Probably not PGP encrypted. Error message: " + e.getMessage(), e);
                return;
            }
            this.setDecryptedContent(part, decrypted);
        }

        private byte[] decryptPart(Part part) throws IOException, MessagingException {
            byte[] decrypted = null;
            boolean foundKey = false;
            try (InputStream is = PGPUtil.getDecoderStream(part.getInputStream());){
                Iterator<PGPPublicKeyEncryptedData> encryptionInformation;
                try {
                    encryptionInformation = PgpUtil.getEncryptionInformation(is);
                }
                catch (Exception e) {
                    throw new MessagingException("Could not read encryption data for message with ID \"" + this.getMsgId() + "\". Error message: " + e.getMessage(), e);
                }
                while (decrypted == null && encryptionInformation.hasNext()) {
                    PGPPublicKeyEncryptedData encryptedData = encryptionInformation.next();
                    String prettyId = PgpUtil.getPrettyId(encryptedData.getKeyID());
                    PgpDecryptionKey key = this.mapToKey(encryptedData.getKeyID());
                    if (key.isValid()) {
                        foundKey = true;
                        try {
                            this.getLog().info("Decrypting message with ID \"{}\" with key with ID \"{}\".", (Object)this.getMsgId(), (Object)prettyId);
                            decrypted = PgpUtil.decrypt(encryptedData, key.getKey());
                        }
                        catch (Exception e) {
                            if ("checksum mismatch at in checksum of 20 bytes".equals(e.getMessage())) {
                                this.getLog().error("Supplied password for private key with ID \"" + prettyId + "\" was wrong.", (Throwable)e);
                            }
                            this.getLog().error("Error decrypting message encoded with key with ID \"" + prettyId + "\". Error message: " + e.getMessage(), (Throwable)e);
                        }
                        if (decrypted == null) continue;
                        try {
                            this.setPreferredAlgorithmUsed(this.isPreferredAlgorithm(encryptedData, key, prettyId));
                        }
                        catch (PGPException e) {
                            this.getLog().error("Could not check wether message with ID \"" + this.getMsgId() + "\" was encrypted with preferred algorithm of key with ID \"" + prettyId + "\". Error message: " + e.getMessage(), (Throwable)e);
                            this.setPreferredAlgorithmUsed(false);
                        }
                        continue;
                    }
                    this.getLog().trace("Found no key for ID \"{}\".", (Object)prettyId);
                }
            }
            if (decrypted == null) {
                if (foundKey) {
                    throw new MessagingException("Could not decrypt message with ID: " + this.getMsgId());
                }
                throw new MessagingException("Found no valid private key to decrypt message with ID: " + this.getMsgId());
            }
            return decrypted;
        }

        private boolean isPreferredAlgorithm(PGPPublicKeyEncryptedData encryptedData, PgpDecryptionKey key, String prettyId) throws PGPException {
            boolean match = false;
            if (key.getPublicKey() != null) {
                BcPublicKeyDataDecryptorFactory decFactory = new BcPublicKeyDataDecryptorFactory(key.getKey());
                int symmetricKeyAlgorithm = encryptedData.getSymmetricAlgorithm(decFactory);
                int[] algorithms = PgpUtil.getPreferredSymmetricKeyAlgorithms(key.getPublicKey());
                this.getLog().debug("Used cipher in message was \"{}\" (\"{}\").", (Object)PgpUtil.getSymmetricCipherName(symmetricKeyAlgorithm), (Object)symmetricKeyAlgorithm);
                for (int algorithm : algorithms) {
                    if (algorithm != symmetricKeyAlgorithm) continue;
                    match = true;
                    break;
                }
                if (match) {
                    this.getLog().debug("Cipher is part of preferred algorithms.");
                } else {
                    this.getLog().info("Message with ID \"{}\" was not encrypted with a preferred cipher of key with ID \"{}\". Used cipher in message was: {} ({})", new Object[]{this.getMsgId(), prettyId, PgpUtil.getSymmetricCipherName(symmetricKeyAlgorithm), symmetricKeyAlgorithm});
                }
            } else {
                this.getLog().info("No public key available for ID \"{}\".", (Object)prettyId);
            }
            return match;
        }

        private PgpDecryptionKey mapToKey(Long id) {
            try {
                return this.getKeyProvider().getKey(id);
            }
            catch (GeneralSecurityException e) {
                LoggerFactory.getLogger(PgpMailDecryptor.class).error("Could not retrieve key with ID " + PgpUtil.getPrettyId(id) + ". Error message: " + e.getMessage(), (Throwable)e);
                return new PgpDecryptionKey(EKeyValidity.ERROR);
            }
        }

        private void setDecryptedContent(MimePart part, byte[] decrypted) throws MessagingException, IOException {
            MimePart decryptedPart = this.asPart(decrypted);
            if (decryptedPart != null && decryptedPart.getHeader("Content-Type", null) != null) {
                this.getLog().debug("Attachment seems to be a MimePart. Content Type: {}", (Object)decryptedPart.getContentType());
                MessageUtil.movePart((Part)decryptedPart, (Part)part);
                MessageUtil.copyAllHeaders((Part)decryptedPart, (Part)part);
            } else {
                this.getLog().debug("Attachment is not a MimePart.");
                ByteArrayDataSource dsEncrypted = new ByteArrayDataSource(decrypted, PgpMailDecryptor.CONTENT_TYPE_PGP_ENCRYPTED_PART2);
                part.setDataHandler(new DataHandler((DataSource)dsEncrypted));
                String fileName = part.getFileName();
                if (fileName != null && (fileName.endsWith(".pgp") || fileName.endsWith(".gpg") || fileName.endsWith(".asc"))) {
                    part.setFileName(fileName.substring(0, fileName.length() - 4));
                }
            }
        }

        private MimePart asPart(byte[] bytes) {
            try {
                return new MimeBodyPart((InputStream)new ByteArrayInputStream(bytes));
            }
            catch (MessagingException e) {
                this.getLog().debug("Could not parse data into body part. Probably not a MIME part. Error message: " + e.getMessage(), (Throwable)e);
                return null;
            }
        }

        private boolean checkInline() {
            return this.inline;
        }

        private boolean checkBinary() {
            return this.binaryPattern != null;
        }

        private Pattern getBinaryPattern() {
            return this.binaryPattern;
        }

        private IKeyProvider<Long, PgpDecryptionKey> getKeyProvider() {
            return this.keyProvider;
        }

        private Session getSession() {
            return this.session;
        }

        public boolean isPreferredAlgorithmUsed() {
            return this.preferredAlgorithmUsed;
        }

        public void setPreferredAlgorithmUsed(boolean preferredAlgorithmUsed) {
            this.preferredAlgorithmUsed = preferredAlgorithmUsed;
        }
    }
}

