/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.mail.encrypt;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Arrays;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.util.ByteArrayDataSource;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.key.pgp.PgpPublicKey;
import net.savignano.cryptography.mail.encrypt.AMailEncryptor;
import net.savignano.cryptography.util.PgpUtil;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKey;
import org.slf4j.Logger;

public class PgpMailEncryptor
extends AMailEncryptor<PgpPublicKey> {
    private int forceSymmetricKeyAlgorithm = -1;

    public PgpMailEncryptor(Session session) {
        super(session, ECryptographyType.PGP);
    }

    @Override
    protected void encrypt(MimeMessage msg, PgpPublicKey key) throws Exception {
        PGPPublicKey encryptionKey = key.getKey();
        this.getLog().debug("Using public key: {}", (Object)PgpUtil.getPrettyId(encryptionKey));
        int encryptionAlgorithm = this.getSymmetricKeyAlgorithm(key);
        byte[] encryptedBytes = this.encrypt(msg, this.getUsedKeys(key), encryptionAlgorithm);
        this.wrapIntoMessage(msg, encryptedBytes);
        String cipherName = PgpUtil.getSymmetricCipherName(this.getSymmetricKeyAlgorithm(key));
        this.includeEncryptionHeader(msg, cipherName);
        msg.saveChanges();
    }

    protected int getSymmetricKeyAlgorithm(PgpPublicKey key) {
        Logger log = this.getLog();
        if (this.getForceSymmetricKeyAlgorithm() != -1) {
            log.debug("Forced symmetric key algorithm: {}", (Object)PgpUtil.getSymmetricCipherName(this.getForceSymmetricKeyAlgorithm()));
            return this.getForceSymmetricKeyAlgorithm();
        }
        if (!this.addSenderEncryption()) {
            log.debug("No sender key present. Using prefered symmetric key algorithm of sender: {}", (Object)PgpUtil.getSymmetricCipherName(key.getSymmetricKeyAlgorithm()));
            return key.getSymmetricKeyAlgorithm();
        }
        int[] recipientAlgos = PgpUtil.getPreferredSymmetricKeyAlgorithms(key.getKeyRing());
        int[] senderAlgos = PgpUtil.getPreferredSymmetricKeyAlgorithms(((PgpPublicKey)this.getSenderKey().get()).getKeyRing());
        for (int recAlgo : recipientAlgos) {
            for (int senderAlgo : senderAlgos) {
                if (recAlgo != senderAlgo) continue;
                if (PgpUtil.isSupportedSymmetricKeyAlgorithm(recAlgo)) {
                    log.debug("Found shared algorithm: {} ({})", (Object)PgpUtil.getSymmetricCipherName(recAlgo), (Object)recAlgo);
                    return recAlgo;
                }
                log.warn("Symmetric key algorithm {} for key {} is not supported.", (Object)PgpUtil.getSymmetricCipherName(recAlgo), (Object)PgpUtil.getPrettyId(key.getKey()));
            }
        }
        log.info("No supported algorithm shared between recipient and sender key. Using fallback of AES 128.");
        log.debug("Recipient/Sender Algorithms: {}/{}", (Object)Arrays.toString(recipientAlgos), (Object)Arrays.toString(senderAlgos));
        return 7;
    }

    private byte[] encrypt(MimeMessage msg, PGPPublicKey[] encryptionKeys, int encryptionAlgorithm) throws IOException, MessagingException, PGPException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        msg.writeTo((OutputStream)baos);
        byte[] encryptedBytes = PgpUtil.encrypt(baos.toByteArray(), encryptionKeys, encryptionAlgorithm, true, true);
        return encryptedBytes;
    }

    protected PGPPublicKey[] getUsedKeys(PgpPublicKey key) {
        if (this.addSenderEncryption()) {
            return new PGPPublicKey[]{key.getKey(), ((PgpPublicKey)this.getSenderKey().get()).getKey()};
        }
        return new PGPPublicKey[]{key.getKey()};
    }

    private boolean addSenderEncryption() {
        return this.getSenderKey().isPresent() && ((PgpPublicKey)this.getSenderKey().get()).isValid();
    }

    private void wrapIntoMessage(MimeMessage msg, byte[] encryptedBytes) throws IOException, MessagingException {
        MimeBodyPart partVersion = new MimeBodyPart();
        ByteArrayDataSource dsVersion = new ByteArrayDataSource("Version: 1\r\n", "application/pgp-encrypted");
        partVersion.setDataHandler(new DataHandler((DataSource)dsVersion));
        partVersion.setDescription("PGP/MIME version identification");
        MimeBodyPart partEncrypted = new MimeBodyPart();
        ByteArrayDataSource dsEncrypted = new ByteArrayDataSource(encryptedBytes, "application/octet-stream");
        partEncrypted.setDataHandler(new DataHandler((DataSource)dsEncrypted));
        partEncrypted.setDisposition("inline; filename=\"encrypted.asc\"");
        partEncrypted.setDescription("OpenPGP encrypted message");
        MimeMultipart multipart = new MimeMultipart("encrypted;\r\n\tprotocol=\"application/pgp-encrypted\"");
        multipart.addBodyPart((BodyPart)partVersion);
        multipart.addBodyPart((BodyPart)partEncrypted);
        msg.setContent((Multipart)multipart);
    }

    public int getForceSymmetricKeyAlgorithm() {
        return this.forceSymmetricKeyAlgorithm;
    }

    public void setForceSymmetricKeyAlgorithm(int forceSymmetricKeyAlgorithm) {
        this.forceSymmetricKeyAlgorithm = forceSymmetricKeyAlgorithm;
    }
}

