/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.cryptography.mail.visitor.specific;

import java.io.IOException;
import java.io.InputStream;
import java.util.regex.Pattern;
import javax.mail.MessagingException;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimePart;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.mail.visitor.ResultMessageVisitor;
import net.savignano.cryptography.util.MessageUtil;
import net.savignano.cryptography.util.PgpUtil;

public class DetectCryptographyVisitor
extends ResultMessageVisitor<ECryptographyType> {
    private boolean checkInline;
    private Pattern binaryPattern;

    public DetectCryptographyVisitor() {
        super(ECryptographyType.NONE);
    }

    @Override
    public void visit(MimeMessage msg) throws Exception {
        super.visit(msg);
        this.getLog().debug("Cryptography type detected for message with ID {}: {}", (Object)MessageUtil.getMessageId(msg), this.getResult());
    }

    @Override
    protected void handlePart(MimePart part) throws Exception {
        if (this.getResult() != ECryptographyType.NONE) {
            return;
        }
        ContentType contentType = new ContentType(part.getContentType());
        this.getLog().trace("MIME type: {}", (Object)contentType);
        if (contentType.match("multipart/signed")) {
            this.handleSignedPart(contentType);
        } else if (contentType.match("application/pkcs7-mime") || contentType.match("application/x-pkcs7-mime")) {
            this.getLog().debug("PKCS7 content found: {}", (Object)contentType);
            this.setResult(ECryptographyType.SMIME);
        } else if (contentType.match("application/pgp-encrypted")) {
            this.getLog().debug("Encrypted content found: {}", (Object)contentType);
            this.setResult(ECryptographyType.PGP);
        } else if (this.isCheckInline()) {
            if (this.isInlineEncryptedSigned(part)) {
                this.getLog().debug("Secured inline text found.");
                this.setResult(ECryptographyType.PGP);
            } else if (this.isInlineAttachment(part)) {
                this.getLog().debug("Encrypted inline attachment found.");
                this.setResult(ECryptographyType.PGP);
            } else if (this.binaryPattern != null && this.isMatchingAttachment(part, this.binaryPattern)) {
                this.getLog().debug("Matching binary attachment found.");
                this.setResult(ECryptographyType.PGP);
            }
        }
    }

    private void handleSignedPart(ContentType contentType) {
        this.getLog().debug("Signed content found: {}", (Object)contentType);
        String protocol = contentType.getParameter("protocol");
        if (protocol != null) {
            if (protocol.equalsIgnoreCase("application/pgp-signature")) {
                this.setResult(ECryptographyType.PGP);
            } else if (protocol.equalsIgnoreCase("application/pkcs7-signature") || protocol.equalsIgnoreCase("application/x-pkcs7-signature")) {
                this.setResult(ECryptographyType.SMIME);
            }
        }
        if (this.getResult() == ECryptographyType.NONE) {
            this.getLog().warn("Signed content found, but cannot determine what cryptographic method was used. Content type: {}", (Object)contentType);
        }
    }

    private boolean isInlineEncryptedSigned(MimePart part) throws MessagingException, IOException {
        if (part.isMimeType("text/plain")) {
            String content = (String)part.getContent();
            if (content.startsWith("-----BEGIN PGP MESSAGE-----")) {
                return true;
            }
            if (content.startsWith("-----BEGIN PGP SIGNED MESSAGE-----")) {
                return true;
            }
        }
        return false;
    }

    private boolean isInlineAttachment(MimePart part) throws MessagingException, IOException {
        if ("attachment".equalsIgnoreCase(part.getDisposition())) {
            try (InputStream is = part.getInputStream();){
                boolean bl = PgpUtil.isPgpArmored(is, "-----BEGIN PGP MESSAGE-----");
                return bl;
            }
        }
        return false;
    }

    private boolean isMatchingAttachment(MimePart part, Pattern binaryPattern) throws MessagingException {
        if ("attachment".equalsIgnoreCase(part.getDisposition())) {
            String fileName = part.getFileName();
            return fileName != null && binaryPattern.matcher(fileName).matches();
        }
        return false;
    }

    public boolean isCheckInline() {
        return this.checkInline;
    }

    public void setCheckInline(boolean checkInline) {
        this.checkInline = checkInline;
    }

    public String getBinaryRegex() {
        return this.binaryPattern != null ? this.binaryPattern.pattern() : null;
    }

    public void setBinaryRegex(String binaryRegex) {
        this.binaryPattern = binaryRegex != null ? Pattern.compile(binaryRegex, 2) : null;
    }
}

