/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.common.security.access.pgp;

import com.atlassian.cache.Cache;
import java.io.ByteArrayInputStream;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.cryptography.enums.EKeyValidity;
import net.savignano.cryptography.key.loader.AKeyLoader;
import net.savignano.cryptography.key.pgp.PgpPublicKey;
import net.savignano.cryptography.util.PgpUtil;

public class PgpCacheLoader
extends AKeyLoader<PgpPublicKey, String> {
    private final Cache<String, byte[]> cache;

    public PgpCacheLoader(Cache<String, byte[]> cache) {
        this.cache = cache;
        if (cache == null) {
            throw new IllegalArgumentException("Cache must not be null.");
        }
    }

    public void clear(String email) {
        this.cache.remove((Object)email);
    }

    @Override
    public EKeySource getKeySource() {
        return EKeySource.UNKNOWN;
    }

    @Override
    public ECryptographyType getCryptography() {
        return ECryptographyType.PGP;
    }

    @Override
    protected PgpPublicKey loadInternalKey(String email) throws Exception {
        byte[] ring = (byte[])this.cache.get((Object)email);
        return ring == null ? this.getValidityKey(EKeyValidity.NOT_FOUND) : new PgpPublicKey(PgpUtil.loadPublicKey(new ByteArrayInputStream(ring)), email);
    }

    @Override
    protected PgpPublicKey getValidityKey(EKeyValidity validity) {
        return new PgpPublicKey(validity, this.getKeySource());
    }
}

