/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.gui.keysource.verification.smime;

import java.util.function.Consumer;
import javax.naming.CommunicationException;
import net.savignano.cryptography.info.InfoData;
import net.savignano.cryptography.key.ICryptographyKey;
import net.savignano.cryptography.key.loader.smime.SmimeLdapLoader;
import net.savignano.snotify.atlassian.common.ISnotifyI18n;
import net.savignano.snotify.atlassian.common.connector.AtlassianLdapConnector;
import net.savignano.snotify.atlassian.gui.keysource.verification.AKeySourceVerification;
import net.savignano.snotify.atlassian.gui.keysource.verification.EVerificationStatus;
import org.apache.commons.lang3.tuple.Pair;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmimeLdapVerification
extends AKeySourceVerification {
    private static final Logger log = LoggerFactory.getLogger(SmimeLdapVerification.class);
    private final SmimeLdapLoader loader;
    private final String userFilter;
    private String email;
    private EVerificationStatus userNotFoundStatus = EVerificationStatus.WARNING;

    public SmimeLdapVerification(SmimeLdapLoader loader, String userFilter, ISnotifyI18n i18n) {
        super(i18n);
        this.loader = loader;
        this.userFilter = userFilter;
        if (loader == null) {
            throw new IllegalArgumentException("Loader must not be null.");
        }
        if (loader.getConnector() instanceof AtlassianLdapConnector) {
            this.getBuilder().title("net.savignano.snotify.key-management.verification.smime.user-directory.title", new Object[0]);
        } else {
            this.getBuilder().title("net.savignano.snotify.key-management.verification.smime.ldap.title", new Object[0]);
        }
        this.setReportKey(false);
    }

    @Override
    protected void doVerify() throws Exception {
        Consumer<InfoData> consumer = this::handleInfoData;
        this.loader.getInfoDataManager().register(consumer);
        this.loader.loadKey((Pair<String, String>)Pair.of((Object)this.getUserFilter(), (Object)this.getEmail()));
        this.loader.getInfoDataManager().unregister(consumer);
    }

    private void handleInfoData(InfoData data) {
        switch (data.infoType) {
            case 102: {
                this.handleError((Exception)data.additionalData[0]);
                break;
            }
            case 100: {
                this.verifyKey((ICryptographyKey)data.additionalData[0]);
                break;
            }
            case 200: {
                this.userNotPresent();
                break;
            }
            case 201: {
                this.connectionSuccess((String)data.additionalData[0]);
                break;
            }
            case 202: {
                break;
            }
            case 203: {
                this.connectionError((String)data.additionalData[0], (Exception)data.additionalData[1]);
                break;
            }
            case 204: {
                this.userFound((String)data.additionalData[0]);
                break;
            }
            case 205: {
                this.userNotFound((String)data.additionalData[0]);
                break;
            }
            default: {
                log.debug("Unhandled info data of type: {}", (Object)data.infoType);
            }
        }
    }

    private void userNotPresent() {
        this.getBuilder().info();
        this.getBuilder().subTitle("net.savignano.snotify.key-management.verification.smime.ldap.findUser.noUser.title", new Object[0]);
        this.getBuilder().message("net.savignano.snotify.key-management.verification.smime.ldap.findUser.noUser.message", new Object[0]);
        this.build();
    }

    private void connectionSuccess(String location) {
        this.getBuilder().success();
        this.getBuilder().subTitle("net.savignano.snotify.key-management.verification.smime.ldap.canConnect.success.title", new Object[0]);
        this.getBuilder().message("net.savignano.snotify.key-management.verification.smime.ldap.canConnect.success.message", location);
        this.build();
    }

    private void connectionError(String location, Exception exception) {
        Exception displayedException = exception instanceof CommunicationException && exception.getCause() != null ? exception.getCause() : exception;
        this.getBuilder().error();
        this.getBuilder().subTitle("net.savignano.snotify.key-management.verification.smime.ldap.canConnect.exception.title", new Object[0]);
        this.getBuilder().message("net.savignano.snotify.key-management.verification.smime.ldap.canConnect.exception.message", location, displayedException.getClass().getSimpleName(), displayedException.getLocalizedMessage());
        this.build();
    }

    private void userFound(String userName) {
        this.setReportKey(true);
        this.getBuilder().success();
        this.getBuilder().subTitle("net.savignano.snotify.key-management.verification.smime.ldap.findUser.success.title", new Object[0]);
        this.getBuilder().message("net.savignano.snotify.key-management.verification.smime.ldap.findUser.success.message", userName);
        this.build();
    }

    private void userNotFound(String userName) {
        this.setReportError(false);
        this.getBuilder().status(this.getUserNotFoundStatus());
        this.getBuilder().subTitle("net.savignano.snotify.key-management.verification.smime.ldap.findUser.failure.title", new Object[0]);
        this.getBuilder().message("net.savignano.snotify.key-management.verification.smime.ldap.findUser.failure.message", userName);
        this.build();
    }

    public SmimeLdapLoader getLoader() {
        return this.loader;
    }

    public String getUserFilter() {
        return this.userFilter;
    }

    public String getEmail() {
        return this.email;
    }

    public void setEmail(String email) {
        this.email = email;
    }

    public EVerificationStatus getUserNotFoundStatus() {
        return this.userNotFoundStatus;
    }

    public void setUserNotFoundStatus(EVerificationStatus userNotFoundStatus) {
        this.userNotFoundStatus = userNotFoundStatus != null ? userNotFoundStatus : EVerificationStatus.WARNING;
    }
}

