/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.gui.templates.handler.impl;

import javax.servlet.http.HttpServletRequest;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.properties.ISnotifyAppProperties;
import net.savignano.snotify.atlassian.gui.templates.handler.IEnumHandler;
import net.savignano.snotify.atlassian.gui.templates.handler.impl.AAppPropValueHandler;

public class EnumHandler<E extends Enum<E>>
extends AAppPropValueHandler<E>
implements IEnumHandler<E> {
    public EnumHandler(String id, ISnotifyAppProperties appProps, EProperty prop) {
        super(id, appProps, prop);
        if (!prop.getType().isEnum()) {
            throw new IllegalArgumentException("The given property is not a property of an enum: " + (Object)((Object)prop));
        }
    }

    @Override
    public void read() {
        this.setValue(this.getAppProps().getEnum(this.getProp(), this.getEnumClass()));
    }

    @Override
    public void store() {
        this.getAppProps().setEnum(this.getProp(), (Enum)this.getValue());
    }

    @Override
    public void receive(HttpServletRequest request) {
        String input = request.getParameter(this.getId());
        for (Enum e : (Enum[])this.getEnumClass().getEnumConstants()) {
            if (!e.name().equals(input)) continue;
            this.setValue(e);
            break;
        }
    }

    @Override
    public E getEnum() {
        return (E)((Enum)this.getValue());
    }

    @Override
    public boolean isSelected(String enumName) {
        Enum value = (Enum)this.getValue();
        return value == null ? enumName == null : value.name().equals(enumName);
    }

    private Class<E> getEnumClass() {
        return this.getProp().getType();
    }
}

