/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.bitbucket.gui.servlet;

import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.templaterenderer.RenderingException;
import com.atlassian.upm.api.license.PluginLicenseManager;
import java.io.IOException;
import java.util.Collection;
import java.util.Map;
import java.util.Optional;
import java.util.TreeMap;
import java.util.function.Supplier;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.savignano.cryptography.Constants;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.properties.ASnotifyAppProperties;
import net.savignano.snotify.atlassian.gui.SupportBuilder;
import net.savignano.snotify.atlassian.gui.keysource.verification.VerificationStatusBuilder;
import net.savignano.snotify.bitbucket.gui.servlet.AdminSettingsServlet;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;

public class ExtendedSettingsServlet
extends AdminSettingsServlet {
    private static final long serialVersionUID = -9056466992686980314L;
    private static final Logger log = LoggerFactory.getLogger(ExtendedSettingsServlet.class);
    private static final String ADD_PARAM = "Add";
    private static final String UPDATE_PARAM = "Update";
    private static final String DELETE_PARAM = "Delete";
    private static final String SUPPORT_PARAM = "Support";
    private static final String KEY_PARAM = "key";
    private static final String VALUE_PARAM = "value";
    @Autowired
    @ComponentImport
    private PluginLicenseManager licenseManager;

    public ExtendedSettingsServlet() {
        super("extended-settings");
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!this.hasAdminRights()) {
            this.redirectLogin(req, resp);
            return;
        }
        if (req.getParameter(SUPPORT_PARAM) != null) {
            this.support(resp);
        } else {
            super.doGet(req, resp);
        }
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!this.hasAdminRights()) {
            this.redirectLogin(req, resp);
            return;
        }
        if (!this.hasMatchinXsrfToken(req)) {
            this.renderXsrfError(req, resp);
            return;
        }
        if (req.getParameter(ADD_PARAM) != null) {
            this.add(req, resp);
        } else if (req.getParameter(UPDATE_PARAM) != null) {
            this.update(req, resp);
        } else if (req.getParameter(DELETE_PARAM) != null) {
            this.delete(req, resp);
        } else {
            log.error("Unknonw post behaviour detected.");
            resp.sendError(400);
        }
    }

    private void add(HttpServletRequest req, HttpServletResponse resp) throws IOException, RenderingException {
        String key = req.getParameter(KEY_PARAM);
        String value = req.getParameter(VALUE_PARAM);
        log.debug("Adding key/value pair to tweaks: {} = {}", (Object)key, (Object)value);
        Map<String, Object> renderData = this.createRendererData(req);
        if (StringUtils.isBlank((CharSequence)key) || StringUtils.isBlank((CharSequence)value)) {
            log.debug("Key or Value is considered empty. Tweak will not be added.");
            this.renderInput(resp, renderData);
            return;
        }
        this.setProperty(key, value, renderData);
        this.renderInput(resp, renderData);
    }

    private void update(HttpServletRequest req, HttpServletResponse resp) throws IOException, RenderingException {
        String key = req.getParameter(KEY_PARAM);
        String value = req.getParameter(VALUE_PARAM);
        log.debug("Updating value of tweak: {} = {}", (Object)key, (Object)value);
        Map<String, Object> renderData = this.createRendererData(req);
        if (StringUtils.isBlank((CharSequence)key) || StringUtils.isBlank((CharSequence)value)) {
            log.debug("Key or Value is considered empty. Tweak will not be added.");
            this.renderInput(resp, renderData);
            return;
        }
        this.setProperty(key, value, renderData);
        this.renderInput(resp, renderData);
    }

    private void setProperty(String key, String value, Map<String, Object> renderData) {
        Optional<EProperty> prop = EProperty.getProperty("tweak." + key);
        if (!prop.isPresent()) {
            log.debug("Key {} does not represent a tweak.", (Object)key);
            VerificationStatusBuilder builder = new VerificationStatusBuilder(this.getI18n());
            builder.error();
            builder.title("snotify-tweak-webwork.input.error.notAPropertyTitle", new Object[0]);
            builder.message("snotify-tweak-webwork.input.error.notAPropertyMessage", key);
            String errorMessage = builder.build().getHtmlStatus();
            renderData.put("errorMessageHtml", errorMessage);
            return;
        }
        ((ASnotifyAppProperties)this.getAppProps()).setAsString(prop.get(), value);
        Map<String, String> tweaks = this.getUsedTweaks();
        tweaks.put(key, value);
        this.setUsedTweaks(tweaks);
        renderData.put("showUpdated", true);
    }

    private void delete(HttpServletRequest req, HttpServletResponse resp) throws IOException, RenderingException {
        String key = req.getParameter(KEY_PARAM);
        log.debug("Removing key from tweaks: {}", (Object)key);
        Map<String, Object> renderData = this.createRendererData(req);
        if (StringUtils.isBlank((CharSequence)key)) {
            log.debug("Key is considered empty. Tweak will not be removed.");
            this.renderInput(resp, renderData);
            return;
        }
        Optional<EProperty> prop = EProperty.getProperty("tweak." + key);
        if (prop.isPresent()) {
            ((ASnotifyAppProperties)this.getAppProps()).setAsString(prop.get(), null);
        } else {
            log.debug("Key {} does not represent a tweak.", (Object)key);
        }
        Map<String, String> tweaks = this.getUsedTweaks();
        tweaks.remove(key);
        this.setUsedTweaks(tweaks);
        renderData.put("showUpdated", true);
        this.renderInput(resp, renderData);
    }

    private void support(HttpServletResponse resp) throws IOException, RenderingException {
        log.debug("Creating support file.");
        String data = this.createSupportData();
        byte[] contents = data.getBytes(Constants.UTF8_CHARSET);
        resp.addHeader("Content-Type", "text/plain; charset=UTF-8");
        resp.addHeader("Content-Length", String.valueOf(contents.length));
        resp.addHeader("Cache-Control", "no-cache");
        resp.addHeader("Pragma", "no-cache");
        resp.addHeader("Expires", "-1");
        resp.addHeader("Content-Disposition", "attachment; filename=\"snotify-support.txt\"");
        resp.getWriter().append(data);
        resp.getWriter().flush();
    }

    private String createSupportData() {
        Supplier<String> platform = () -> {
            ApplicationPropertiesService appService = (ApplicationPropertiesService)ComponentLocator.getComponent(ApplicationPropertiesService.class);
            return "Bitbucket " + appService.getBuildVersion();
        };
        return SupportBuilder.create().includeLicenseId(this.licenseManager).includePlatform(platform).includeProperties(this.getAppProps()).build();
    }

    public Collection<Map.Entry<String, String>> getTweakEntries() {
        return this.getUsedTweaks().entrySet();
    }

    private Map<String, String> getUsedTweaks() {
        TreeMap<String, String> tweaks = new TreeMap<String, String>();
        String tweakString = this.getAppProps().getUnlimitedString(EProperty.TWEAK_OVERVIEW);
        if (tweakString != null) {
            for (String tweak : tweakString.split("\\;")) {
                Optional<EProperty> prop = EProperty.getProperty("tweak." + tweak);
                if (prop.isPresent()) {
                    tweaks.put(tweak, ((ASnotifyAppProperties)this.getAppProps()).getAsString(prop.get()));
                    continue;
                }
                log.info("Key {} is not considered a tweak. It will be skipped.");
            }
        }
        return tweaks;
    }

    private void setUsedTweaks(Map<String, String> tweaks) {
        if (tweaks == null || tweaks.isEmpty()) {
            this.getAppProps().setUnlimitedString(EProperty.TWEAK_OVERVIEW, null);
        } else {
            StringBuilder builder = new StringBuilder();
            for (Map.Entry<String, String> entry : tweaks.entrySet()) {
                builder.append(entry.getKey());
                builder.append(';');
            }
            builder.deleteCharAt(builder.length() - 1);
            this.getAppProps().setUnlimitedString(EProperty.TWEAK_OVERVIEW, builder.toString());
        }
    }
}

