/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.bitbucket.gui.servlet;

import com.atlassian.bitbucket.user.UserService;
import com.atlassian.bitbucket.util.Page;
import com.atlassian.bitbucket.util.PageRequest;
import com.atlassian.bitbucket.util.PageRequestImpl;
import com.atlassian.sal.api.component.ComponentLocator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.gui.templates.handler.impl.CheckBoxHandler;
import net.savignano.snotify.atlassian.gui.templates.handler.impl.EnumHandler;
import net.savignano.snotify.atlassian.gui.templates.handler.impl.provider.ValueHandlerContainer;
import net.savignano.snotify.bitbucket.gui.servlet.AdminSettingsServlet;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class GeneralSettingsServlet
extends AdminSettingsServlet {
    private static final long serialVersionUID = -7529354972830077978L;
    private static final Logger log = LoggerFactory.getLogger(GeneralSettingsServlet.class);
    private static final String WHITELIST_USER_GROUP_PARAM = "whitelistUserGroup";
    private static final String REQUEST_CONTEXT_PATH_KEY = "reqContextPath";
    private static final String WHITELIST_USER_GROUP_SELECTED_KEY = "whitelistSelectedUserGroup";
    private static final String USER_GROUPS_KEY = "userGroups";
    private static final String ENCRYPTION_FAILURE_ID = "encryptionFailure";
    private static final String ENCRYPTION_TYPE_PRIORITY_ID = "encryptionTypePriority";
    private static final String SUBJECT_REPLACEMENT_ID = "subjectReplacement";
    private static final String SIGNING_ENABLED_ID = "signingEnabled";
    private static final String SIGNING_SMIME_OPAQUE_ID = "signingSmimeOpaque";
    private static final String ALLOW_PASSWORD_RESET_MAIL_ID = "allowPasswordResetMail";

    public GeneralSettingsServlet() {
        super("general-settings");
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!this.hasAdminRights()) {
            this.redirectLogin(req, resp);
            return;
        }
        ValueHandlerContainer container = this.createValueHandlerProvider();
        container.read();
        Map<String, Object> renderData = this.createRendererData(req);
        renderData.put("valueHandlerProvider", container);
        this.renderInput(resp, renderData);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!this.hasAdminRights()) {
            this.redirectLogin(req, resp);
            return;
        }
        if (!this.hasMatchinXsrfToken(req)) {
            this.renderXsrfError(req, resp);
            return;
        }
        ValueHandlerContainer container = this.createValueHandlerProvider();
        container.receive(req);
        container.store();
        String whitelistUserGroup = StringUtils.stripToNull((String)req.getParameter(WHITELIST_USER_GROUP_PARAM));
        this.getAppProps().setString(EProperty.WHITELIST_USER_GROUP, whitelistUserGroup);
        Map<String, Object> renderData = this.createRendererData(req);
        renderData.put("valueHandlerProvider", container);
        renderData.put("showUpdated", true);
        this.renderInput(resp, renderData);
    }

    @Override
    protected Map<String, Object> createRendererData(HttpServletRequest req) {
        Map<String, Object> renderData = super.createRendererData(req);
        renderData.put(REQUEST_CONTEXT_PATH_KEY, req.getContextPath());
        renderData.put(USER_GROUPS_KEY, this.getUserGroups());
        renderData.put(WHITELIST_USER_GROUP_SELECTED_KEY, this.getAppProps().getString(EProperty.WHITELIST_USER_GROUP));
        return renderData;
    }

    private ValueHandlerContainer createValueHandlerProvider() {
        ValueHandlerContainer container = new ValueHandlerContainer();
        container.add(new CheckBoxHandler(SUBJECT_REPLACEMENT_ID, this.getAppProps(), EProperty.SUBJECT_PROTECTION));
        container.add(new CheckBoxHandler(SIGNING_ENABLED_ID, this.getAppProps(), EProperty.SIGNING_ENABLED));
        container.add(new CheckBoxHandler(SIGNING_SMIME_OPAQUE_ID, this.getAppProps(), EProperty.SIGNING_SMIME_OPAQUE));
        container.add(new EnumHandler(ENCRYPTION_TYPE_PRIORITY_ID, this.getAppProps(), EProperty.ENCRYPTION_TYPE_PRIORITY));
        container.add(new EnumHandler(ENCRYPTION_FAILURE_ID, this.getAppProps(), EProperty.ENCRYPTION_FAILURE_BEHAVIOR));
        container.add(new CheckBoxHandler(ALLOW_PASSWORD_RESET_MAIL_ID, this.getAppProps(), EProperty.ALLOW_PASSWORD_RESET_MAIL));
        return container;
    }

    private List<String> getUserGroups() {
        log.warn("Starting groups.");
        ArrayList<String> userGroups = new ArrayList<String>();
        UserService service = (UserService)ComponentLocator.getComponent(UserService.class);
        PageRequestImpl request = new PageRequestImpl(0, 0x100000);
        Page page = service.findGroups((PageRequest)request);
        page.forEach(g -> userGroups.add((String)g));
        log.warn("All groups: {}", userGroups);
        return userGroups;
    }
}

