/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.bitbucket.gui.servlet;

import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.sal.api.component.ComponentLocator;
import java.io.IOException;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EEncryptionTypePriority;
import net.savignano.cryptography.util.SecurityUtil;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.ISnotifyI18n;
import net.savignano.snotify.atlassian.common.properties.ASnotifyAppProperties;
import net.savignano.snotify.atlassian.gui.keysource.verification.VerificationStatus;
import net.savignano.snotify.atlassian.gui.keysource.verification.pgp.PgpPrivateKeyStoreVerification;
import net.savignano.snotify.atlassian.gui.keysource.verification.smime.SmimeKeyStoreVerification;
import net.savignano.snotify.atlassian.gui.templates.handler.IValueHandlerProvider;
import net.savignano.snotify.atlassian.gui.templates.handler.impl.InputHandler;
import net.savignano.snotify.atlassian.gui.templates.handler.impl.PasswordHandler;
import net.savignano.snotify.atlassian.gui.templates.handler.impl.provider.ValueHandlerContainer;
import net.savignano.snotify.bitbucket.gui.servlet.AdminSettingsServlet;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class ServerKeyStoreSettingsServlet
extends AdminSettingsServlet {
    private static final long serialVersionUID = 5134137930221061056L;
    private static final Logger log = LoggerFactory.getLogger(ServerKeyStoreSettingsServlet.class);
    private static final String SMIME_PRIVATE_KEYSTORE_LOCATION_ID = "smimePrivateKeystoreLocation";
    private static final String SMIME_PRIVATE_KEYSTORE_PASSWORD_ID = "smimePrivateKeystorePassword";
    private static final String PGP_PRIVATE_KEYSTORE_LOCATION_ID = "pgpPrivateKeystoreLocation";
    private static final String PGP_PRIVATE_KEY_PASSWORD_ID = "pgpPrivateKeyPassword";
    private static final String VERIFY_PGP_BUTTON_PARAM = "Verify-PGP";
    private static final String VERIFY_SMIME_BUTTON_PARAM = "Verify-SMIME";
    private static final String CLEAR_CACHE_PGP_BUTTON_PARAM = "Clear-Cache-PGP";
    private static final String CLEAR_CACHE_SMIME_PARAM = "Clear-Cache-SMIME";
    private static final String SUBMIT_PGP_BUTTON_PARAM = "Update-PGP";
    private static final String SUBMIT_SMIME_BUTTON_PARAM = "Update-SMIME";
    private static final String DISPLAYED_TAB_KEY = "displayedTab";
    private static final String VERIFY_MESSAGE_KEY = "verifyMessageHtml";
    private static final String EXPIRE_KEYS_KEY = "expireKeys";

    public ServerKeyStoreSettingsServlet() {
        super("server-key-store-settings");
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!this.hasAdminRights()) {
            this.redirectLogin(req, resp);
            return;
        }
        Map<String, Object> renderData = this.createRendererData(req);
        ValueHandlerContainer container = this.createValueHandlerProvider();
        container.read();
        renderData.put("valueHandlerProvider", container);
        this.renderInput(resp, renderData);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!this.hasAdminRights()) {
            this.redirectLogin(req, resp);
            return;
        }
        if (!this.hasMatchinXsrfToken(req)) {
            this.renderXsrfError(req, resp);
            return;
        }
        Map<String, Object> renderData = this.createRendererData(req);
        ValueHandlerContainer container = this.createValueHandlerProvider();
        container.receive(req);
        renderData.put("valueHandlerProvider", container);
        this.clearCache();
        if (req.getParameter(SUBMIT_PGP_BUTTON_PARAM) != null) {
            renderData.put(DISPLAYED_TAB_KEY, (Object)ECryptographyType.PGP);
            renderData.put("showUpdated", true);
            this.storeSettings(container);
            this.renderInput(resp, renderData);
        } else if (req.getParameter(SUBMIT_SMIME_BUTTON_PARAM) != null) {
            renderData.put(DISPLAYED_TAB_KEY, (Object)ECryptographyType.SMIME);
            renderData.put("showUpdated", true);
            this.storeSettings(container);
            this.renderInput(resp, renderData);
        } else if (req.getParameter(VERIFY_PGP_BUTTON_PARAM) != null) {
            renderData.put(DISPLAYED_TAB_KEY, (Object)ECryptographyType.PGP);
            renderData.put(VERIFY_MESSAGE_KEY, this.verifySettings(container));
            this.renderInput(resp, renderData);
        } else if (req.getParameter(VERIFY_SMIME_BUTTON_PARAM) != null) {
            renderData.put(DISPLAYED_TAB_KEY, (Object)ECryptographyType.SMIME);
            renderData.put(VERIFY_MESSAGE_KEY, this.verifySettings(container));
            this.renderInput(resp, renderData);
        } else if (req.getParameter(CLEAR_CACHE_PGP_BUTTON_PARAM) != null) {
            renderData.put(DISPLAYED_TAB_KEY, (Object)ECryptographyType.PGP);
            renderData.put(EXPIRE_KEYS_KEY, true);
            this.renderInput(resp, renderData);
        } else if (req.getParameter(CLEAR_CACHE_SMIME_PARAM) != null) {
            renderData.put(DISPLAYED_TAB_KEY, (Object)ECryptographyType.SMIME);
            renderData.put(EXPIRE_KEYS_KEY, true);
            this.renderInput(resp, renderData);
        } else {
            resp.sendError(400);
        }
    }

    private void storeSettings(ValueHandlerContainer wrapper) {
        wrapper.store();
    }

    private String verifySettings(IValueHandlerProvider provider) {
        String pgpKeyStoreLocation;
        ArrayList<VerificationStatus> statusList = new ArrayList<VerificationStatus>();
        String smimeKeyStoreLocation = (String)provider.getValue(SMIME_PRIVATE_KEYSTORE_LOCATION_ID);
        if (StringUtils.isNotBlank((String)smimeKeyStoreLocation)) {
            char[] password = (char[])provider.getValue(SMIME_PRIVATE_KEYSTORE_PASSWORD_ID);
            statusList.addAll(this.verifySmimePrivateKeystore(smimeKeyStoreLocation, password));
            SecurityUtil.clearPassword(password);
        }
        if (StringUtils.isNotBlank((String)(pgpKeyStoreLocation = (String)provider.getValue(PGP_PRIVATE_KEYSTORE_LOCATION_ID)))) {
            char[] password = (char[])provider.getValue(PGP_PRIVATE_KEY_PASSWORD_ID);
            statusList.addAll(this.verifyPgpPrivateKeystore(pgpKeyStoreLocation, password));
            SecurityUtil.clearPassword(password);
        }
        StringBuilder builder = new StringBuilder(512 * statusList.size());
        for (VerificationStatus status : statusList) {
            builder.append(status.getHtmlStatus());
        }
        return builder.toString();
    }

    private List<VerificationStatus> verifySmimePrivateKeystore(String keyStoreLocation, char[] password) {
        log.info("Verifying S/MIME private key store at location: {}", (Object)keyStoreLocation);
        ISnotifyI18n i18n = this.getI18n();
        SmimeKeyStoreVerification verification = new SmimeKeyStoreVerification(keyStoreLocation, "PKCS12", i18n);
        verification.getEmails().addAll(this.getEmails());
        verification.setKeyStorePassword(password);
        verification.setKeyPassword(password);
        verification.setEnablePrivateKeyCheck(true);
        return verification.verify();
    }

    private List<VerificationStatus> verifyPgpPrivateKeystore(String keyStoreLocation, char[] password) {
        log.info("Verifying PGP private key store at location: {}", (Object)keyStoreLocation);
        ISnotifyI18n i18n = this.getI18n();
        PgpPrivateKeyStoreVerification verification = new PgpPrivateKeyStoreVerification(keyStoreLocation, i18n);
        verification.getEmails().addAll(this.getEmails());
        verification.setPassword(password);
        return verification.verify();
    }

    private void clearCache() {
        this.getAppProps().setLong(EProperty.EXPIRE_KEYS_PRIVATE_TIMESTAMP, System.currentTimeMillis());
    }

    private EEncryptionTypePriority getTypePriority() {
        return this.getAppProps().getEnum(EProperty.ENCRYPTION_TYPE_PRIORITY, EEncryptionTypePriority.class);
    }

    private List<String> getEmails() {
        ArrayList<String> emails = new ArrayList<String>();
        String email = this.getMailServerEmail();
        if (email != null) {
            emails.add(email);
        }
        return emails;
    }

    private String getMailServerEmail() {
        ApplicationPropertiesService service = (ApplicationPropertiesService)ComponentLocator.getComponent(ApplicationPropertiesService.class);
        String email = service.getServerEmailAddress();
        log.debug("Email address configured for outgoing mail server: <{}>", (Object)email);
        return email;
    }

    private ValueHandlerContainer createValueHandlerProvider() {
        ValueHandlerContainer container = new ValueHandlerContainer();
        container.add(new InputHandler(SMIME_PRIVATE_KEYSTORE_LOCATION_ID, this.getAppProps(), EProperty.PRIVATE_SMIME_KEYSTORE_LOCATION));
        container.add(new PasswordHandler(SMIME_PRIVATE_KEYSTORE_PASSWORD_ID, (ASnotifyAppProperties)this.getAppProps(), EProperty.PRIVATE_SMIME_KEY_PASSWORD));
        container.add(new InputHandler(PGP_PRIVATE_KEYSTORE_LOCATION_ID, this.getAppProps(), EProperty.PRIVATE_PGP_KEYSTORE_LOCATION));
        container.add(new PasswordHandler(PGP_PRIVATE_KEY_PASSWORD_ID, (ASnotifyAppProperties)this.getAppProps(), EProperty.PRIVATE_PGP_KEY_PASSWORD));
        return container;
    }

    public boolean isSmimeSelected(ECryptographyType cryptoType) {
        if (cryptoType == ECryptographyType.SMIME) {
            return true;
        }
        if (cryptoType == ECryptographyType.PGP) {
            return false;
        }
        switch (this.getTypePriority()) {
            case SMIME_ONLY: 
            case SMIME_PREFERED: {
                return true;
            }
            case PGP_ONLY: 
            case PGP_PREFERED: {
                return false;
            }
        }
        log.error("Type priority not yet implemented: {}", (Object)this.getTypePriority());
        return false;
    }

    public boolean isPgpSelected(ECryptographyType cryptoType) {
        if (cryptoType == ECryptographyType.PGP) {
            return true;
        }
        if (cryptoType == ECryptographyType.SMIME) {
            return false;
        }
        switch (this.getTypePriority()) {
            case SMIME_ONLY: 
            case SMIME_PREFERED: {
                return false;
            }
            case PGP_ONLY: 
            case PGP_PREFERED: {
                return true;
            }
        }
        log.error("Type priority not yet implemented: {}", (Object)this.getTypePriority());
        return false;
    }
}

