/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.bitbucket.gui.servlet;

import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.DetailedUser;
import com.atlassian.bitbucket.user.UserAdminService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.sal.api.component.ComponentLocator;
import java.io.IOException;
import java.net.URI;
import java.net.URISyntaxException;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Map;
import java.util.SortedMap;
import java.util.TreeMap;
import javax.naming.ConfigurationException;
import javax.servlet.ServletException;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import net.savignano.cryptography.connector.LdapConnector;
import net.savignano.cryptography.enums.ECryptographyType;
import net.savignano.cryptography.enums.EEncryptionTypePriority;
import net.savignano.cryptography.enums.EKeySource;
import net.savignano.cryptography.key.loader.pgp.PgpGlobalDirectoryLoader;
import net.savignano.cryptography.key.loader.pgp.PgpKeyServerLoader;
import net.savignano.cryptography.key.loader.smime.SmimeLdapLoader;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.ISnotifyI18n;
import net.savignano.snotify.atlassian.common.KeySourceComperator;
import net.savignano.snotify.atlassian.common.connector.AtlassianLdapConnector;
import net.savignano.snotify.atlassian.gui.keysource.verification.AKeySourceVerification;
import net.savignano.snotify.atlassian.gui.keysource.verification.EVerificationStatus;
import net.savignano.snotify.atlassian.gui.keysource.verification.UserKeySourceVerification;
import net.savignano.snotify.atlassian.gui.keysource.verification.VerificationStatus;
import net.savignano.snotify.atlassian.gui.keysource.verification.pgp.PgpGlobalDirectoryVerification;
import net.savignano.snotify.atlassian.gui.keysource.verification.pgp.PgpKeyBoxVerification;
import net.savignano.snotify.atlassian.gui.keysource.verification.pgp.PgpKeyServerVerification;
import net.savignano.snotify.atlassian.gui.keysource.verification.pgp.PgpPublicKeyStoreVerification;
import net.savignano.snotify.atlassian.gui.keysource.verification.smime.SmimeKeyStoreVerification;
import net.savignano.snotify.atlassian.gui.keysource.verification.smime.SmimeLdapVerification;
import net.savignano.snotify.atlassian.gui.keysource.verification.smime.SmimeP7bVerification;
import net.savignano.snotify.atlassian.gui.templates.handler.IValueHandlerProvider;
import net.savignano.snotify.atlassian.gui.templates.handler.impl.CheckBoxHandler;
import net.savignano.snotify.atlassian.gui.templates.handler.impl.InputHandler;
import net.savignano.snotify.atlassian.gui.templates.handler.impl.RadioHandler;
import net.savignano.snotify.atlassian.gui.templates.handler.impl.provider.BaseValueHandlerProvider;
import net.savignano.snotify.atlassian.gui.templates.handler.impl.provider.ExternalLdapHandlerProvider;
import net.savignano.snotify.atlassian.gui.templates.handler.impl.provider.ValueHandlerContainer;
import net.savignano.snotify.bitbucket.common.BitbucketUser;
import net.savignano.snotify.bitbucket.common.SnotifyUserProperties;
import net.savignano.snotify.bitbucket.gui.servlet.AdminSettingsServlet;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class UserKeyStoreSettingsServlet
extends AdminSettingsServlet {
    private static final long serialVersionUID = 506404962803142988L;
    private static final Logger log = LoggerFactory.getLogger(UserKeyStoreSettingsServlet.class);
    private static final String SMIME_PUBLIC_KEYSTORE_LOCATION_ID = "smimePublicKeystoreLocation";
    private static final String SMIME_PUBLIC_KEYSTORE_TYPE_ID = "smimePublicKeystoreType";
    private static final String PGP_PUBLIC_KEYSTORE_LOCATION_ID = "pgpPublicKeystoreLocation";
    private static final String PGP_PUBLIC_KEYSTORE_TYPE_ID = "pgpPublicKeystoreType";
    private static final String PGP_PUBLIC_KEYSERVER_LOCATION_ID = "pgpPublicKeyserverLocation";
    private static final String ALLOW_PGP_PUBLIC_KEY_OVERWRITE_ID = "allowPublicPgpKeyOverwrite";
    private static final String ALLOW_SMIME_CERTIFICATE_OVERWRITE_ID = "allowPublicSmimeCertOverwrite";
    private static final String USE_SMIME_PUBLIC_USER_DIRECTORY_ID = "smimePublicUserDirectory";
    private static final String VERIFICATION_EMAIL_PARAM = "verificationEmail";
    private static final String ACTIVE_TAB_PARAM = "activeTab";
    private static final String VERIFY_BUTTON_PARAM = "Verify";
    private static final String CLEAR_CACHE_BUTTON_PARAM = "Clear-Cache";
    private static final String SUBMIT_BUTTON_PARAM = "Update";
    private static final String VERIFICATION_EMAIL_KEY = "verificationEmail";
    private static final String DISPLAYED_TAB_KEY = "displayedTab";
    private static final String VERIFY_MESSAGE_KEY = "verifyMessageHtml";
    private static final String EXPIRE_KEYS_KEY = "expireKeys";
    private static final String LDAP_PROVIDER_KEY = "ldapProvider";

    public UserKeyStoreSettingsServlet() {
        super("user-key-store-settings");
    }

    @Override
    protected void doGet(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!this.hasAdminRights()) {
            this.redirectLogin(req, resp);
            return;
        }
        Map<String, Object> renderData = this.createRendererData(req);
        ValueHandlerContainer container = this.createValueHandlerProvider();
        container.read();
        renderData.put("valueHandlerProvider", container);
        ExternalLdapHandlerProvider ldapProvider = this.createLdapProvider();
        ldapProvider.read();
        renderData.put(LDAP_PROVIDER_KEY, ldapProvider);
        renderData.put("verificationEmail", this.getUser().getEmail());
        renderData.put(DISPLAYED_TAB_KEY, (Object)this.getActiveTab(null));
        this.renderInput(resp, renderData);
    }

    protected void doPost(HttpServletRequest req, HttpServletResponse resp) throws ServletException, IOException {
        if (!this.hasAdminRights()) {
            this.redirectLogin(req, resp);
            return;
        }
        if (!this.hasMatchinXsrfToken(req)) {
            this.renderXsrfError(req, resp);
            return;
        }
        Map<String, Object> renderData = this.createRendererData(req);
        ValueHandlerContainer container = this.createValueHandlerProvider();
        container.receive(req);
        renderData.put("valueHandlerProvider", container);
        ExternalLdapHandlerProvider ldapProvider = this.createLdapProvider();
        ldapProvider.receive(req);
        renderData.put(LDAP_PROVIDER_KEY, ldapProvider);
        String verificationEmail = req.getParameter("verificationEmail");
        if (StringUtils.isBlank((String)verificationEmail)) {
            verificationEmail = this.getUser().getEmail();
        }
        renderData.put("verificationEmail", verificationEmail);
        renderData.put(DISPLAYED_TAB_KEY, (Object)this.getActiveTab(this.getCryptoTypeSafe(req.getParameter(ACTIVE_TAB_PARAM))));
        this.clearCache();
        if (req.getParameter(SUBMIT_BUTTON_PARAM) != null) {
            renderData.put("showUpdated", true);
            this.storeSettings(container);
            this.storeSettings(ldapProvider);
            this.renderInput(resp, renderData);
        } else if (req.getParameter(VERIFY_BUTTON_PARAM) != null) {
            renderData.put(VERIFY_MESSAGE_KEY, this.verifySettings(container, ldapProvider, verificationEmail));
            this.renderInput(resp, renderData);
        } else if (req.getParameter(CLEAR_CACHE_BUTTON_PARAM) != null) {
            renderData.put(EXPIRE_KEYS_KEY, true);
            this.renderInput(resp, renderData);
        } else {
            resp.sendError(400);
        }
    }

    private void storeSettings(BaseValueHandlerProvider valueHandlerProvider) {
        valueHandlerProvider.store();
    }

    private String verifySettings(IValueHandlerProvider provider, ExternalLdapHandlerProvider ldapProvider, String email) {
        ArrayList<VerificationStatus> statusList = new ArrayList<VerificationStatus>();
        for (List<VerificationStatus> smimeStatus : this.createSmimeVerifications(provider, ldapProvider, email).values()) {
            statusList.addAll(smimeStatus);
        }
        for (List<VerificationStatus> smimeStatus : this.createPgpVerifications(provider, email).values()) {
            statusList.addAll(smimeStatus);
        }
        StringBuilder builder = new StringBuilder(512 * statusList.size());
        for (VerificationStatus status : statusList) {
            builder.append(status.getHtmlStatus());
        }
        return builder.toString();
    }

    private SortedMap<EKeySource, List<VerificationStatus>> createSmimeVerifications(IValueHandlerProvider provider, ExternalLdapHandlerProvider ldapProvider, String email) {
        TreeMap<EKeySource, List<VerificationStatus>> statusMap = new TreeMap<EKeySource, List<VerificationStatus>>(new KeySourceComperator());
        String smimeKeyStoreLocation = (String)provider.getValue(SMIME_PUBLIC_KEYSTORE_LOCATION_ID);
        if (StringUtils.isNotBlank((String)smimeKeyStoreLocation)) {
            String keyStoreType = (String)provider.getValue(SMIME_PUBLIC_KEYSTORE_TYPE_ID);
            statusMap.put(EKeySource.KEYSTORE, this.verifySmimePublicKeystore(smimeKeyStoreLocation, keyStoreType, email));
        }
        if (ldapProvider.isValid()) {
            statusMap.put(EKeySource.STANDARD_LDAP, this.verifySmimePublicLdap(ldapProvider, email));
        }
        if (((Boolean)provider.getValue(USE_SMIME_PUBLIC_USER_DIRECTORY_ID)).booleanValue()) {
            statusMap.put(EKeySource.ATLASSIAN_DIRECTORY, this.verifySmimePublicUserDirectory(email));
        }
        if (((Boolean)provider.getValue(ALLOW_SMIME_CERTIFICATE_OVERWRITE_ID)).booleanValue()) {
            statusMap.put(EKeySource.USER, this.verifySmimeUserUpload(email));
        }
        return statusMap;
    }

    private SortedMap<EKeySource, List<VerificationStatus>> createPgpVerifications(IValueHandlerProvider provider, String email) {
        String pgpKeyServerLocation;
        TreeMap<EKeySource, List<VerificationStatus>> statusMap = new TreeMap<EKeySource, List<VerificationStatus>>(new KeySourceComperator());
        String pgpKeyStoreLocation = (String)provider.getValue(PGP_PUBLIC_KEYSTORE_LOCATION_ID);
        if (StringUtils.isNotBlank((String)pgpKeyStoreLocation)) {
            String keyStoreType = (String)provider.getValue(PGP_PUBLIC_KEYSTORE_TYPE_ID);
            statusMap.put(EKeySource.KEYSTORE, this.verifyPgpPublicKeystore(pgpKeyStoreLocation, keyStoreType, email));
        }
        if (StringUtils.isNotBlank((String)(pgpKeyServerLocation = (String)provider.getValue(PGP_PUBLIC_KEYSERVER_LOCATION_ID)))) {
            statusMap.put(EKeySource.KEYSERVER, this.verifyPgpPublicKeyserver(pgpKeyServerLocation, email));
        }
        if (((Boolean)provider.getValue(ALLOW_PGP_PUBLIC_KEY_OVERWRITE_ID)).booleanValue()) {
            statusMap.put(EKeySource.USER, this.verifyPgpUserUpload(email));
        }
        return statusMap;
    }

    private List<VerificationStatus> verifySmimeUserUpload(String email) {
        log.info("Verifying S/MIME key upload for user.");
        SnotifyUserProperties userProps = new SnotifyUserProperties();
        UserKeySourceVerification verification = new UserKeySourceVerification(ECryptographyType.SMIME, userProps, this.getI18n());
        verification.useEmail(email, BitbucketUser::lookupUser);
        return verification.verify();
    }

    private List<VerificationStatus> verifySmimePublicKeystore(String keyStoreLocation, String keyStoreType, String email) {
        log.info("Verifying S/MIME public key store at location: {}", (Object)keyStoreLocation);
        ISnotifyI18n i18n = this.getI18n();
        switch (keyStoreType) {
            case "BKS": {
                SmimeKeyStoreVerification ksVerification = new SmimeKeyStoreVerification(keyStoreLocation, keyStoreType, i18n);
                if (email != null) {
                    ksVerification.getEmails().add(email);
                }
                return ksVerification.verify();
            }
            case "PKCS7": {
                SmimeP7bVerification p7bVerification = new SmimeP7bVerification(keyStoreLocation, i18n);
                if (email != null) {
                    p7bVerification.getEmails().add(email);
                }
                return p7bVerification.verify();
            }
        }
        log.error("Unknown key store type encountered: {}", (Object)keyStoreType);
        VerificationStatus status = new VerificationStatus();
        status.status = EVerificationStatus.ERROR;
        status.title = i18n.getText("snotify-keystore-settings-webwork.input.smime.public.keystore.verification.typeError.title");
        status.message = i18n.getText("snotify-keystore-settings-webwork.input.smime.public.keystore.verification.typeError.message", (Object)keyStoreType);
        return Collections.singletonList(status);
    }

    private List<VerificationStatus> verifyPgpUserUpload(String email) {
        log.info("Verifying PGP key upload for user.");
        SnotifyUserProperties userProps = new SnotifyUserProperties();
        UserKeySourceVerification verification = new UserKeySourceVerification(ECryptographyType.PGP, userProps, this.getI18n());
        verification.useEmail(email, BitbucketUser::lookupUser);
        return verification.verify();
    }

    private List<VerificationStatus> verifyPgpPublicKeystore(String keyStoreLocation, String keystoreType, String email) {
        log.info("Verifying PGP public key store at location: {}", (Object)keyStoreLocation);
        ISnotifyI18n i18n = this.getI18n();
        switch (keystoreType) {
            case "KEYRING": {
                PgpPublicKeyStoreVerification keyringVerification = new PgpPublicKeyStoreVerification(keyStoreLocation, i18n);
                keyringVerification.setEmail(email);
                return keyringVerification.verify();
            }
            case "KBX": {
                PgpKeyBoxVerification kbxVerification = new PgpKeyBoxVerification(keyStoreLocation, i18n);
                kbxVerification.setEmail(email);
                return kbxVerification.verify();
            }
        }
        log.error("Unknown key store type encountered: {}", (Object)keyStoreLocation);
        VerificationStatus status = new VerificationStatus();
        status.status = EVerificationStatus.ERROR;
        status.title = i18n.getText("snotify-keystore-settings-webwork.input.pgp.public.keystore.verification.typeError.title");
        status.message = i18n.getText("snotify-keystore-settings-webwork.input.pgp.public.keystore.verification.typeError.message", (Object)keyStoreLocation);
        return Collections.singletonList(status);
    }

    private List<VerificationStatus> verifyPgpPublicKeyserver(String keyServerLocation, String email) {
        AKeySourceVerification verification;
        URI uri;
        log.info("Verifying PGP public key server at location: {}", (Object)keyServerLocation);
        ISnotifyI18n i18n = this.getI18n();
        try {
            uri = new URI(keyServerLocation);
        }
        catch (URISyntaxException e) {
            log.debug("Given url was not valid: {}", (Object)keyServerLocation);
            VerificationStatus status = new VerificationStatus();
            status.status = EVerificationStatus.ERROR;
            status.title = i18n.getText("snotify-keystore-settings-webwork.input.smime.public.keyserver.verification.invalidUrl.title");
            status.message = i18n.getText("snotify-keystore-settings-webwork.input.smime.public.keyserver.verification.invalid.message", (Object)keyServerLocation);
            return Collections.singletonList(status);
        }
        if (uri.getScheme() != null && uri.getScheme().startsWith("ldap")) {
            LdapConnector connector = new LdapConnector();
            connector.setHost(uri.getHost());
            connector.setPort(uri.getPort());
            connector.setSsl(uri.getScheme().equals("ldaps"));
            PgpGlobalDirectoryLoader loader = new PgpGlobalDirectoryLoader(connector);
            PgpGlobalDirectoryVerification pgdVerification = new PgpGlobalDirectoryVerification(loader, i18n);
            pgdVerification.setEmail(email);
            verification = pgdVerification;
        } else {
            PgpKeyServerLoader loader = new PgpKeyServerLoader(keyServerLocation);
            verification = new PgpKeyServerVerification(loader, email, i18n);
        }
        return verification.verify();
    }

    private List<VerificationStatus> verifySmimePublicUserDirectory(String email) {
        AtlassianLdapConnector connector;
        Directory directory;
        log.info("Verifying user directory for S/MIME public certificates.");
        ISnotifyI18n i18n = this.getI18n();
        BitbucketUser userFromEmail = BitbucketUser.lookupUser(email);
        if (userFromEmail == null) {
            log.debug("Could not find user with email <{}>.", (Object)email);
            VerificationStatus status = new VerificationStatus();
            status.status = EVerificationStatus.WARNING;
            status.title = i18n.getText("snotify-keystore-settings-webwork.input.smime.public.directory.verification.unknownUser.title");
            status.message = i18n.getText("snotify-keystore-settings-webwork.input.smime.public.directory.verification.unknownUser.message", (Object)email);
            return Collections.singletonList(status);
        }
        DetailedUser user = this.getDetailedUser(userFromEmail.getActualUser());
        if (user == null) {
            log.debug("Could not find a detailed user for user: {}", (Object)this.getUser().getActualUser());
            VerificationStatus status = new VerificationStatus();
            status.status = EVerificationStatus.WARNING;
            status.title = i18n.getText("snotify-keystore-settings-webwork.input.smime.public.directory.verification.dirUserNotFound.title");
            status.message = i18n.getText("snotify-keystore-settings-webwork.input.smime.public.directory.verification.dirUserNotFound.message", (Object)this.getUser().getDisplayName());
            return Collections.singletonList(status);
        }
        String directoryName = user.getDirectoryName();
        String userName = user.getName();
        DirectoryManager manager = (DirectoryManager)ComponentLocator.getComponent(DirectoryManager.class);
        try {
            directory = manager.findDirectoryByName(directoryName);
        }
        catch (DirectoryNotFoundException e) {
            log.error("Could not find directory with name " + directoryName + ". Error message: " + e.getMessage(), (Throwable)e);
            VerificationStatus status = new VerificationStatus();
            status.status = EVerificationStatus.ERROR;
            status.title = i18n.getText("snotify-keystore-settings-webwork.input.smime.public.directory.verification.dirNotFound.title");
            status.message = i18n.getText("snotify-keystore-settings-webwork.input.smime.public.directory.verification.dirNotFound.message", (Object)directoryName, (Object)e.getMessage());
            return Collections.singletonList(status);
        }
        if (!AtlassianLdapConnector.isConnector(directory)) {
            log.debug("Directory {} is probably not an LDAP directory.", (Object)directory.getName());
            VerificationStatus status = new VerificationStatus();
            status.status = EVerificationStatus.WARNING;
            status.title = i18n.getText("snotify-keystore-settings-webwork.input.smime.public.directory.verification.dirNotLdap.title");
            status.message = i18n.getText("snotify-keystore-settings-webwork.input.smime.public.directory.verification.dirNotLdap.message", (Object)directory.getName(), (Object)userName);
            return Collections.singletonList(status);
        }
        try {
            connector = AtlassianLdapConnector.createConnector(directory);
        }
        catch (ConfigurationException e) {
            log.error("Could not create an LDAP connection from directory " + directory.getName() + ". Error message: " + e.getMessage());
            VerificationStatus status = new VerificationStatus();
            status.status = EVerificationStatus.ERROR;
            status.title = i18n.getText("snotify-keystore-settings-webwork.input.smime.public.directory.verification.dirError.title");
            status.message = i18n.getText("snotify-keystore-settings-webwork.input.smime.public.directory.verification.dirError.message", (Object)e.getMessage());
            return Collections.singletonList(status);
        }
        connector.setDisableTrustCheck(connector.isDisableTrustCheck() && this.getAppProps().getBoolean(EProperty.TWEAK_USER_DIRECTORY_INSECURE));
        SmimeLdapLoader loader = new SmimeLdapLoader(connector);
        loader.setKeySource(EKeySource.ATLASSIAN_DIRECTORY);
        if (this.getAppProps().hasKey(EProperty.TWEAK_LDAP_CONTEXT_REFERRAL)) {
            loader.setEnvironment(Collections.singletonMap("java.naming.referral", this.getAppProps().getString(EProperty.TWEAK_LDAP_CONTEXT_REFERRAL)));
        }
        loader.setExpectP7b(this.getAppProps().getBoolean(EProperty.TWEAK_EXPECT_P7B_IN_LDAP));
        String userFilter = "(" + connector.getUserNameKey() + "=" + userName + ")";
        SmimeLdapVerification verification = new SmimeLdapVerification(loader, userFilter, i18n);
        verification.setEmail(user.getEmailAddress());
        verification.setUserNotFoundStatus(EVerificationStatus.ERROR);
        return verification.verify();
    }

    private List<VerificationStatus> verifySmimePublicLdap(ExternalLdapHandlerProvider ldapProvider, String email) {
        LdapConnector connector;
        log.info("Verifying LDAP configuration for S/MIME public certificates.");
        ISnotifyI18n i18n = this.getI18n();
        try {
            connector = ldapProvider.buildConnector();
        }
        catch (ConfigurationException e) {
            log.error("Could not create an external LDAP connection. Error message: " + e.getMessage());
            VerificationStatus status = new VerificationStatus();
            status.status = EVerificationStatus.ERROR;
            status.title = i18n.getText("snotify-keystore-settings-webwork.input.smime.public.ldap.verification.inputError.title");
            status.message = i18n.getText("snotify-keystore-settings-webwork.input.smime.public.ldap.verification.inputError.message", (Object)e.getMessage());
            return Collections.singletonList(status);
        }
        connector.setDisableTrustCheck(this.getAppProps().getBoolean(EProperty.TWEAK_EXTERNAL_LDAP_INSECURE));
        String mailAttr = (String)ldapProvider.getValue("smimePublicLdapMailAttr");
        SmimeLdapLoader loader = new SmimeLdapLoader(connector);
        if (this.getAppProps().hasKey(EProperty.TWEAK_LDAP_CONTEXT_REFERRAL)) {
            loader.setEnvironment(Collections.singletonMap("java.naming.referral", this.getAppProps().getString(EProperty.TWEAK_LDAP_CONTEXT_REFERRAL)));
        }
        String userFilter = "(" + mailAttr + "=" + email + ")";
        SmimeLdapVerification verification = new SmimeLdapVerification(loader, userFilter, i18n);
        verification.setEmail(email);
        return verification.verify();
    }

    private DetailedUser getDetailedUser(ApplicationUser user) {
        if (user instanceof DetailedUser) {
            return (DetailedUser)user;
        }
        UserAdminService service = (UserAdminService)ComponentLocator.getComponent(UserAdminService.class);
        return service.getUserDetails(user);
    }

    private void clearCache() {
        this.getAppProps().setLong(EProperty.EXPIRE_KEYS_PUBLIC_TIMESTAMP, System.currentTimeMillis());
    }

    private EEncryptionTypePriority getTypePriority() {
        return this.getAppProps().getEnum(EProperty.ENCRYPTION_TYPE_PRIORITY, EEncryptionTypePriority.class);
    }

    private ValueHandlerContainer createValueHandlerProvider() {
        ValueHandlerContainer container = new ValueHandlerContainer();
        container.add(new InputHandler(SMIME_PUBLIC_KEYSTORE_LOCATION_ID, this.getAppProps(), EProperty.PUBLIC_KEYSTORE_SMIME_LOCATION));
        container.add(new RadioHandler(SMIME_PUBLIC_KEYSTORE_TYPE_ID, this.getAppProps(), EProperty.PUBLIC_KEYSTORE_SMIME_TYPE));
        container.add(new CheckBoxHandler(USE_SMIME_PUBLIC_USER_DIRECTORY_ID, this.getAppProps(), EProperty.USER_DIRECTORY_LDAP_QUERY_SMIME));
        container.add(new CheckBoxHandler(ALLOW_SMIME_CERTIFICATE_OVERWRITE_ID, this.getAppProps(), EProperty.ALLOW_SMIME_CERTIFICATE_OVERWRITE));
        container.add(new InputHandler(PGP_PUBLIC_KEYSTORE_LOCATION_ID, this.getAppProps(), EProperty.PUBLIC_KEYSTORE_PGP_LOCATION));
        container.add(new RadioHandler(PGP_PUBLIC_KEYSTORE_TYPE_ID, this.getAppProps(), EProperty.PUBLIC_KEYSTORE_PGP_TYPE));
        container.add(new InputHandler(PGP_PUBLIC_KEYSERVER_LOCATION_ID, this.getAppProps(), EProperty.PUBLIC_KEYSERVER_PGP_LOCATION));
        container.add(new CheckBoxHandler(ALLOW_PGP_PUBLIC_KEY_OVERWRITE_ID, this.getAppProps(), EProperty.ALLOW_PGP_PUBLIC_KEY_OVERWRITE));
        return container;
    }

    private ExternalLdapHandlerProvider createLdapProvider() {
        return new ExternalLdapHandlerProvider(this.getAppProps());
    }

    public boolean isSmimeSelected(ECryptographyType cryptoType) {
        if (cryptoType == ECryptographyType.SMIME) {
            return true;
        }
        if (cryptoType == ECryptographyType.PGP) {
            return false;
        }
        switch (this.getTypePriority()) {
            case SMIME_ONLY: 
            case SMIME_PREFERED: {
                return true;
            }
            case PGP_ONLY: 
            case PGP_PREFERED: {
                return false;
            }
        }
        log.error("Type priority not yet implemented: {}", (Object)this.getTypePriority());
        return false;
    }

    public boolean isPgpSelected(ECryptographyType cryptoType) {
        if (cryptoType == ECryptographyType.PGP) {
            return true;
        }
        if (cryptoType == ECryptographyType.SMIME) {
            return false;
        }
        switch (this.getTypePriority()) {
            case SMIME_ONLY: 
            case SMIME_PREFERED: {
                return false;
            }
            case PGP_ONLY: 
            case PGP_PREFERED: {
                return true;
            }
        }
        log.error("Type priority not yet implemented: {}", (Object)this.getTypePriority());
        return false;
    }

    private ECryptographyType getActiveTab(ECryptographyType type) {
        if (this.isSmimeSelected(type)) {
            return ECryptographyType.SMIME;
        }
        if (this.isPgpSelected(type)) {
            return ECryptographyType.PGP;
        }
        log.warn("Unknown tab selected. Defaulting to S/MIME tab.");
        return ECryptographyType.SMIME;
    }

    private ECryptographyType getCryptoTypeSafe(String type) {
        if (StringUtils.isBlank((String)type)) {
            return null;
        }
        try {
            return ECryptographyType.valueOf(type);
        }
        catch (Exception e) {
            log.warn("Unknown cryptography type \"" + type + "\" encountered. Defaulting to S/MIME. Error message: " + e.getMessage(), (Throwable)e);
            return ECryptographyType.SMIME;
        }
    }
}

