/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.bcpg;

import java.io.IOException;
import java.io.OutputStream;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;

public class SignatureSubpacket {
    int type;
    boolean critical;
    boolean isLongLength;
    protected byte[] data;

    protected SignatureSubpacket(int type, boolean critical, boolean isLongLength, byte[] data) {
        this.type = type;
        this.critical = critical;
        this.isLongLength = isLongLength;
        this.data = data;
    }

    public int getType() {
        return this.type;
    }

    public boolean isCritical() {
        return this.critical;
    }

    public boolean isLongLength() {
        return this.isLongLength;
    }

    public byte[] getData() {
        return this.data;
    }

    public void encode(OutputStream out) throws IOException {
        int bodyLen = this.data.length + 1;
        if (this.isLongLength) {
            out.write(255);
            out.write((byte)(bodyLen >> 24));
            out.write((byte)(bodyLen >> 16));
            out.write((byte)(bodyLen >> 8));
            out.write((byte)bodyLen);
        } else if (bodyLen < 192) {
            out.write((byte)bodyLen);
        } else if (bodyLen <= 8383) {
            out.write((byte)(((bodyLen -= 192) >> 8 & 0xFF) + 192));
            out.write((byte)bodyLen);
        } else {
            out.write(255);
            out.write((byte)(bodyLen >> 24));
            out.write((byte)(bodyLen >> 16));
            out.write((byte)(bodyLen >> 8));
            out.write((byte)bodyLen);
        }
        if (this.critical) {
            out.write(0x80 | this.type);
        } else {
            out.write(this.type);
        }
        out.write(this.data);
    }

    public int hashCode() {
        return (this.critical ? 1 : 0) + 7 * this.type + 49 * Arrays.hashCode(this.data);
    }

    public boolean equals(Object other) {
        if (other == this) {
            return true;
        }
        if (other instanceof SignatureSubpacket) {
            SignatureSubpacket ot = (SignatureSubpacket)other;
            if (this.type == ot.type && this.critical == ot.critical) {
                return Arrays.areEqual(this.data, ot.data);
            }
        }
        return false;
    }
}

