/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.cert.crmf;

import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Encodable;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import net.savignano.thirdparty.org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import net.savignano.thirdparty.org.bouncycastle.asn1.cms.ContentInfo;
import net.savignano.thirdparty.org.bouncycastle.asn1.cms.EnvelopedData;
import net.savignano.thirdparty.org.bouncycastle.asn1.crmf.CRMFObjectIdentifiers;
import net.savignano.thirdparty.org.bouncycastle.asn1.crmf.EncryptedKey;
import net.savignano.thirdparty.org.bouncycastle.asn1.crmf.PKIArchiveOptions;
import net.savignano.thirdparty.org.bouncycastle.cert.crmf.CRMFException;
import net.savignano.thirdparty.org.bouncycastle.cert.crmf.Control;
import net.savignano.thirdparty.org.bouncycastle.cms.CMSEnvelopedData;
import net.savignano.thirdparty.org.bouncycastle.cms.CMSException;

public class PKIArchiveControl
implements Control {
    public static final int encryptedPrivKey = 0;
    public static final int keyGenParameters = 1;
    public static final int archiveRemGenPrivKey = 2;
    private static final ASN1ObjectIdentifier type = CRMFObjectIdentifiers.id_regCtrl_pkiArchiveOptions;
    private final PKIArchiveOptions pkiArchiveOptions;

    public PKIArchiveControl(PKIArchiveOptions pkiArchiveOptions) {
        this.pkiArchiveOptions = pkiArchiveOptions;
    }

    public ASN1ObjectIdentifier getType() {
        return type;
    }

    public ASN1Encodable getValue() {
        return this.pkiArchiveOptions;
    }

    public int getArchiveType() {
        return this.pkiArchiveOptions.getType();
    }

    public boolean isEnvelopedData() {
        EncryptedKey encKey = EncryptedKey.getInstance(this.pkiArchiveOptions.getValue());
        return !encKey.isEncryptedValue();
    }

    public CMSEnvelopedData getEnvelopedData() throws CRMFException {
        try {
            EncryptedKey encKey = EncryptedKey.getInstance(this.pkiArchiveOptions.getValue());
            EnvelopedData data = EnvelopedData.getInstance(encKey.getValue());
            return new CMSEnvelopedData(new ContentInfo(CMSObjectIdentifiers.envelopedData, data));
        }
        catch (CMSException e) {
            throw new CRMFException("CMS parsing error: " + e.getMessage(), e.getCause());
        }
        catch (Exception e) {
            throw new CRMFException("CRMF parsing error: " + e.getMessage(), e);
        }
    }
}

