/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.cms;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.util.Collections;
import net.savignano.thirdparty.org.bouncycastle.asn1.BEROctetString;
import net.savignano.thirdparty.org.bouncycastle.asn1.BERSet;
import net.savignano.thirdparty.org.bouncycastle.asn1.cms.AttributeTable;
import net.savignano.thirdparty.org.bouncycastle.asn1.cms.CMSObjectIdentifiers;
import net.savignano.thirdparty.org.bouncycastle.asn1.cms.ContentInfo;
import net.savignano.thirdparty.org.bouncycastle.asn1.cms.EncryptedContentInfo;
import net.savignano.thirdparty.org.bouncycastle.asn1.cms.EncryptedData;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.AlgorithmIdentifier;
import net.savignano.thirdparty.org.bouncycastle.cms.CMSEncryptedData;
import net.savignano.thirdparty.org.bouncycastle.cms.CMSEncryptedGenerator;
import net.savignano.thirdparty.org.bouncycastle.cms.CMSException;
import net.savignano.thirdparty.org.bouncycastle.cms.CMSTypedData;
import net.savignano.thirdparty.org.bouncycastle.operator.OutputEncryptor;

public class CMSEncryptedDataGenerator
extends CMSEncryptedGenerator {
    private CMSEncryptedData doGenerate(CMSTypedData content, OutputEncryptor contentEncryptor) throws CMSException {
        ByteArrayOutputStream bOut = new ByteArrayOutputStream();
        try {
            OutputStream cOut = contentEncryptor.getOutputStream(bOut);
            content.write(cOut);
            cOut.close();
        }
        catch (IOException e) {
            throw new CMSException("");
        }
        byte[] encryptedContent = bOut.toByteArray();
        AlgorithmIdentifier encAlgId = contentEncryptor.getAlgorithmIdentifier();
        BEROctetString encContent = new BEROctetString(encryptedContent);
        EncryptedContentInfo eci = new EncryptedContentInfo(content.getContentType(), encAlgId, encContent);
        BERSet unprotectedAttrSet = null;
        if (this.unprotectedAttributeGenerator != null) {
            AttributeTable attrTable = this.unprotectedAttributeGenerator.getAttributes(Collections.EMPTY_MAP);
            unprotectedAttrSet = new BERSet(attrTable.toASN1EncodableVector());
        }
        ContentInfo contentInfo = new ContentInfo(CMSObjectIdentifiers.encryptedData, new EncryptedData(eci, unprotectedAttrSet));
        return new CMSEncryptedData(contentInfo);
    }

    public CMSEncryptedData generate(CMSTypedData content, OutputEncryptor contentEncryptor) throws CMSException {
        return this.doGenerate(content, contentEncryptor);
    }
}

