/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.crypto.digests;

import java.io.ByteArrayOutputStream;
import net.savignano.thirdparty.org.bouncycastle.crypto.DataLengthException;
import net.savignano.thirdparty.org.bouncycastle.crypto.Digest;
import net.savignano.thirdparty.org.bouncycastle.crypto.OutputLengthException;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;
import net.savignano.thirdparty.org.bouncycastle.util.Pack;

public class XoodyakDigest
implements Digest {
    private byte[] state;
    private int phase;
    private MODE mode;
    private int Rabsorb;
    private final int f_bPrime = 48;
    private final int Rhash = 16;
    private final int PhaseDown = 1;
    private final int PhaseUp = 2;
    private final int NLANES = 12;
    private final int NROWS = 3;
    private final int NCOLUMS = 4;
    private final int MAXROUNDS = 12;
    private final int TAGLEN = 16;
    private final int[] RC = new int[]{88, 56, 960, 208, 288, 20, 96, 44, 896, 240, 416, 18};
    private final ByteArrayOutputStream buffer = new ByteArrayOutputStream();

    public XoodyakDigest() {
        this.state = new byte[48];
        this.reset();
    }

    public String getAlgorithmName() {
        return "Xoodyak Hash";
    }

    public int getDigestSize() {
        return 32;
    }

    public void update(byte input) {
        this.buffer.write(input);
    }

    public void update(byte[] input, int inOff, int len) {
        if (inOff + len > input.length) {
            throw new DataLengthException("input buffer too short");
        }
        this.buffer.write(input, inOff, len);
    }

    public int doFinal(byte[] output, int outOff) {
        int splitLen;
        if (32 + outOff > output.length) {
            throw new OutputLengthException("output buffer is too short");
        }
        byte[] input = this.buffer.toByteArray();
        int inOff = 0;
        int len = this.buffer.size();
        int Cd = 3;
        do {
            if (this.phase != 2) {
                this.Up(null, 0, 0, 0);
            }
            splitLen = Math.min(len, this.Rabsorb);
            this.Down(input, inOff, splitLen, Cd);
            Cd = 0;
            inOff += splitLen;
        } while ((len -= splitLen) != 0);
        this.Up(output, outOff, 16, 64);
        this.Down(null, 0, 0, 0);
        this.Up(output, outOff + 16, 16, 0);
        return 32;
    }

    public void reset() {
        Arrays.fill(this.state, (byte)0);
        this.phase = 2;
        this.mode = MODE.ModeHash;
        this.Rabsorb = 16;
        this.buffer.reset();
    }

    private void Up(byte[] Yi, int YiOff, int YiLen, int Cu) {
        if (this.mode != MODE.ModeHash) {
            this.state[47] = (byte)(this.state[47] ^ Cu);
        }
        int[] a = new int[12];
        Pack.littleEndianToInt(this.state, 0, a, 0, a.length);
        int[] b = new int[12];
        int[] p = new int[4];
        int[] e = new int[4];
        for (int i = 0; i < 12; ++i) {
            int y;
            int x;
            for (x = 0; x < 4; ++x) {
                p[x] = a[this.index(x, 0)] ^ a[this.index(x, 1)] ^ a[this.index(x, 2)];
            }
            for (x = 0; x < 4; ++x) {
                y = p[x + 3 & 3];
                e[x] = this.ROTL32(y, 5) ^ this.ROTL32(y, 14);
            }
            for (x = 0; x < 4; ++x) {
                for (y = 0; y < 3; ++y) {
                    int n = this.index(x, y);
                    a[n] = a[n] ^ e[x];
                }
            }
            for (x = 0; x < 4; ++x) {
                b[this.index((int)x, (int)0)] = a[this.index(x, 0)];
                b[this.index((int)x, (int)1)] = a[this.index(x + 3, 1)];
                b[this.index((int)x, (int)2)] = this.ROTL32(a[this.index(x, 2)], 11);
            }
            b[0] = b[0] ^ this.RC[i];
            for (x = 0; x < 4; ++x) {
                for (y = 0; y < 3; ++y) {
                    a[this.index((int)x, (int)y)] = b[this.index(x, y)] ^ ~b[this.index(x, y + 1)] & b[this.index(x, y + 2)];
                }
            }
            for (x = 0; x < 4; ++x) {
                b[this.index((int)x, (int)0)] = a[this.index(x, 0)];
                b[this.index((int)x, (int)1)] = this.ROTL32(a[this.index(x, 1)], 1);
                b[this.index((int)x, (int)2)] = this.ROTL32(a[this.index(x + 2, 2)], 8);
            }
            System.arraycopy(b, 0, a, 0, 12);
        }
        Pack.intToLittleEndian(a, 0, a.length, this.state, 0);
        this.phase = 2;
        if (Yi != null) {
            System.arraycopy(this.state, 0, Yi, YiOff, YiLen);
        }
    }

    void Down(byte[] Xi, int XiOff, int XiLen, int Cd) {
        int i = 0;
        while (i < XiLen) {
            int n = i++;
            this.state[n] = (byte)(this.state[n] ^ Xi[XiOff++]);
        }
        int n = XiLen;
        this.state[n] = (byte)(this.state[n] ^ 1);
        this.state[47] = (byte)(this.state[47] ^ (this.mode == MODE.ModeHash ? Cd & 1 : Cd));
        this.phase = 1;
    }

    private int index(int x, int y) {
        return y % 3 * 4 + x % 4;
    }

    private int ROTL32(int a, int offset) {
        return a << (offset & 0x1F) ^ a >>> (32 - offset & 0x1F);
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    static enum MODE {
        ModeHash,
        ModeKeyed;

    }
}

