/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.its;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.util.ArrayList;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Object;
import net.savignano.thirdparty.org.bouncycastle.its.ETSIRecipientInfo;
import net.savignano.thirdparty.org.bouncycastle.oer.Element;
import net.savignano.thirdparty.org.bouncycastle.oer.OEREncoder;
import net.savignano.thirdparty.org.bouncycastle.oer.OERInputStream;
import net.savignano.thirdparty.org.bouncycastle.oer.its.etsi103097.EtsiTs103097DataEncrypted;
import net.savignano.thirdparty.org.bouncycastle.oer.its.ieee1609dot2.EncryptedData;
import net.savignano.thirdparty.org.bouncycastle.oer.its.ieee1609dot2.Ieee1609Dot2Content;
import net.savignano.thirdparty.org.bouncycastle.oer.its.ieee1609dot2.RecipientInfo;
import net.savignano.thirdparty.org.bouncycastle.oer.its.template.etsi103097.EtsiTs103097Module;
import net.savignano.thirdparty.org.bouncycastle.util.CollectionStore;
import net.savignano.thirdparty.org.bouncycastle.util.Store;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class ETSIEncryptedData {
    private static final Element oerDef = EtsiTs103097Module.EtsiTs103097Data_Encrypted.build();
    private final EncryptedData encryptedData;

    public ETSIEncryptedData(byte[] oerEncoded) throws IOException {
        this(new ByteArrayInputStream(oerEncoded));
    }

    public ETSIEncryptedData(InputStream str) throws IOException {
        OERInputStream oerIn = str instanceof OERInputStream ? (OERInputStream)str : new OERInputStream(str);
        ASN1Object asn1 = oerIn.parse(oerDef);
        Ieee1609Dot2Content content = EtsiTs103097DataEncrypted.getInstance(asn1).getContent();
        if (content.getChoice() != 2) {
            throw new IllegalStateException("EtsiTs103097Data-Encrypted did not have encrypted data content");
        }
        this.encryptedData = EncryptedData.getInstance(content.getIeee1609Dot2Content());
    }

    ETSIEncryptedData(EncryptedData data) {
        this.encryptedData = data;
    }

    public byte[] getEncoded() {
        return OEREncoder.toByteArray(new EtsiTs103097DataEncrypted(Ieee1609Dot2Content.encryptedData(this.encryptedData)), oerDef);
    }

    public EncryptedData getEncryptedData() {
        return this.encryptedData;
    }

    public Store<ETSIRecipientInfo> getRecipients() {
        ArrayList<ETSIRecipientInfo> recipients = new ArrayList<ETSIRecipientInfo>();
        for (RecipientInfo ri : this.encryptedData.getRecipients().getRecipientInfos()) {
            recipients.add(new ETSIRecipientInfo(this.encryptedData, ri));
        }
        return new CollectionStore<ETSIRecipientInfo>(recipients);
    }
}

