/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.jcajce.provider.digest;

import net.savignano.thirdparty.org.bouncycastle.asn1.teletrust.TeleTrusTObjectIdentifiers;
import net.savignano.thirdparty.org.bouncycastle.crypto.CipherKeyGenerator;
import net.savignano.thirdparty.org.bouncycastle.crypto.digests.RIPEMD128Digest;
import net.savignano.thirdparty.org.bouncycastle.crypto.macs.HMac;
import net.savignano.thirdparty.org.bouncycastle.jcajce.provider.config.ConfigurableProvider;
import net.savignano.thirdparty.org.bouncycastle.jcajce.provider.digest.BCMessageDigest;
import net.savignano.thirdparty.org.bouncycastle.jcajce.provider.digest.DigestAlgorithmProvider;
import net.savignano.thirdparty.org.bouncycastle.jcajce.provider.symmetric.util.BaseKeyGenerator;
import net.savignano.thirdparty.org.bouncycastle.jcajce.provider.symmetric.util.BaseMac;

public class RIPEMD128 {
    private RIPEMD128() {
    }

    public static class Mappings
    extends DigestAlgorithmProvider {
        private static final String PREFIX = RIPEMD128.class.getName();

        public void configure(ConfigurableProvider provider) {
            provider.addAlgorithm("MessageDigest.RIPEMD128", PREFIX + "$Digest");
            provider.addAlgorithm("Alg.Alias.MessageDigest." + TeleTrusTObjectIdentifiers.ripemd128, "RIPEMD128");
            this.addHMACAlgorithm(provider, "RIPEMD128", PREFIX + "$HashMac", PREFIX + "$KeyGenerator");
        }
    }

    public static class KeyGenerator
    extends BaseKeyGenerator {
        public KeyGenerator() {
            super("HMACRIPEMD128", 128, new CipherKeyGenerator());
        }
    }

    public static class HashMac
    extends BaseMac {
        public HashMac() {
            super(new HMac(new RIPEMD128Digest()));
        }
    }

    public static class Digest
    extends BCMessageDigest
    implements Cloneable {
        public Digest() {
            super(new RIPEMD128Digest());
        }

        public Object clone() throws CloneNotSupportedException {
            Digest d = (Digest)super.clone();
            d.digest = new RIPEMD128Digest((RIPEMD128Digest)this.digest);
            return d;
        }
    }
}

