/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.oer.its.ieee1609dot2;

import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.Iterator;
import java.util.List;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Encodable;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Object;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Sequence;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERSequence;
import net.savignano.thirdparty.org.bouncycastle.oer.its.ieee1609dot2.PsidGroupPermissions;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class SequenceOfPsidGroupPermissions
extends ASN1Object {
    private final List<PsidGroupPermissions> psidGroupPermissions;

    public SequenceOfPsidGroupPermissions(List<PsidGroupPermissions> groupPermissions) {
        this.psidGroupPermissions = Collections.unmodifiableList(groupPermissions);
    }

    private SequenceOfPsidGroupPermissions(ASN1Sequence seq) {
        ArrayList<PsidGroupPermissions> l = new ArrayList<PsidGroupPermissions>();
        Iterator<ASN1Encodable> it = seq.iterator();
        while (it.hasNext()) {
            l.add(PsidGroupPermissions.getInstance(it.next()));
        }
        this.psidGroupPermissions = Collections.unmodifiableList(l);
    }

    public static SequenceOfPsidGroupPermissions getInstance(Object obj) {
        if (obj instanceof SequenceOfPsidGroupPermissions) {
            return (SequenceOfPsidGroupPermissions)obj;
        }
        if (obj != null) {
            return new SequenceOfPsidGroupPermissions(ASN1Sequence.getInstance(obj));
        }
        return null;
    }

    public List<PsidGroupPermissions> getPsidGroupPermissions() {
        return this.psidGroupPermissions;
    }

    public static Builder builder() {
        return new Builder();
    }

    @Override
    public ASN1Primitive toASN1Primitive() {
        return new DERSequence(this.psidGroupPermissions.toArray(new PsidGroupPermissions[0]));
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    public static class Builder {
        private final List<PsidGroupPermissions> groupPermissions = new ArrayList<PsidGroupPermissions>();

        public Builder setGroupPermissions(List<PsidGroupPermissions> groupPermissions) {
            this.groupPermissions.addAll(groupPermissions);
            return this;
        }

        public Builder addGroupPermission(PsidGroupPermissions ... permissions) {
            this.groupPermissions.addAll(Arrays.asList(permissions));
            return this;
        }

        public SequenceOfPsidGroupPermissions createSequenceOfPsidGroupPermissions() {
            return new SequenceOfPsidGroupPermissions(this.groupPermissions);
        }
    }
}

