/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.oer.its.ieee1609dot2dot1;

import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Choice;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Encodable;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Object;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1Primitive;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1TaggedObject;
import net.savignano.thirdparty.org.bouncycastle.asn1.DERTaggedObject;
import net.savignano.thirdparty.org.bouncycastle.oer.its.ieee1609dot2.basetypes.PublicEncryptionKey;
import net.savignano.thirdparty.org.bouncycastle.oer.its.ieee1609dot2dot1.ButterflyExpansion;
import net.savignano.thirdparty.org.bouncycastle.oer.its.ieee1609dot2dot1.ButterflyParamsOriginal;

public class AdditionalParams
extends ASN1Object
implements ASN1Choice {
    public static final int original = 0;
    public static final int unified = 1;
    public static final int compactUnified = 2;
    public static final int encryptionKey = 3;
    protected final int choice;
    protected final ASN1Encodable additionalParams;

    private AdditionalParams(int choice, ASN1Encodable additionalParams) {
        switch (choice) {
            case 0: {
                this.additionalParams = ButterflyParamsOriginal.getInstance(additionalParams);
                break;
            }
            case 1: 
            case 2: {
                this.additionalParams = ButterflyExpansion.getInstance(additionalParams);
                break;
            }
            case 3: {
                this.additionalParams = PublicEncryptionKey.getInstance(additionalParams);
                break;
            }
            default: {
                throw new IllegalArgumentException("invalid choice value " + choice);
            }
        }
        this.choice = choice;
    }

    private AdditionalParams(ASN1TaggedObject ato) {
        this(ato.getTagNo(), ato.getObject());
    }

    public static AdditionalParams getInstance(Object o) {
        if (o instanceof AdditionalParams) {
            return (AdditionalParams)o;
        }
        if (o != null) {
            ASN1TaggedObject taggedObject = ASN1TaggedObject.getInstance(o);
            return new AdditionalParams(taggedObject.getTagNo(), taggedObject.getObject());
        }
        return null;
    }

    public static AdditionalParams original(ButterflyParamsOriginal value) {
        return new AdditionalParams(0, value);
    }

    public static AdditionalParams unified(ButterflyExpansion exp) {
        return new AdditionalParams(1, exp);
    }

    public static AdditionalParams compactUnified(ButterflyExpansion exp) {
        return new AdditionalParams(2, exp);
    }

    public static AdditionalParams encryptionKey(PublicEncryptionKey pek) {
        return new AdditionalParams(3, pek);
    }

    public int getChoice() {
        return this.choice;
    }

    public ASN1Encodable getAdditionalParams() {
        return this.additionalParams;
    }

    public ASN1Primitive toASN1Primitive() {
        return new DERTaggedObject(this.choice, this.additionalParams);
    }
}

