/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.crypto.crystals.dilithium;

import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.crystals.dilithium.DilithiumKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.crystals.dilithium.DilithiumParameters;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;

public class DilithiumPublicKeyParameters
extends DilithiumKeyParameters {
    final byte[] rho;
    final byte[] t1;

    public byte[] getRho() {
        return Arrays.clone(this.rho);
    }

    public byte[] getT1() {
        return Arrays.clone(this.t1);
    }

    public byte[] getEncoded() {
        return Arrays.concatenate(this.rho, this.t1);
    }

    public DilithiumPublicKeyParameters(DilithiumParameters params, byte[] encoding) {
        super(false, params);
        this.rho = Arrays.copyOfRange(encoding, 0, 32);
        this.t1 = Arrays.copyOfRange(encoding, 32, encoding.length);
    }

    public DilithiumPublicKeyParameters(DilithiumParameters params, byte[] rho, byte[] t1) {
        super(false, params);
        this.rho = Arrays.clone(rho);
        this.t1 = Arrays.clone(t1);
    }
}

