/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.provider.bike;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import java.util.Map;
import net.savignano.thirdparty.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import net.savignano.thirdparty.org.bouncycastle.crypto.CryptoServicesRegistrar;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.bike.BIKEKeyGenerationParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.bike.BIKEKeyPairGenerator;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.bike.BIKEParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.bike.BIKEPrivateKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.bike.BIKEPublicKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.provider.bike.BCBIKEPrivateKey;
import net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.provider.bike.BCBIKEPublicKey;
import net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.provider.util.SpecUtil;
import net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.spec.BIKEParameterSpec;
import net.savignano.thirdparty.org.bouncycastle.util.Strings;

public class BIKEKeyPairGeneratorSpi
extends KeyPairGenerator {
    private static Map parameters = new HashMap();
    BIKEKeyGenerationParameters param;
    BIKEKeyPairGenerator engine = new BIKEKeyPairGenerator();
    SecureRandom random = CryptoServicesRegistrar.getSecureRandom();
    boolean initialised = false;

    public BIKEKeyPairGeneratorSpi() {
        super("BIKE");
    }

    public void initialize(int strength, SecureRandom random) {
        throw new IllegalArgumentException("use AlgorithmParameterSpec");
    }

    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        String name = BIKEKeyPairGeneratorSpi.getNameFromParams(params);
        if (name == null) {
            throw new InvalidAlgorithmParameterException("invalid ParameterSpec: " + params);
        }
        this.param = new BIKEKeyGenerationParameters(random, (BIKEParameters)parameters.get(name));
        this.engine.init(this.param);
        this.initialised = true;
    }

    private static String getNameFromParams(AlgorithmParameterSpec paramSpec) {
        if (paramSpec instanceof BIKEParameterSpec) {
            BIKEParameterSpec bikeParams = (BIKEParameterSpec)paramSpec;
            return bikeParams.getName();
        }
        return Strings.toLowerCase(SpecUtil.getNameFrom(paramSpec));
    }

    public KeyPair generateKeyPair() {
        if (!this.initialised) {
            this.param = new BIKEKeyGenerationParameters(this.random, BIKEParameters.bike128);
            this.engine.init(this.param);
            this.initialised = true;
        }
        AsymmetricCipherKeyPair pair = this.engine.generateKeyPair();
        BIKEPublicKeyParameters pub = (BIKEPublicKeyParameters)pair.getPublic();
        BIKEPrivateKeyParameters priv = (BIKEPrivateKeyParameters)pair.getPrivate();
        return new KeyPair(new BCBIKEPublicKey(pub), new BCBIKEPrivateKey(priv));
    }

    static {
        parameters.put("bike128", BIKEParameters.bike128);
        parameters.put("bike192", BIKEParameters.bike192);
        parameters.put("bike256", BIKEParameters.bike256);
        parameters.put(BIKEParameterSpec.bike128.getName(), BIKEParameters.bike128);
        parameters.put(BIKEParameterSpec.bike192.getName(), BIKEParameters.bike192);
        parameters.put(BIKEParameterSpec.bike256.getName(), BIKEParameters.bike256);
    }
}

