/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.provider.falcon;

import java.io.IOException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import net.savignano.thirdparty.org.bouncycastle.asn1.x509.SubjectPublicKeyInfo;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.falcon.FalconPublicKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.util.PublicKeyFactory;
import net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.interfaces.FalconPublicKey;
import net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.provider.util.KeyUtil;
import net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.spec.FalconParameterSpec;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;
import net.savignano.thirdparty.org.bouncycastle.util.Strings;

public class BCFalconPublicKey
implements FalconPublicKey {
    private static final long serialVersionUID = 1L;
    private transient FalconPublicKeyParameters params;
    private transient String algorithm;
    private transient byte[] encoding;

    public BCFalconPublicKey(FalconPublicKeyParameters params) {
        this.init(params);
    }

    public BCFalconPublicKey(SubjectPublicKeyInfo keyInfo) throws IOException {
        this.init(keyInfo);
    }

    private void init(SubjectPublicKeyInfo keyInfo) throws IOException {
        this.init((FalconPublicKeyParameters)PublicKeyFactory.createKey(keyInfo));
    }

    private void init(FalconPublicKeyParameters params) {
        this.params = params;
        this.algorithm = Strings.toUpperCase(params.getParameters().getName());
    }

    public boolean equals(Object o) {
        if (o == this) {
            return true;
        }
        if (o instanceof BCFalconPublicKey) {
            BCFalconPublicKey otherKey = (BCFalconPublicKey)o;
            return Arrays.areEqual(this.getEncoded(), otherKey.getEncoded());
        }
        return false;
    }

    public int hashCode() {
        return Arrays.hashCode(this.getEncoded());
    }

    public final String getAlgorithm() {
        return this.algorithm;
    }

    public byte[] getEncoded() {
        if (this.encoding == null) {
            this.encoding = KeyUtil.getEncodedSubjectPublicKeyInfo(this.params);
        }
        return Arrays.clone(this.encoding);
    }

    public String getFormat() {
        return "X.509";
    }

    public FalconParameterSpec getParameterSpec() {
        return FalconParameterSpec.fromName(this.params.getParameters().getName());
    }

    FalconPublicKeyParameters getKeyParams() {
        return this.params;
    }

    private void readObject(ObjectInputStream in) throws IOException, ClassNotFoundException {
        in.defaultReadObject();
        byte[] enc = (byte[])in.readObject();
        this.init(SubjectPublicKeyInfo.getInstance(enc));
    }

    private void writeObject(ObjectOutputStream out) throws IOException {
        out.defaultWriteObject();
        out.writeObject(this.getEncoded());
    }
}

