/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.provider.saber;

import java.security.InvalidAlgorithmParameterException;
import java.security.KeyPair;
import java.security.KeyPairGenerator;
import java.security.SecureRandom;
import java.security.spec.AlgorithmParameterSpec;
import java.util.HashMap;
import java.util.Map;
import net.savignano.thirdparty.org.bouncycastle.crypto.AsymmetricCipherKeyPair;
import net.savignano.thirdparty.org.bouncycastle.crypto.CryptoServicesRegistrar;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.saber.SABERKeyGenerationParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.saber.SABERKeyPairGenerator;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.saber.SABERParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.saber.SABERPrivateKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.saber.SABERPublicKeyParameters;
import net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.provider.saber.BCSABERPrivateKey;
import net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.provider.saber.BCSABERPublicKey;
import net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.provider.util.SpecUtil;
import net.savignano.thirdparty.org.bouncycastle.pqc.jcajce.spec.SABERParameterSpec;
import net.savignano.thirdparty.org.bouncycastle.util.Strings;

public class SABERKeyPairGeneratorSpi
extends KeyPairGenerator {
    private static Map parameters = new HashMap();
    SABERKeyGenerationParameters param;
    SABERKeyPairGenerator engine = new SABERKeyPairGenerator();
    SecureRandom random = CryptoServicesRegistrar.getSecureRandom();
    boolean initialised = false;

    public SABERKeyPairGeneratorSpi() {
        super("SABER");
    }

    public void initialize(int strength, SecureRandom random) {
        throw new IllegalArgumentException("use AlgorithmParameterSpec");
    }

    public void initialize(AlgorithmParameterSpec params, SecureRandom random) throws InvalidAlgorithmParameterException {
        String name = SABERKeyPairGeneratorSpi.getNameFromParams(params);
        if (name == null) {
            throw new InvalidAlgorithmParameterException("invalid ParameterSpec: " + params);
        }
        this.param = new SABERKeyGenerationParameters(random, (SABERParameters)parameters.get(name));
        this.engine.init(this.param);
        this.initialised = true;
    }

    private static String getNameFromParams(AlgorithmParameterSpec paramSpec) {
        if (paramSpec instanceof SABERParameterSpec) {
            SABERParameterSpec saberParams = (SABERParameterSpec)paramSpec;
            return saberParams.getName();
        }
        return Strings.toLowerCase(SpecUtil.getNameFrom(paramSpec));
    }

    public KeyPair generateKeyPair() {
        if (!this.initialised) {
            this.param = new SABERKeyGenerationParameters(this.random, SABERParameters.firesaberkem256r3);
            this.engine.init(this.param);
            this.initialised = true;
        }
        AsymmetricCipherKeyPair pair = this.engine.generateKeyPair();
        SABERPublicKeyParameters pub = (SABERPublicKeyParameters)pair.getPublic();
        SABERPrivateKeyParameters priv = (SABERPrivateKeyParameters)pair.getPrivate();
        return new KeyPair(new BCSABERPublicKey(pub), new BCSABERPrivateKey(priv));
    }

    static {
        parameters.put(SABERParameterSpec.lightsaberkem128r3.getName(), SABERParameters.lightsaberkem128r3);
        parameters.put(SABERParameterSpec.saberkem128r3.getName(), SABERParameters.saberkem128r3);
        parameters.put(SABERParameterSpec.firesaberkem128r3.getName(), SABERParameters.firesaberkem128r3);
        parameters.put(SABERParameterSpec.lightsaberkem192r3.getName(), SABERParameters.lightsaberkem192r3);
        parameters.put(SABERParameterSpec.saberkem192r3.getName(), SABERParameters.saberkem192r3);
        parameters.put(SABERParameterSpec.firesaberkem192r3.getName(), SABERParameters.firesaberkem192r3);
        parameters.put(SABERParameterSpec.lightsaberkem256r3.getName(), SABERParameters.lightsaberkem256r3);
        parameters.put(SABERParameterSpec.saberkem256r3.getName(), SABERParameters.saberkem256r3);
        parameters.put(SABERParameterSpec.firesaberkem256r3.getName(), SABERParameters.firesaberkem256r3);
    }
}

