/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.legacy.crypto.sike;

import java.security.SecureRandom;
import net.savignano.thirdparty.org.bouncycastle.crypto.CryptoServicePurpose;
import net.savignano.thirdparty.org.bouncycastle.crypto.CryptoServicesRegistrar;
import net.savignano.thirdparty.org.bouncycastle.crypto.EncapsulatedSecretGenerator;
import net.savignano.thirdparty.org.bouncycastle.crypto.SecretWithEncapsulation;
import net.savignano.thirdparty.org.bouncycastle.crypto.constraints.DefaultServiceProperties;
import net.savignano.thirdparty.org.bouncycastle.crypto.params.AsymmetricKeyParameter;
import net.savignano.thirdparty.org.bouncycastle.pqc.crypto.util.SecretWithEncapsulationImpl;
import net.savignano.thirdparty.org.bouncycastle.pqc.legacy.crypto.sike.SIKEEngine;
import net.savignano.thirdparty.org.bouncycastle.pqc.legacy.crypto.sike.SIKEPublicKeyParameters;

public class SIKEKEMGenerator
implements EncapsulatedSecretGenerator {
    private final SecureRandom sr;

    public SIKEKEMGenerator(SecureRandom random) {
        this.sr = random;
    }

    public SecretWithEncapsulation generateEncapsulated(AsymmetricKeyParameter recipientKey) {
        CryptoServicesRegistrar.checkConstraints(new DefaultServiceProperties("SIKEKEM", 0, recipientKey, CryptoServicePurpose.ENCRYPTION));
        SIKEPublicKeyParameters key = (SIKEPublicKeyParameters)recipientKey;
        SIKEEngine engine = key.getParameters().getEngine();
        return this.generateEncapsulated(recipientKey, engine.getDefaultSessionKeySize());
    }

    public SecretWithEncapsulation generateEncapsulated(AsymmetricKeyParameter recipientKey, int sessionKeySizeInBits) {
        System.err.println("WARNING: the SIKE algorithm is only for research purposes, insecure");
        SIKEPublicKeyParameters key = (SIKEPublicKeyParameters)recipientKey;
        SIKEEngine engine = key.getParameters().getEngine();
        byte[] cipher_text = new byte[engine.getCipherTextSize()];
        byte[] sessionKey = new byte[sessionKeySizeInBits / 8];
        engine.crypto_kem_enc(cipher_text, sessionKey, key.getPublicKey(), this.sr);
        return new SecretWithEncapsulationImpl(sessionKey, cipher_text);
    }
}

