/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.legacy.math.linearalgebra;

import java.security.SecureRandom;
import net.savignano.thirdparty.org.bouncycastle.pqc.legacy.math.linearalgebra.GF2Vector;
import net.savignano.thirdparty.org.bouncycastle.pqc.legacy.math.linearalgebra.IntUtils;
import net.savignano.thirdparty.org.bouncycastle.pqc.legacy.math.linearalgebra.LittleEndianConversions;
import net.savignano.thirdparty.org.bouncycastle.pqc.legacy.math.linearalgebra.Matrix;
import net.savignano.thirdparty.org.bouncycastle.pqc.legacy.math.linearalgebra.Permutation;
import net.savignano.thirdparty.org.bouncycastle.pqc.legacy.math.linearalgebra.Vector;
import net.savignano.thirdparty.org.bouncycastle.util.Arrays;

public class GF2Matrix
extends Matrix {
    private int[][] matrix;
    private int length;

    public GF2Matrix(byte[] enc) {
        if (enc.length < 9) {
            throw new ArithmeticException("given array is not an encoded matrix over GF(2)");
        }
        this.numRows = LittleEndianConversions.OS2IP(enc, 0);
        this.numColumns = LittleEndianConversions.OS2IP(enc, 4);
        int n = (this.numColumns + 7 >>> 3) * this.numRows;
        if (this.numRows <= 0 || n != enc.length - 8) {
            throw new ArithmeticException("given array is not an encoded matrix over GF(2)");
        }
        this.length = this.numColumns + 31 >>> 5;
        this.matrix = new int[this.numRows][this.length];
        int q = this.numColumns >> 5;
        int r = this.numColumns & 0x1F;
        int count = 8;
        for (int i = 0; i < this.numRows; ++i) {
            int j = 0;
            while (j < q) {
                this.matrix[i][j] = LittleEndianConversions.OS2IP(enc, count);
                ++j;
                count += 4;
            }
            for (j = 0; j < r; j += 8) {
                int[] nArray = this.matrix[i];
                int n2 = q;
                nArray[n2] = nArray[n2] ^ (enc[count++] & 0xFF) << j;
            }
        }
    }

    public GF2Matrix(int numColumns, int[][] matrix) {
        if (matrix[0].length != numColumns + 31 >> 5) {
            throw new ArithmeticException("Int array does not match given number of columns.");
        }
        this.numColumns = numColumns;
        this.numRows = matrix.length;
        this.length = matrix[0].length;
        int rest = numColumns & 0x1F;
        int bitMask = rest == 0 ? -1 : (1 << rest) - 1;
        for (int i = 0; i < this.numRows; ++i) {
            int[] nArray = matrix[i];
            int n = this.length - 1;
            nArray[n] = nArray[n] & bitMask;
        }
        this.matrix = matrix;
    }

    public GF2Matrix(int n, char typeOfMatrix) {
        this(n, typeOfMatrix, new SecureRandom());
    }

    public GF2Matrix(int n, char typeOfMatrix, SecureRandom sr) {
        if (n <= 0) {
            throw new ArithmeticException("Size of matrix is non-positive.");
        }
        switch (typeOfMatrix) {
            case 'Z': {
                this.assignZeroMatrix(n, n);
                break;
            }
            case 'I': {
                this.assignUnitMatrix(n);
                break;
            }
            case 'L': {
                this.assignRandomLowerTriangularMatrix(n, sr);
                break;
            }
            case 'U': {
                this.assignRandomUpperTriangularMatrix(n, sr);
                break;
            }
            case 'R': {
                this.assignRandomRegularMatrix(n, sr);
                break;
            }
            default: {
                throw new ArithmeticException("Unknown matrix type.");
            }
        }
    }

    public GF2Matrix(GF2Matrix a) {
        this.numColumns = a.getNumColumns();
        this.numRows = a.getNumRows();
        this.length = a.length;
        this.matrix = new int[a.matrix.length][];
        for (int i = 0; i < this.matrix.length; ++i) {
            this.matrix[i] = IntUtils.clone(a.matrix[i]);
        }
    }

    private GF2Matrix(int m, int n) {
        if (n <= 0 || m <= 0) {
            throw new ArithmeticException("size of matrix is non-positive");
        }
        this.assignZeroMatrix(m, n);
    }

    private void assignZeroMatrix(int m, int n) {
        this.numRows = m;
        this.numColumns = n;
        this.length = n + 31 >>> 5;
        this.matrix = new int[this.numRows][this.length];
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.length; ++j) {
                this.matrix[i][j] = 0;
            }
        }
    }

    private void assignUnitMatrix(int n) {
        int i;
        this.numRows = n;
        this.numColumns = n;
        this.length = n + 31 >>> 5;
        this.matrix = new int[this.numRows][this.length];
        for (i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.length; ++j) {
                this.matrix[i][j] = 0;
            }
        }
        for (i = 0; i < this.numRows; ++i) {
            int rest = i & 0x1F;
            this.matrix[i][i >>> 5] = 1 << rest;
        }
    }

    private void assignRandomLowerTriangularMatrix(int n, SecureRandom sr) {
        this.numRows = n;
        this.numColumns = n;
        this.length = n + 31 >>> 5;
        this.matrix = new int[this.numRows][this.length];
        for (int i = 0; i < this.numRows; ++i) {
            int j;
            int q = i >>> 5;
            int r = i & 0x1F;
            int s = 31 - r;
            r = 1 << r;
            for (j = 0; j < q; ++j) {
                this.matrix[i][j] = sr.nextInt();
            }
            this.matrix[i][q] = sr.nextInt() >>> s | r;
            for (j = q + 1; j < this.length; ++j) {
                this.matrix[i][j] = 0;
            }
        }
    }

    private void assignRandomUpperTriangularMatrix(int n, SecureRandom sr) {
        this.numRows = n;
        this.numColumns = n;
        this.length = n + 31 >>> 5;
        this.matrix = new int[this.numRows][this.length];
        int rest = n & 0x1F;
        int help = rest == 0 ? -1 : (1 << rest) - 1;
        for (int i = 0; i < this.numRows; ++i) {
            int j;
            int r;
            int q = i >>> 5;
            int s = r = i & 0x1F;
            r = 1 << r;
            for (j = 0; j < q; ++j) {
                this.matrix[i][j] = 0;
            }
            this.matrix[i][q] = sr.nextInt() << s | r;
            for (j = q + 1; j < this.length; ++j) {
                this.matrix[i][j] = sr.nextInt();
            }
            int[] nArray = this.matrix[i];
            int n2 = this.length - 1;
            nArray[n2] = nArray[n2] & help;
        }
    }

    private void assignRandomRegularMatrix(int n, SecureRandom sr) {
        this.numRows = n;
        this.numColumns = n;
        this.length = n + 31 >>> 5;
        this.matrix = new int[this.numRows][this.length];
        GF2Matrix lm = new GF2Matrix(n, 'L', sr);
        GF2Matrix um = new GF2Matrix(n, 'U', sr);
        GF2Matrix rm = (GF2Matrix)lm.rightMultiply(um);
        Permutation perm = new Permutation(n, sr);
        int[] p = perm.getVector();
        for (int i = 0; i < n; ++i) {
            System.arraycopy(rm.matrix[i], 0, this.matrix[p[i]], 0, this.length);
        }
    }

    public static GF2Matrix[] createRandomRegularMatrixAndItsInverse(int n, SecureRandom sr) {
        GF2Matrix[] result = new GF2Matrix[2];
        int length = n + 31 >> 5;
        GF2Matrix lm = new GF2Matrix(n, 'L', sr);
        GF2Matrix um = new GF2Matrix(n, 'U', sr);
        GF2Matrix rm = (GF2Matrix)lm.rightMultiply(um);
        Permutation p = new Permutation(n, sr);
        int[] pVec = p.getVector();
        int[][] matrix = new int[n][length];
        for (int i = 0; i < n; ++i) {
            System.arraycopy(rm.matrix[pVec[i]], 0, matrix[i], 0, length);
        }
        result[0] = new GF2Matrix(n, matrix);
        GF2Matrix invLm = new GF2Matrix(n, 'I');
        for (int i = 0; i < n; ++i) {
            int rest = i & 0x1F;
            int q = i >>> 5;
            int r = 1 << rest;
            for (int j = i + 1; j < n; ++j) {
                int b = lm.matrix[j][q] & r;
                if (b == 0) continue;
                for (int k = 0; k <= q; ++k) {
                    int[] nArray = invLm.matrix[j];
                    int n2 = k;
                    nArray[n2] = nArray[n2] ^ invLm.matrix[i][k];
                }
            }
        }
        GF2Matrix invUm = new GF2Matrix(n, 'I');
        for (int i = n - 1; i >= 0; --i) {
            int rest = i & 0x1F;
            int q = i >>> 5;
            int r = 1 << rest;
            for (int j = i - 1; j >= 0; --j) {
                int b = um.matrix[j][q] & r;
                if (b == 0) continue;
                for (int k = q; k < length; ++k) {
                    int[] nArray = invUm.matrix[j];
                    int n3 = k;
                    nArray[n3] = nArray[n3] ^ invUm.matrix[i][k];
                }
            }
        }
        result[1] = (GF2Matrix)invUm.rightMultiply(invLm.rightMultiply(p));
        return result;
    }

    public int[][] getIntArray() {
        return this.matrix;
    }

    public int getLength() {
        return this.length;
    }

    public int[] getRow(int index) {
        return this.matrix[index];
    }

    public byte[] getEncoded() {
        int n = this.numColumns + 7 >>> 3;
        n *= this.numRows;
        byte[] enc = new byte[n += 8];
        LittleEndianConversions.I2OSP(this.numRows, enc, 0);
        LittleEndianConversions.I2OSP(this.numColumns, enc, 4);
        int q = this.numColumns >>> 5;
        int r = this.numColumns & 0x1F;
        int count = 8;
        for (int i = 0; i < this.numRows; ++i) {
            int j = 0;
            while (j < q) {
                LittleEndianConversions.I2OSP(this.matrix[i][j], enc, count);
                ++j;
                count += 4;
            }
            for (j = 0; j < r; j += 8) {
                enc[count++] = (byte)(this.matrix[i][q] >>> j & 0xFF);
            }
        }
        return enc;
    }

    public double getHammingWeight() {
        double counter = 0.0;
        double elementCounter = 0.0;
        int rest = this.numColumns & 0x1F;
        int d = rest == 0 ? this.length : this.length - 1;
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < d; ++j) {
                int a = this.matrix[i][j];
                for (int k = 0; k < 32; ++k) {
                    int b = a >>> k & 1;
                    counter += (double)b;
                    elementCounter += 1.0;
                }
            }
            int a = this.matrix[i][this.length - 1];
            for (int k = 0; k < rest; ++k) {
                int b = a >>> k & 1;
                counter += (double)b;
                elementCounter += 1.0;
            }
        }
        return counter / elementCounter;
    }

    public boolean isZero() {
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.length; ++j) {
                if (this.matrix[i][j] == 0) continue;
                return false;
            }
        }
        return true;
    }

    public GF2Matrix getLeftSubMatrix() {
        if (this.numColumns <= this.numRows) {
            throw new ArithmeticException("empty submatrix");
        }
        int length = this.numRows + 31 >> 5;
        int[][] result = new int[this.numRows][length];
        int bitMask = (1 << (this.numRows & 0x1F)) - 1;
        if (bitMask == 0) {
            bitMask = -1;
        }
        for (int i = this.numRows - 1; i >= 0; --i) {
            System.arraycopy(this.matrix[i], 0, result[i], 0, length);
            int[] nArray = result[i];
            int n = length - 1;
            nArray[n] = nArray[n] & bitMask;
        }
        return new GF2Matrix(this.numRows, result);
    }

    public GF2Matrix extendLeftCompactForm() {
        int newNumColumns = this.numColumns + this.numRows;
        GF2Matrix result = new GF2Matrix(this.numRows, newNumColumns);
        int ind = this.numRows - 1 + this.numColumns;
        int i = this.numRows - 1;
        while (i >= 0) {
            System.arraycopy(this.matrix[i], 0, result.matrix[i], 0, this.length);
            int[] nArray = result.matrix[i];
            int n = ind >> 5;
            nArray[n] = nArray[n] | 1 << (ind & 0x1F);
            --i;
            --ind;
        }
        return result;
    }

    public GF2Matrix getRightSubMatrix() {
        if (this.numColumns <= this.numRows) {
            throw new ArithmeticException("empty submatrix");
        }
        int q = this.numRows >> 5;
        int r = this.numRows & 0x1F;
        GF2Matrix result = new GF2Matrix(this.numRows, this.numColumns - this.numRows);
        for (int i = this.numRows - 1; i >= 0; --i) {
            if (r != 0) {
                int ind = q;
                for (int j = 0; j < result.length - 1; ++j) {
                    result.matrix[i][j] = this.matrix[i][ind++] >>> r | this.matrix[i][ind] << 32 - r;
                }
                result.matrix[i][result.length - 1] = this.matrix[i][ind++] >>> r;
                if (ind >= this.length) continue;
                int[] nArray = result.matrix[i];
                int n = result.length - 1;
                nArray[n] = nArray[n] | this.matrix[i][ind] << 32 - r;
                continue;
            }
            System.arraycopy(this.matrix[i], q, result.matrix[i], 0, result.length);
        }
        return result;
    }

    public GF2Matrix extendRightCompactForm() {
        GF2Matrix result = new GF2Matrix(this.numRows, this.numRows + this.numColumns);
        int q = this.numRows >> 5;
        int r = this.numRows & 0x1F;
        for (int i = this.numRows - 1; i >= 0; --i) {
            int[] nArray = result.matrix[i];
            int n = i >> 5;
            nArray[n] = nArray[n] | 1 << (i & 0x1F);
            if (r != 0) {
                int ind = q;
                for (int j = 0; j < this.length - 1; ++j) {
                    int mw = this.matrix[i][j];
                    int[] nArray2 = result.matrix[i];
                    int n2 = ind++;
                    nArray2[n2] = nArray2[n2] | mw << r;
                    int[] nArray3 = result.matrix[i];
                    int n3 = ind;
                    nArray3[n3] = nArray3[n3] | mw >>> 32 - r;
                }
                int mw = this.matrix[i][this.length - 1];
                int[] nArray4 = result.matrix[i];
                int n4 = ind++;
                nArray4[n4] = nArray4[n4] | mw << r;
                if (ind >= result.length) continue;
                int[] nArray5 = result.matrix[i];
                int n5 = ind;
                nArray5[n5] = nArray5[n5] | mw >>> 32 - r;
                continue;
            }
            System.arraycopy(this.matrix[i], 0, result.matrix[i], q, this.length);
        }
        return result;
    }

    public Matrix computeTranspose() {
        int[][] result = new int[this.numColumns][this.numRows + 31 >>> 5];
        for (int i = 0; i < this.numRows; ++i) {
            for (int j = 0; j < this.numColumns; ++j) {
                int qs = j >>> 5;
                int rs = j & 0x1F;
                int b = this.matrix[i][qs] >>> rs & 1;
                int qt = i >>> 5;
                int rt = i & 0x1F;
                if (b != 1) continue;
                int[] nArray = result[j];
                int n = qt;
                nArray[n] = nArray[n] | 1 << rt;
            }
        }
        return new GF2Matrix(this.numRows, result);
    }

    public Matrix computeInverse() {
        int q;
        int i;
        if (this.numRows != this.numColumns) {
            throw new ArithmeticException("Matrix is not invertible.");
        }
        int[][] tmpMatrix = new int[this.numRows][this.length];
        for (int i2 = this.numRows - 1; i2 >= 0; --i2) {
            tmpMatrix[i2] = IntUtils.clone(this.matrix[i2]);
        }
        int[][] invMatrix = new int[this.numRows][this.length];
        for (i = this.numRows - 1; i >= 0; --i) {
            q = i >> 5;
            int r = i & 0x1F;
            invMatrix[i][q] = 1 << r;
        }
        for (i = 0; i < this.numRows; ++i) {
            q = i >> 5;
            int bitMask = 1 << (i & 0x1F);
            if ((tmpMatrix[i][q] & bitMask) == 0) {
                boolean foundNonZero = false;
                for (int j = i + 1; j < this.numRows; ++j) {
                    if ((tmpMatrix[j][q] & bitMask) == 0) continue;
                    foundNonZero = true;
                    GF2Matrix.swapRows(tmpMatrix, i, j);
                    GF2Matrix.swapRows(invMatrix, i, j);
                    j = this.numRows;
                }
                if (!foundNonZero) {
                    throw new ArithmeticException("Matrix is not invertible.");
                }
            }
            for (int j = this.numRows - 1; j >= 0; --j) {
                if (j == i || (tmpMatrix[j][q] & bitMask) == 0) continue;
                GF2Matrix.addToRow(tmpMatrix[i], tmpMatrix[j], q);
                GF2Matrix.addToRow(invMatrix[i], invMatrix[j], 0);
            }
        }
        return new GF2Matrix(this.numColumns, invMatrix);
    }

    public Matrix leftMultiply(Permutation p) {
        int[] pVec = p.getVector();
        if (pVec.length != this.numRows) {
            throw new ArithmeticException("length mismatch");
        }
        int[][] result = new int[this.numRows][];
        for (int i = this.numRows - 1; i >= 0; --i) {
            result[i] = IntUtils.clone(this.matrix[pVec[i]]);
        }
        return new GF2Matrix(this.numRows, result);
    }

    public Vector leftMultiply(Vector vec) {
        if (!(vec instanceof GF2Vector)) {
            throw new ArithmeticException("vector is not defined over GF(2)");
        }
        if (vec.length != this.numRows) {
            throw new ArithmeticException("length mismatch");
        }
        int[] v = ((GF2Vector)vec).getVecArray();
        int[] res = new int[this.length];
        int q = this.numRows >> 5;
        int r = 1 << (this.numRows & 0x1F);
        int row = 0;
        for (int i = 0; i < q; ++i) {
            int bitMask = 1;
            do {
                int b;
                if ((b = v[i] & bitMask) != 0) {
                    for (int j = 0; j < this.length; ++j) {
                        int n = j;
                        res[n] = res[n] ^ this.matrix[row][j];
                    }
                }
                ++row;
            } while ((bitMask <<= 1) != 0);
        }
        for (int bitMask = 1; bitMask != r; bitMask <<= 1) {
            int b = v[q] & bitMask;
            if (b != 0) {
                for (int j = 0; j < this.length; ++j) {
                    int n = j;
                    res[n] = res[n] ^ this.matrix[row][j];
                }
            }
            ++row;
        }
        return new GF2Vector(res, this.numColumns);
    }

    public Vector leftMultiplyLeftCompactForm(Vector vec) {
        int r;
        int q;
        int j;
        int b;
        int bitMask;
        if (!(vec instanceof GF2Vector)) {
            throw new ArithmeticException("vector is not defined over GF(2)");
        }
        if (vec.length != this.numRows) {
            throw new ArithmeticException("length mismatch");
        }
        int[] v = ((GF2Vector)vec).getVecArray();
        int[] res = new int[this.numRows + this.numColumns + 31 >>> 5];
        int words = this.numRows >>> 5;
        int row = 0;
        for (int i = 0; i < words; ++i) {
            bitMask = 1;
            do {
                if ((b = v[i] & bitMask) != 0) {
                    for (j = 0; j < this.length; ++j) {
                        int n = j;
                        res[n] = res[n] ^ this.matrix[row][j];
                    }
                    q = this.numColumns + row >>> 5;
                    r = this.numColumns + row & 0x1F;
                    int n = q;
                    res[n] = res[n] | 1 << r;
                }
                ++row;
            } while ((bitMask <<= 1) != 0);
        }
        int rem = 1 << (this.numRows & 0x1F);
        for (bitMask = 1; bitMask != rem; bitMask <<= 1) {
            b = v[words] & bitMask;
            if (b != 0) {
                for (j = 0; j < this.length; ++j) {
                    int n = j;
                    res[n] = res[n] ^ this.matrix[row][j];
                }
                q = this.numColumns + row >>> 5;
                r = this.numColumns + row & 0x1F;
                int n = q;
                res[n] = res[n] | 1 << r;
            }
            ++row;
        }
        return new GF2Vector(res, this.numRows + this.numColumns);
    }

    public Matrix rightMultiply(Matrix mat) {
        if (!(mat instanceof GF2Matrix)) {
            throw new ArithmeticException("matrix is not defined over GF(2)");
        }
        if (mat.numRows != this.numColumns) {
            throw new ArithmeticException("length mismatch");
        }
        GF2Matrix a = (GF2Matrix)mat;
        GF2Matrix result = new GF2Matrix(this.numRows, mat.numColumns);
        int rest = this.numColumns & 0x1F;
        int d = rest == 0 ? this.length : this.length - 1;
        for (int i = 0; i < this.numRows; ++i) {
            int count = 0;
            for (int j = 0; j < d; ++j) {
                int e = this.matrix[i][j];
                for (int h = 0; h < 32; ++h) {
                    int b = e & 1 << h;
                    if (b != 0) {
                        for (int g = 0; g < a.length; ++g) {
                            int[] nArray = result.matrix[i];
                            int n = g;
                            nArray[n] = nArray[n] ^ a.matrix[count][g];
                        }
                    }
                    ++count;
                }
            }
            int e = this.matrix[i][this.length - 1];
            for (int h = 0; h < rest; ++h) {
                int b = e & 1 << h;
                if (b != 0) {
                    for (int g = 0; g < a.length; ++g) {
                        int[] nArray = result.matrix[i];
                        int n = g;
                        nArray[n] = nArray[n] ^ a.matrix[count][g];
                    }
                }
                ++count;
            }
        }
        return result;
    }

    public Matrix rightMultiply(Permutation p) {
        int[] pVec = p.getVector();
        if (pVec.length != this.numColumns) {
            throw new ArithmeticException("length mismatch");
        }
        GF2Matrix result = new GF2Matrix(this.numRows, this.numColumns);
        for (int i = this.numColumns - 1; i >= 0; --i) {
            int q = i >>> 5;
            int r = i & 0x1F;
            int pq = pVec[i] >>> 5;
            int pr = pVec[i] & 0x1F;
            for (int j = this.numRows - 1; j >= 0; --j) {
                int[] nArray = result.matrix[j];
                int n = q;
                nArray[n] = nArray[n] | (this.matrix[j][pq] >>> pr & 1) << r;
            }
        }
        return result;
    }

    public Vector rightMultiply(Vector vec) {
        if (!(vec instanceof GF2Vector)) {
            throw new ArithmeticException("vector is not defined over GF(2)");
        }
        if (vec.length != this.numColumns) {
            throw new ArithmeticException("length mismatch");
        }
        int[] v = ((GF2Vector)vec).getVecArray();
        int[] res = new int[this.numRows + 31 >>> 5];
        for (int i = 0; i < this.numRows; ++i) {
            int help = 0;
            for (int j = 0; j < this.length; ++j) {
                help ^= this.matrix[i][j] & v[j];
            }
            int bitValue = 0;
            for (int j = 0; j < 32; ++j) {
                bitValue ^= help >>> j & 1;
            }
            if (bitValue != true) continue;
            int n = i >>> 5;
            res[n] = res[n] | 1 << (i & 0x1F);
        }
        return new GF2Vector(res, this.numRows);
    }

    public Vector rightMultiplyRightCompactForm(Vector vec) {
        if (!(vec instanceof GF2Vector)) {
            throw new ArithmeticException("vector is not defined over GF(2)");
        }
        if (vec.length != this.numColumns + this.numRows) {
            throw new ArithmeticException("length mismatch");
        }
        int[] v = ((GF2Vector)vec).getVecArray();
        int[] res = new int[this.numRows + 31 >>> 5];
        int q = this.numRows >> 5;
        int r = this.numRows & 0x1F;
        for (int i = 0; i < this.numRows; ++i) {
            int j;
            int help = v[i >> 5] >>> (i & 0x1F) & 1;
            int vInd = q;
            if (r != 0) {
                int vw = 0;
                for (j = 0; j < this.length - 1; ++j) {
                    vw = v[vInd++] >>> r | v[vInd] << 32 - r;
                    help ^= this.matrix[i][j] & vw;
                }
                vw = v[vInd++] >>> r;
                if (vInd < v.length) {
                    vw |= v[vInd] << 32 - r;
                }
                help ^= this.matrix[i][this.length - 1] & vw;
            } else {
                for (int j2 = 0; j2 < this.length; ++j2) {
                    help ^= this.matrix[i][j2] & v[vInd++];
                }
            }
            int bitValue = 0;
            for (j = 0; j < 32; ++j) {
                bitValue ^= help & 1;
                help >>>= 1;
            }
            if (bitValue != true) continue;
            int n = i >> 5;
            res[n] = res[n] | 1 << (i & 0x1F);
        }
        return new GF2Vector(res, this.numRows);
    }

    public boolean equals(Object other) {
        if (!(other instanceof GF2Matrix)) {
            return false;
        }
        GF2Matrix otherMatrix = (GF2Matrix)other;
        if (this.numRows != otherMatrix.numRows || this.numColumns != otherMatrix.numColumns || this.length != otherMatrix.length) {
            return false;
        }
        for (int i = 0; i < this.numRows; ++i) {
            if (IntUtils.equals(this.matrix[i], otherMatrix.matrix[i])) continue;
            return false;
        }
        return true;
    }

    public int hashCode() {
        int hash = (this.numRows * 31 + this.numColumns) * 31 + this.length;
        for (int i = 0; i < this.numRows; ++i) {
            hash = hash * 31 + Arrays.hashCode(this.matrix[i]);
        }
        return hash;
    }

    public String toString() {
        int rest = this.numColumns & 0x1F;
        int d = rest == 0 ? this.length : this.length - 1;
        StringBuffer buf = new StringBuffer();
        for (int i = 0; i < this.numRows; ++i) {
            buf.append(i + ": ");
            for (int j = 0; j < d; ++j) {
                int a = this.matrix[i][j];
                for (int k = 0; k < 32; ++k) {
                    int b = a >>> k & 1;
                    if (b == 0) {
                        buf.append('0');
                        continue;
                    }
                    buf.append('1');
                }
                buf.append(' ');
            }
            int a = this.matrix[i][this.length - 1];
            for (int k = 0; k < rest; ++k) {
                int b = a >>> k & 1;
                if (b == 0) {
                    buf.append('0');
                    continue;
                }
                buf.append('1');
            }
            buf.append('\n');
        }
        return buf.toString();
    }

    private static void swapRows(int[][] matrix, int first, int second) {
        int[] tmp = matrix[first];
        matrix[first] = matrix[second];
        matrix[second] = tmp;
    }

    private static void addToRow(int[] fromRow, int[] toRow, int startIndex) {
        for (int i = toRow.length - 1; i >= startIndex; --i) {
            toRow[i] = fromRow[i] ^ toRow[i];
        }
    }
}

