/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.pqc.legacy.math.ntru.util;

import java.io.IOException;
import java.io.InputStream;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Collections;
import net.savignano.thirdparty.org.bouncycastle.pqc.legacy.math.ntru.euclid.IntEuclidean;
import net.savignano.thirdparty.org.bouncycastle.pqc.legacy.math.ntru.polynomial.DenseTernaryPolynomial;
import net.savignano.thirdparty.org.bouncycastle.pqc.legacy.math.ntru.polynomial.SparseTernaryPolynomial;
import net.savignano.thirdparty.org.bouncycastle.pqc.legacy.math.ntru.polynomial.TernaryPolynomial;
import net.savignano.thirdparty.org.bouncycastle.util.Integers;

public class Util {
    private static volatile boolean IS_64_BITNESS_KNOWN;
    private static volatile boolean IS_64_BIT_JVM;

    public static int invert(int n, int modulus) {
        if ((n %= modulus) < 0) {
            n += modulus;
        }
        return IntEuclidean.calculate((int)n, (int)modulus).x;
    }

    public static int pow(int a, int b, int modulus) {
        int p = 1;
        for (int i = 0; i < b; ++i) {
            p = p * a % modulus;
        }
        return p;
    }

    public static long pow(long a, int b, long modulus) {
        long p = 1L;
        for (int i = 0; i < b; ++i) {
            p = p * a % modulus;
        }
        return p;
    }

    public static TernaryPolynomial generateRandomTernary(int N, int numOnes, int numNegOnes, boolean sparse, SecureRandom random) {
        if (sparse) {
            return SparseTernaryPolynomial.generateRandom(N, numOnes, numNegOnes, random);
        }
        return DenseTernaryPolynomial.generateRandom(N, numOnes, numNegOnes, random);
    }

    public static int[] generateRandomTernary(int N, int numOnes, int numNegOnes, SecureRandom random) {
        int i;
        Integer one = Integers.valueOf(1);
        Integer minusOne = Integers.valueOf(-1);
        Integer zero = Integers.valueOf(0);
        ArrayList<Integer> list = new ArrayList<Integer>();
        for (i = 0; i < numOnes; ++i) {
            list.add(one);
        }
        for (i = 0; i < numNegOnes; ++i) {
            list.add(minusOne);
        }
        while (list.size() < N) {
            list.add(zero);
        }
        Collections.shuffle(list, random);
        int[] arr = new int[N];
        for (int i2 = 0; i2 < N; ++i2) {
            arr[i2] = (Integer)list.get(i2);
        }
        return arr;
    }

    public static boolean is64BitJVM() {
        if (!IS_64_BITNESS_KNOWN) {
            String arch = System.getProperty("os.arch");
            String sunModel = System.getProperty("sun.arch.data.model");
            IS_64_BIT_JVM = "amd64".equals(arch) || "x86_64".equals(arch) || "ppc64".equals(arch) || "64".equals(sunModel);
            IS_64_BITNESS_KNOWN = true;
        }
        return IS_64_BIT_JVM;
    }

    public static byte[] readFullLength(InputStream is, int length) throws IOException {
        byte[] arr = new byte[length];
        if (is.read(arr) != arr.length) {
            throw new IOException("Not enough bytes to read.");
        }
        return arr;
    }
}

