/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.common.security.access.smime;

import java.security.cert.CertificateException;
import java.security.cert.X509Certificate;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.ISnotifyUserProperties;
import net.savignano.snotify.atlassian.common.IUser;
import net.savignano.snotify.atlassian.common.enums.ECryptographyType;
import net.savignano.snotify.atlassian.common.enums.EKeySource;
import net.savignano.snotify.atlassian.common.enums.EKeyValidity;
import net.savignano.snotify.atlassian.common.security.access.AUserKeyLoader;
import net.savignano.snotify.atlassian.common.security.key.publicly.SnotifySmimePublicKey;
import net.savignano.snotify.atlassian.common.util.SmimeUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmimeUserKeyLoader
extends AUserKeyLoader<SnotifySmimePublicKey> {
    private static final Logger log = LoggerFactory.getLogger(SmimeUserKeyLoader.class);

    public SmimeUserKeyLoader(IUser<?> user, ISnotifyUserProperties userProps) {
        super(user, userProps);
    }

    @Override
    protected SnotifySmimePublicKey loadInternalKey() throws Exception {
        IUser<?> user = this.getUser();
        ISnotifyUserProperties userProps = this.getUserProperties();
        byte[] cert = userProps.getBytes(EProperty.EMAIL_SMIME_CERT, user);
        if (cert != null) {
            log.debug("Loading cached certificate of user {} from user properties.", user);
            try {
                X509Certificate certificate = SmimeUtil.createCertificate(cert);
                SnotifySmimePublicKey key = new SnotifySmimePublicKey(certificate, user.getEmail());
                key.setKeySource(this.getUserKeySource());
                return key;
            }
            catch (CertificateException e) {
                log.error("Could not parse certificate stored for user " + user + ". Error message: " + e.getMessage(), (Throwable)e);
                return this.getValidityKey(EKeyValidity.ERROR);
            }
        }
        log.debug("User {} has no cached certificate stored.", user);
        return this.getValidityKey(EKeyValidity.NOT_FOUND);
    }

    private EKeySource getUserKeySource() {
        EKeySource keySource = this.getUserProperties().getEnum(EProperty.EMAIL_SMIME_KEY_SOURCE, EKeySource.class, this.getUser());
        if (keySource != null) {
            return keySource;
        }
        return this.getKeySource();
    }

    @Override
    public ECryptographyType getCryptography() {
        return ECryptographyType.SMIME;
    }

    @Override
    protected SnotifySmimePublicKey getValidityKey(EKeyValidity validity) {
        return new SnotifySmimePublicKey(validity, this.getKeySource());
    }

    public String toString() {
        return "SmimeCachedKeyLoader [user=" + this.getUser() + "]";
    }
}

