/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer;

import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.MessagingException;
import javax.mail.internet.MimeMessage;
import net.savignano.snotify.atlassian.mailer.visitor.RegexVisitor;
import org.apache.commons.lang.StringEscapeUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AAtlassianMailKeyExtractor {
    private static final Logger log = LoggerFactory.getLogger(AAtlassianMailKeyExtractor.class);
    private final String baseUrl;
    private final Pattern baseUrlPattern;

    public AAtlassianMailKeyExtractor(String baseUrl) {
        log.debug("Base URL used: " + baseUrl);
        this.baseUrl = baseUrl;
        this.baseUrlPattern = Pattern.compile("(?:^|[\"\\s])(" + baseUrl + "[^\"\\s]+)");
    }

    public Set<String> getKeys(MimeMessage msg) throws IOException, MessagingException {
        RegexVisitor visitor = new RegexVisitor(this.baseUrlPattern);
        try {
            visitor.visit(msg);
        }
        catch (Exception e) {
            throw new MessagingException("Could not parse email. Error message: " + e.getMessage(), e);
        }
        HashSet<URL> urls = new HashSet<URL>();
        for (MatchResult result : visitor.getMatches()) {
            URL url = this.toUrl(result);
            if (url == null) continue;
            urls.add(url);
        }
        return this.getKeys(urls);
    }

    public Set<String> getKeys(String str) {
        Matcher matcher = this.baseUrlPattern.matcher(str);
        HashSet<URL> urls = new HashSet<URL>();
        while (matcher.find()) {
            URL url = this.toUrl(matcher.toMatchResult());
            if (url == null) continue;
            urls.add(url);
        }
        return this.getKeys(urls);
    }

    protected abstract String getKey(URL var1);

    private URL toUrl(MatchResult result) {
        log.trace("Found match in email: {}", (Object)result.group());
        String url = StringEscapeUtils.unescapeHtml((String)result.group(1));
        log.debug("HTML escaped URL: {}", (Object)url);
        try {
            return new URL(url);
        }
        catch (MalformedURLException e) {
            log.error("Match " + url + " is not an URL. Error message: " + e.getMessage(), (Throwable)e);
            return null;
        }
    }

    private Set<String> getKeys(Collection<URL> matches) {
        HashSet<String> projectKeys = new HashSet<String>();
        log.trace("Checking {} URLs.", (Object)matches.size());
        for (URL match : matches) {
            log.trace("Checking URL: {}", (Object)match);
            String projectKey = this.getKey(match);
            log.trace("Found key: {}", (Object)projectKey);
            if (projectKey == null) continue;
            projectKeys.add(projectKey);
        }
        log.debug("Found the following keys: {}", projectKeys);
        return projectKeys;
    }

    public String getBaseUrl() {
        return this.baseUrl;
    }
}

