/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer;

import java.io.IOException;
import java.net.InetAddress;
import java.net.UnknownHostException;
import java.security.Provider;
import java.util.ArrayList;
import java.util.Optional;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import net.savignano.snotify.atlassian.common.IVersion;
import net.savignano.snotify.atlassian.common.enums.ECryptographyType;
import net.savignano.snotify.atlassian.common.enums.EEncryptionFailureBehavior;
import net.savignano.snotify.atlassian.common.enums.EEncryptionTypePriority;
import net.savignano.snotify.atlassian.common.enums.EKeyValidity;
import net.savignano.snotify.atlassian.common.security.key.publicly.SnotifyPgpPublicKey;
import net.savignano.snotify.atlassian.common.security.key.publicly.SnotifySmimePublicKey;
import net.savignano.snotify.atlassian.common.security.key.secret.SnotifyPgpSignKey;
import net.savignano.snotify.atlassian.common.security.key.secret.SnotifySmimeSignKey;
import net.savignano.snotify.atlassian.common.util.MessageUtil;
import net.savignano.snotify.atlassian.common.util.SecurityUtil;
import net.savignano.snotify.atlassian.mailer.ISessionProvider;
import net.savignano.snotify.atlassian.mailer.MessageAndAddress;
import net.savignano.snotify.atlassian.mailer.SnotifyMimeMessage;
import net.savignano.snotify.atlassian.mailer.encrypt.IMailEncryptor;
import net.savignano.snotify.atlassian.mailer.protect.IMailHeaderProtector;
import net.savignano.snotify.atlassian.mailer.sign.IMailSigner;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class AMailer
implements ISessionProvider,
IVersion {
    public static final String XENCRPYTED_MAIL_PROPERTY = "X-Encrypted";
    private static final Logger log = LoggerFactory.getLogger(AMailer.class);
    private static String version;
    private final Session session;
    private Provider provider;
    private String hostName;
    private EEncryptionTypePriority typePriority;
    private EEncryptionFailureBehavior failureBehavior;
    private Boolean disabled;
    private Boolean frozen;
    private Boolean liteMode;
    private Boolean dryRun;
    private Boolean additionalSigningSmime;
    private Boolean additionalSigningPgp;

    private static final void loadManifestValues() {
        String compileTime;
        String versionNo = SecurityUtil.getManifestValue("Bundle-Version");
        if (versionNo == null) {
            log.debug("Mailer library is missing bundle version in manifest.");
            versionNo = "<N/A>";
        }
        if ((compileTime = SecurityUtil.getManifestValue("Compile-Time")) == null) {
            log.debug("Mailer library is missing compile time in manifest.");
            compileTime = "<N/A>";
        }
        StringBuilder builder = new StringBuilder(30);
        builder.append(versionNo);
        builder.append(" (");
        builder.append(compileTime);
        builder.append(')');
        version = builder.toString();
        log.info("S/Notify mailer library version: {}", (Object)version);
    }

    public AMailer(Session session) {
        this.session = session;
        if (version == null) {
            AMailer.loadManifestValues();
        }
        if (Thread.currentThread().getContextClassLoader() == null) {
            ClassLoader classLoader = Message.class.getClassLoader();
            log.warn("Context class loader of current thread is null. Setting context class loader to this class' class loader of javax.mail.Message: {}", (Object)classLoader);
            Thread.currentThread().setContextClassLoader(classLoader);
        }
    }

    public MessageAndAddress[] getMessages(MimeMessage message, Address[] addresses) {
        if (message == null) {
            log.debug("Message is null.");
            return new MessageAndAddress[0];
        }
        if (addresses == null || addresses.length == 0) {
            log.debug("Addresses is null or zero length.");
            return new MessageAndAddress[0];
        }
        if (this.isDisabled()) {
            log.warn("S/Notify is disabled. Emails will not be encrypted.");
            MessageAndAddress[] result = new MessageAndAddress[addresses.length];
            for (int i = 0; i < result.length; ++i) {
                result[i] = new MessageAndAddress(message, addresses[i]);
            }
            return result;
        }
        if (this.isFrozen()) {
            log.warn("Cannot encrypt emails due to licensing error in S/Notify. Handling unencrypted emails as: " + (Object)((Object)this.getFailureBehavior()));
        }
        if (this.isLiteMode()) {
            log.info("S/Notify is in 'lite'-mode. Limited functionality.");
        }
        if (this.isDryRun()) {
            log.info("S/Notify is in 'dry run'-mode. Emails will not be sent.");
        }
        ArrayList<MessageAndAddress> result = new ArrayList<MessageAndAddress>();
        for (Address address : addresses) {
            MessageAndAddress messageAndAddress = new MessageAndAddress();
            messageAndAddress.address = address;
            messageAndAddress.message = message;
            result.add(messageAndAddress);
            this.handleMessage(messageAndAddress);
        }
        return result.toArray(new MessageAndAddress[result.size()]);
    }

    private void handleMessage(MessageAndAddress msgAndAddress) {
        MailerData data = this.createDefaultEncryptionData(msgAndAddress);
        if (this.isFrozen()) {
            data.encrypt = true;
            data.sign = false;
            data.encryptValidity = EKeyValidity.ERROR;
            data.signValidity = EKeyValidity.ERROR;
        } else {
            log.debug("Starting email encryption to address: \"{}\"", (Object)msgAndAddress.address);
            try {
                this.processMessage(data, msgAndAddress);
                msgAndAddress.message = data.message;
            }
            catch (Exception e) {
                log.error("Error encrypting email for address \"" + msgAndAddress.address + "\": " + e.getMessage(), (Throwable)e);
                data.encryptValidity = EKeyValidity.ERROR;
                data.signValidity = EKeyValidity.ERROR;
            }
            if (data.sign && (data.signValidity == EKeyValidity.ERROR || data.signValidity == EKeyValidity.INVALID)) {
                log.warn("Could not sign email for \"{}\" from \"{}\".", (Object)data.toAddress, (Object)data.fromAddress);
            }
        }
        log.debug("Validity of encryption: {}", data.encrypt ? data.encryptValidity : "<N/A>");
        if (data.encrypt && data.encryptValidity != EKeyValidity.VALID) {
            this.handleEncryptionFailure(msgAndAddress, data);
        }
        if (!data.send) {
            this.markEmailAsDoNotSend(msgAndAddress);
        }
    }

    private MailerData createDefaultEncryptionData(MessageAndAddress msgAndAddress) {
        Optional<Address> from = MessageUtil.getFrom(msgAndAddress.message);
        MailerData data = new MailerData();
        data.message = this.wrap(msgAndAddress.message);
        data.toAddress = msgAndAddress.address;
        data.fromAddress = from.isPresent() ? from.get() : null;
        data.encrypt = data.toAddress != null && this.isEncryptionDesired(msgAndAddress);
        data.sign = data.fromAddress != null && this.isSigningDesired(msgAndAddress);
        data.send = !this.isDryRun();
        return data;
    }

    private void handleEncryptionFailure(MessageAndAddress msgAndAddress, MailerData data) {
        log.debug("No valid encryption for address {}. Using failure behavior {} to process email.", (Object)msgAndAddress.address, (Object)this.getFailureBehavior());
        switch (this.getFailureBehavior()) {
            case ALLOW: {
                log.info("Could not encrypt email for \"{}\". Unencrypted email will be sent.", (Object)msgAndAddress.address);
                break;
            }
            case BLOCK: {
                log.warn("Could not encrypt email for \"{}\". Email will not be sent.", (Object)msgAndAddress.address);
                data.send = false;
                break;
            }
            case REPORT: {
                log.warn("Could not encrypt email for \"{}\". Creating error report.", (Object)msgAndAddress.address);
                try {
                    msgAndAddress.message = this.getFailureMessage(msgAndAddress, data.encryptValidity);
                }
                catch (MessagingException e) {
                    log.error("Error creating report email for email address \"" + msgAndAddress.address + "\". Error message: " + e.getMessage(), (Throwable)e);
                }
                if (!data.sign || data.signValidity != EKeyValidity.VALID) break;
                MailerData signData = new MailerData();
                signData.copy(data);
                signData.message = this.wrap(msgAndAddress.message);
                signData.encrypt = false;
                signData.encryptValidity = null;
                try {
                    this.processMessage(signData, msgAndAddress);
                    msgAndAddress.message = signData.message;
                }
                catch (Exception e) {
                    log.error("Error signing report email for email address \"" + msgAndAddress.address + "\". Error message: " + e.getMessage(), (Throwable)e);
                }
                break;
            }
            default: {
                throw new IllegalStateException("The given failure behavior (" + (Object)((Object)this.getFailureBehavior()) + ") is not yet implemented.");
            }
        }
    }

    private void markEmailAsDoNotSend(MessageAndAddress msgAndAddress) {
        log.debug("Setting 'Do not send'-header for addressee: {}", (Object)msgAndAddress.address);
        try {
            msgAndAddress.message.addHeader("X-SNotify-Do-Not-Send", Boolean.TRUE.toString());
        }
        catch (MessagingException e) {
            log.error("Could not set \"X-SNotify-Do-Not-Send\"-header to email. Error message: " + e.getMessage(), (Throwable)e);
        }
        try {
            msgAndAddress.message.saveChanges();
        }
        catch (MessagingException e) {
            log.error("Could not save changes to email for " + msgAndAddress.address + ". Email might be corrupt. Error message: " + e.getMessage(), (Throwable)e);
        }
    }

    private MimeMessage wrap(MimeMessage msg) {
        try {
            return new SnotifyMimeMessage(this.getSession(), msg);
        }
        catch (MessagingException e) {
            log.error("Could not create copy of message. Error message: " + e.getMessage(), (Throwable)e);
            return msg;
        }
    }

    private void processMessage(MailerData data, MessageAndAddress orgMsgAndAddress) throws Exception {
        log.debug("Initial encryption data: {}", (Object)data);
        log.debug("Using type priority for encryption: {}", (Object)this.getTypePriority());
        switch (this.getTypePriority()) {
            case PGP_ONLY: {
                this.processPgpMessage(data);
                break;
            }
            case PGP_PREFERED: {
                this.processPgpMessage(data);
                if (!data.encrypt || data.encryptValidity == EKeyValidity.VALID) break;
                log.info("PGP encryption failed for {}. Using fallback encryption with S/MIME", (Object)data.toAddress);
                MailerData alternativeData = new MailerData();
                alternativeData.copy(data);
                alternativeData.message = this.wrap(orgMsgAndAddress.message);
                alternativeData.encryptValidity = null;
                this.processSmimeMessage(alternativeData);
                if (alternativeData.encryptValidity == EKeyValidity.VALID) {
                    log.debug("Fallback S/MIME encryption for \"{}\" successful.", (Object)data.toAddress);
                    data.copy(alternativeData);
                    break;
                }
                log.info("Fallback S/MIME encryption for \"{}\" not successful.", (Object)data.toAddress);
                break;
            }
            case SMIME_ONLY: {
                this.processSmimeMessage(data);
                break;
            }
            case SMIME_PREFERED: {
                this.processSmimeMessage(data);
                if (!data.encrypt || data.encryptValidity == EKeyValidity.VALID) break;
                log.info("S/MIME encryption failed for {}. Using fallback encryption with PGP", (Object)data.toAddress);
                MailerData alternativeData = new MailerData();
                alternativeData.copy(data);
                alternativeData.message = this.wrap(orgMsgAndAddress.message);
                alternativeData.encryptValidity = null;
                this.processPgpMessage(alternativeData);
                if (alternativeData.encryptValidity == EKeyValidity.VALID) {
                    log.debug("Fallback PGP encryption for \"{}\" successful.", (Object)data.toAddress);
                    data.copy(alternativeData);
                    break;
                }
                log.info("Fallback PGP encryption for \"{}\" not successful.", (Object)data.toAddress);
                break;
            }
            default: {
                throw new IllegalStateException("The given type priority (" + (Object)((Object)this.getTypePriority()) + ") is not yet implemented.");
            }
        }
        log.debug("Processed encryption data: {}", (Object)data);
    }

    private void processSmimeMessage(MailerData data) throws MessagingException, IOException {
        this.processGenericMessage(data, ECryptographyType.SMIME);
    }

    private void processPgpMessage(MailerData data) throws IOException, MessagingException {
        this.processGenericMessage(data, ECryptographyType.PGP);
    }

    private void processGenericMessage(MailerData data, ECryptographyType cryptography) throws IOException, MessagingException {
        log.debug("Processing {} message for: \"{}\"", (Object)cryptography, (Object)data.toAddress);
        IMailSigner<?> signer = null;
        if (data.sign) {
            signer = this.getSigner(data, cryptography);
            data.signValidity = signer.getPrivateKey().getKeyValidity();
        }
        IMailEncryptor<?> encrypter = null;
        if (data.encrypt) {
            encrypter = this.getEncryptor(data, cryptography);
            data.encryptValidity = encrypter.getPublicKey().getKeyValidity();
        }
        IMailHeaderProtector protector = null;
        if (data.signValidity == EKeyValidity.VALID || data.encryptValidity == EKeyValidity.VALID) {
            protector = this.getMailHeaderProtector(cryptography);
        }
        String subjectReplacement = null;
        if (protector != null && data.encryptValidity == EKeyValidity.VALID) {
            subjectReplacement = this.getSubjectReplacement(data.message);
        }
        if (protector != null) {
            log.debug("Protecting headers with: {}", (Object)protector.getClass().getSimpleName());
            protector.protectHeaders(data.message);
        }
        if (signer != null && data.signValidity == EKeyValidity.VALID) {
            log.debug("Signing message with: {}", (Object)signer.getClass().getSimpleName());
            signer.signMessage(data.message);
        }
        if (encrypter != null && data.encryptValidity == EKeyValidity.VALID) {
            log.debug("Encrypting message with: {}", (Object)encrypter.getClass().getSimpleName());
            encrypter.encryptMessage(data.message);
        }
        if (this.isAdditionalSigning(cryptography) && signer != null && data.signValidity == EKeyValidity.VALID && data.encrypt && data.encryptValidity == EKeyValidity.VALID) {
            log.debug("Signing email an additional time.");
            signer.signMessage(data.message);
        }
        if (subjectReplacement != null) {
            log.debug("Replacing subject with: {}", (Object)subjectReplacement);
            data.message.setSubject(subjectReplacement, "UTF-8");
            data.message.saveChanges();
        }
    }

    private IMailEncryptor<?> getEncryptor(MailerData data, ECryptographyType type) {
        switch (type) {
            case PGP: {
                return this.getPgpEncryptor(data.toAddress, data.fromAddress);
            }
            case SMIME: {
                return this.getSmimeEncryptor(data.toAddress, data.fromAddress);
            }
        }
        log.debug("Unknown cryptography type given: {}", (Object)type);
        return null;
    }

    private IMailSigner<?> getSigner(MailerData data, ECryptographyType type) {
        switch (type) {
            case PGP: {
                return this.getPgpSigner(data.fromAddress);
            }
            case SMIME: {
                return this.getSmimeSigner(data.fromAddress);
            }
        }
        log.debug("Unknown cryptography type given: {}", (Object)type);
        return null;
    }

    private boolean isAdditionalSigning(ECryptographyType type) {
        switch (type) {
            case PGP: {
                return this.isAdditionalSigningPgp();
            }
            case SMIME: {
                return this.isAdditionalSigningSmime();
            }
        }
        log.debug("Unknown cryptography type given: {}", (Object)type);
        return false;
    }

    protected abstract IMailEncryptor<SnotifySmimePublicKey> getSmimeEncryptor(Address var1, Address var2);

    protected abstract IMailSigner<SnotifySmimeSignKey> getSmimeSigner(Address var1);

    protected abstract MimeMessage getFailureMessage(MessageAndAddress var1, EKeyValidity var2) throws MessagingException;

    protected abstract IMailEncryptor<SnotifyPgpPublicKey> getPgpEncryptor(Address var1, Address var2);

    protected abstract IMailSigner<SnotifyPgpSignKey> getPgpSigner(Address var1);

    protected abstract IMailHeaderProtector getMailHeaderProtector(ECryptographyType var1);

    protected boolean isEncryptionDesired(MessageAndAddress msgAndAddress) {
        return true;
    }

    protected boolean isSigningDesired(MessageAndAddress msgAndAddress) {
        return !this.isLiteMode();
    }

    protected String getSubjectReplacement(MimeMessage msg) {
        return null;
    }

    @Override
    public Session getSession() {
        return this.session;
    }

    @Override
    public String getVersion() {
        return version;
    }

    public boolean isDisabled() {
        if (this.disabled == null) {
            this.disabled = this.loadDisabled();
        }
        return this.disabled;
    }

    protected boolean loadDisabled() {
        return false;
    }

    public boolean isFrozen() {
        if (this.frozen == null) {
            this.frozen = this.loadFrozen();
        }
        return this.frozen;
    }

    protected boolean loadFrozen() {
        return false;
    }

    public boolean isLiteMode() {
        if (this.liteMode == null) {
            this.liteMode = this.loadLiteMode();
        }
        return this.liteMode;
    }

    protected boolean loadLiteMode() {
        return false;
    }

    public boolean isDryRun() {
        if (this.dryRun == null) {
            this.dryRun = this.loadDryRun();
        }
        return this.dryRun;
    }

    protected boolean loadDryRun() {
        return false;
    }

    public boolean isAdditionalSigningSmime() {
        if (this.additionalSigningSmime == null) {
            this.additionalSigningSmime = this.loadAdditionalSigningSmime();
        }
        return this.additionalSigningSmime;
    }

    protected boolean loadAdditionalSigningSmime() {
        return false;
    }

    public boolean isAdditionalSigningPgp() {
        if (this.additionalSigningPgp == null) {
            this.additionalSigningPgp = this.loadAdditionalSigningPgp();
        }
        return this.additionalSigningPgp;
    }

    protected boolean loadAdditionalSigningPgp() {
        return false;
    }

    public EEncryptionTypePriority getTypePriority() {
        if (this.typePriority == null) {
            this.typePriority = this.loadTypePriority();
        }
        return this.typePriority;
    }

    protected EEncryptionTypePriority loadTypePriority() {
        return EEncryptionTypePriority.SMIME_PREFERED;
    }

    public EEncryptionFailureBehavior getFailureBehavior() {
        if (this.failureBehavior == null) {
            this.failureBehavior = this.loadFailureBehavior();
        }
        return this.failureBehavior;
    }

    protected EEncryptionFailureBehavior loadFailureBehavior() {
        return EEncryptionFailureBehavior.ALLOW;
    }

    public Provider getProvider() {
        if (this.provider == null) {
            this.provider = this.loadProvider();
        }
        return this.provider;
    }

    protected Provider loadProvider() {
        return SecurityUtil.getProvider();
    }

    public String getHostName() {
        if (this.hostName == null) {
            this.hostName = this.loadHostName();
        }
        return this.hostName;
    }

    protected String loadHostName() {
        try {
            String result = InetAddress.getLocalHost().getHostName();
            if (result != null && !result.isEmpty()) {
                return result;
            }
        }
        catch (UnknownHostException e) {
            log.debug("Could not retrieve host name.", (Throwable)e);
        }
        try {
            String host = System.getenv("COMPUTERNAME");
            if (host != null) {
                return host;
            }
            host = System.getenv("HOSTNAME");
            if (host != null) {
                return host;
            }
        }
        catch (SecurityException e) {
            log.debug("Could not retrieve host name from environment properties.", (Throwable)e);
        }
        return "<Unknown>";
    }

    private static final class MailerData {
        public MimeMessage message;
        public Address toAddress;
        public Address fromAddress;
        public boolean encrypt;
        public boolean sign;
        public EKeyValidity encryptValidity;
        public EKeyValidity signValidity;
        public boolean send;

        private MailerData() {
        }

        public void copy(MailerData data) {
            this.message = data.message;
            this.toAddress = data.toAddress;
            this.fromAddress = data.fromAddress;
            this.encrypt = data.encrypt;
            this.sign = data.sign;
            this.encryptValidity = data.encryptValidity;
            this.signValidity = data.signValidity;
            this.send = data.send;
        }

        public String toString() {
            return "EncryptionData [toAddress=" + this.toAddress + ", fromAddress=" + this.fromAddress + ", encrypt=" + this.encrypt + ", sign=" + this.sign + ", encryptValidity=" + (Object)((Object)this.encryptValidity) + ", signValidity=" + (Object)((Object)this.signValidity) + ", send=" + this.send + "]";
        }
    }
}

