/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer.decrypt;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import java.security.GeneralSecurityException;
import java.security.KeyStore;
import java.security.PrivateKey;
import java.security.cert.X509Certificate;
import java.util.Map;
import java.util.Optional;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.util.ByteArrayDataSource;
import net.savignano.snotify.atlassian.common.security.key.secret.SnotifySmimeDecryptionKey;
import net.savignano.snotify.atlassian.common.util.KeyStoreContentFetcher;
import net.savignano.snotify.atlassian.common.util.MessageUtil;
import net.savignano.snotify.atlassian.common.util.SmimeUtil;
import net.savignano.snotify.atlassian.mailer.decrypt.AMailDecryptor;
import net.savignano.thirdparty.org.bouncycastle.asn1.ASN1ObjectIdentifier;
import net.savignano.thirdparty.org.bouncycastle.cms.CMSException;
import net.savignano.thirdparty.org.bouncycastle.cms.KeyTransRecipientId;
import net.savignano.thirdparty.org.bouncycastle.cms.Recipient;
import net.savignano.thirdparty.org.bouncycastle.cms.RecipientId;
import net.savignano.thirdparty.org.bouncycastle.cms.RecipientInformation;
import net.savignano.thirdparty.org.bouncycastle.cms.RecipientInformationStore;
import net.savignano.thirdparty.org.bouncycastle.cms.jcajce.JceKeyTransEnvelopedRecipient;
import net.savignano.thirdparty.org.bouncycastle.mail.smime.SMIMEEnveloped;
import net.savignano.thirdparty.org.bouncycastle.mail.smime.SMIMEException;
import net.savignano.thirdparty.org.bouncycastle.mail.smime.SMIMEUtil;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmimeMailDecryptor
extends AMailDecryptor<SnotifySmimeDecryptionKey> {
    private static final Logger log = LoggerFactory.getLogger(SmimeMailDecryptor.class);

    public SmimeMailDecryptor(Session session, SnotifySmimeDecryptionKey privateKey) {
        super(session, privateKey);
    }

    @Override
    protected void decrypt(MimeMessage msg) throws IOException, MessagingException {
        try {
            if (log.isTraceEnabled()) {
                ByteArrayOutputStream debugBaos = new ByteArrayOutputStream();
                msg.writeTo((OutputStream)debugBaos);
                log.trace("Original email:\n{}\n", (Object)debugBaos.toString());
            }
            if (!SmimeUtil.isMessageEncrypted((Message)msg)) {
                log.debug("Message is not S/MIME encrypted. Content type encountered: {}", (Object)msg.getContentType());
                return;
            }
            String msgId = MessageUtil.getMessageId(msg);
            Optional<String> receivedEmail = MessageUtil.getReceivedEmail(msg);
            SMIMEEnveloped enveloped = new SMIMEEnveloped(msg);
            ASN1ObjectIdentifier symAlgorithm = enveloped.getContentEncryptionAlgorithm().getAlgorithm();
            log.debug("Used symmetric encryption algorithm: {}", (Object)SmimeUtil.getCmsName(symAlgorithm));
            if (!SmimeUtil.isSupportedSymmetricKeyAlgorithm(symAlgorithm)) {
                throw new MessagingException("Algorithm " + SmimeUtil.getCmsName(symAlgorithm) + " that was used to encrypt Email with ID " + msgId + " is not supported.");
            }
            RecipientInformation recipientInfo = null;
            JceKeyTransEnvelopedRecipient recipient = null;
            RecipientInformationStore recipientInfos = enveloped.getRecipientInfos();
            for (RecipientInformation info : recipientInfos.getRecipients()) {
                PrivateKey privateKey = this.getPrivateKey(info, receivedEmail);
                if (privateKey == null) continue;
                log.debug("Used asymmetric encryption algorithm: {}", (Object)SmimeUtil.getCmsName(info.getKeyEncryptionAlgorithm().getAlgorithm()));
                recipientInfo = info;
                recipient = new JceKeyTransEnvelopedRecipient(privateKey);
                break;
            }
            if (recipient == null) {
                this.throwRecipientCertificateNotFoundException(msgId, recipientInfos);
            }
            this.decrypt(msg, recipientInfo, recipient);
            if (log.isTraceEnabled()) {
                ByteArrayOutputStream debugBaos = new ByteArrayOutputStream();
                msg.writeTo((OutputStream)debugBaos);
                log.trace("Final email:\n{}\n", (Object)debugBaos.toString());
            }
        }
        catch (Exception e) {
            throw new MessagingException("Could not decrypt email. Failure message: " + e.getMessage(), e);
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private PrivateKey getPrivateKey(RecipientInformation info, Optional<String> receivedEmail) throws GeneralSecurityException {
        if (info.getRID().getType() != 0) {
            log.debug("Recipient Info {} is not of type Key Transport (0), but {}", (Object)info.getRID(), (Object)info.getRID().getType());
            return null;
        }
        KeyTransRecipientId recipientId = (KeyTransRecipientId)info.getRID();
        String keyId = this.getKeyId(recipientId);
        if (!SmimeUtil.isSupportedAsymmetricKeyAlgorithm(info.getKeyEncryptionAlgorithm().getAlgorithm())) {
            log.warn("Key {} cannot be used for decryption, as the asymmetric algorith is not supported. Used algorithm: {}", (Object)keyId, (Object)SmimeUtil.getCmsName(info.getKeyEncryptionAlgorithm().getAlgorithm()));
            return null;
        }
        KeyStore keyStore = ((SnotifySmimeDecryptionKey)this.getPrivateKey()).getKey();
        log.debug("Looking up private key in key store (size {}) with ID: {}", (Object)keyStore.size(), (Object)keyId);
        KeyStoreContentFetcher fetcher = new KeyStoreContentFetcher(keyStore);
        fetcher.keyPassword(((SnotifySmimeDecryptionKey)this.getPrivateKey()).getPassword());
        try {
            Optional<Map.Entry<X509Certificate, PrivateKey>> privateKey = fetcher.getEntryFor(c -> c.getSerialNumber().equals(recipientId.getSerialNumber()) && SmimeUtil.getIssuer(c).equals(recipientId.getIssuer()));
            if (privateKey.isPresent()) {
                log.debug("Found private key in key store with ID: {}", (Object)keyId);
                if (receivedEmail.isPresent() && !SmimeUtil.isCertForEmail(privateKey.get().getKey(), receivedEmail.get())) {
                    log.warn("Private key found for ID {} does not seem to suitable for decrypting message received for <{}>. This may be when multiple private keys for the same ID are within the key store, which is not allowed according to RFC5280.");
                }
                PrivateKey privateKey2 = privateKey.get().getValue();
                return privateKey2;
            }
            log.debug("Found no private key in key store with ID: {}", (Object)keyId);
            PrivateKey privateKey3 = null;
            return privateKey3;
        }
        finally {
            fetcher.destroy();
        }
    }

    private void throwRecipientCertificateNotFoundException(String msgId, RecipientInformationStore recipientInfos) throws MessagingException {
        String keyIds = null;
        for (RecipientInformation info : recipientInfos.getRecipients()) {
            RecipientId id = info.getRID();
            log.debug("Recipient Type encountered: {}", (Object)this.getRecipientType(id));
            if (id.getType() != 0 || !(id instanceof KeyTransRecipientId)) continue;
            String keyId = this.getKeyId((KeyTransRecipientId)id);
            log.debug("Key ID: {}", (Object)keyId);
            if (keyIds == null) {
                keyIds = keyId;
                continue;
            }
            keyIds = keyIds + ", " + keyId;
        }
        if (keyIds == null) {
            keyIds = "<N/A>";
        }
        throw new MessagingException("Found no private key in Key Store to decrypt Email with ID " + msgId + ". Certificate(s) used to encrypt email have ID(s): " + keyIds);
    }

    private String getKeyId(KeyTransRecipientId id) {
        return SmimeUtil.getSerialNumber(id.getSerialNumber()) + " from " + id.getIssuer();
    }

    private void decrypt(MimeMessage msg, RecipientInformation recipientInfo, Recipient recipient) throws SMIMEException, CMSException, MessagingException, IOException {
        log.debug("Decrypting content.");
        MimeBodyPart decryptedPart = SMIMEUtil.toMimeBodyPart(recipientInfo.getContent(recipient));
        msg.setDisposition(null);
        msg.removeHeader("Content-Transfer-Encoding");
        ByteArrayDataSource ds = new ByteArrayDataSource(decryptedPart.getInputStream(), decryptedPart.getContentType());
        msg.setDataHandler(new DataHandler((DataSource)ds));
        MessageUtil.copyAllHeaders((Part)decryptedPart, (Part)msg);
        msg.saveChanges();
    }

    private String getRecipientType(RecipientId id) {
        switch (id.getType()) {
            case 0: {
                return "KeyTrans";
            }
            case 1: {
                return "Kek";
            }
            case 2: {
                return "KeyAgree";
            }
            case 3: {
                return "Password";
            }
        }
        return "<N/A>";
    }
}

