/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer.protect;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.util.ByteArrayDataSource;
import net.savignano.snotify.atlassian.common.util.MessageUtil;
import net.savignano.snotify.atlassian.mailer.protect.IMailHeaderProtector;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class Rfc822MailHeaderProtector
implements IMailHeaderProtector {
    private static final Logger log = LoggerFactory.getLogger(Rfc822MailHeaderProtector.class);

    @Override
    public void protectHeaders(MimeMessage msg) throws IOException, MessagingException {
        log.info("Protecting headers of message with ID {} with RFC822 method.", (Object)MessageUtil.getMessageId(msg));
        this.protect(msg);
        msg.saveChanges();
    }

    private void protect(MimeMessage msg) throws IOException, MessagingException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        msg.writeTo((OutputStream)baos);
        ByteArrayDataSource dsMessage = new ByteArrayDataSource(baos.toByteArray(), "message/rfc822");
        MimeBodyPart wrapperPart = new MimeBodyPart();
        wrapperPart.setHeader("MIME-Version", "1.0");
        msg.setDataHandler(new DataHandler((DataSource)dsMessage));
    }
}

