/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer.validate;

import java.io.ByteArrayOutputStream;
import java.io.OutputStream;
import java.util.EnumSet;
import java.util.Set;
import java.util.function.Function;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import net.savignano.snotify.atlassian.common.enums.EKeySource;
import net.savignano.snotify.atlassian.common.enums.EKeyValidity;
import net.savignano.snotify.atlassian.common.enums.EValidationType;
import net.savignano.snotify.atlassian.common.security.key.publicly.SnotifyPgpPublicKey;
import net.savignano.snotify.atlassian.common.util.PgpUtil;
import net.savignano.snotify.atlassian.mailer.validate.AMailValidator;
import net.savignano.snotify.atlassian.mailer.visitor.BaseMessageVisitor;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRing;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPPublicKeyRingCollection;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgpMailValidator
extends AMailValidator<SnotifyPgpPublicKey> {
    private static final Logger log = LoggerFactory.getLogger(PgpMailValidator.class);
    private Function<String, SnotifyPgpPublicKey> publicKeyRetriever;

    @Override
    public Set<EValidationType> getValidationCapability() {
        return EnumSet.of(EValidationType.SIGNATURE);
    }

    @Override
    protected SnotifyPgpPublicKey getValidityKey(EKeyValidity validity) {
        return new SnotifyPgpPublicKey(validity, EKeySource.EMAIL);
    }

    @Override
    protected boolean isSigned(MimeMessage msg) {
        return PgpUtil.isMessageSigned((Message)msg);
    }

    @Override
    protected boolean validate(MimeMessage msg, Set<EValidationType> validations, String email) throws Exception {
        SnotifyPgpPublicKey publicKey = this.getPublicKeyRetriever().apply(email);
        ValidateVisitor visitor = new ValidateVisitor(validations, email, publicKey.isValid() ? publicKey.getKeyRing() : null);
        visitor.visit(msg);
        return visitor.isValid();
    }

    @Override
    protected SnotifyPgpPublicKey extract(MimeMessage msg, String email) throws Exception {
        ExtractVisitor visitor = new ExtractVisitor(email);
        visitor.visit(msg);
        PGPPublicKeyRing ring = visitor.getKeyRing();
        if (ring == null) {
            return this.getValidityKey(EKeyValidity.NOT_FOUND);
        }
        SnotifyPgpPublicKey key = new SnotifyPgpPublicKey(ring, email);
        key.setKeySource(EKeySource.EMAIL);
        return key;
    }

    public Function<String, SnotifyPgpPublicKey> getPublicKeyRetriever() {
        return this.publicKeyRetriever == null ? s -> new SnotifyPgpPublicKey(EKeyValidity.NOT_FOUND) : this.publicKeyRetriever;
    }

    public void setPublicKeyRetriever(Function<String, SnotifyPgpPublicKey> publicKeyRetriever) {
        this.publicKeyRetriever = publicKeyRetriever;
    }

    private static final class ExtractVisitor
    extends BaseMessageVisitor {
        private final String email;
        private PGPPublicKeyRing ring;

        public ExtractVisitor(String email) {
            this.email = email;
        }

        @Override
        public void visit(MimePart part) throws Exception {
            super.visit(part);
            ContentType type = new ContentType(part.getContentType());
            log.trace("MIME type: {}", (Object)type);
            if (type.match("application/pgp-keys") || this.isKeyAttachment(part)) {
                log.debug("Extracting public key for email: {}", (Object)this.email);
                PGPPublicKeyRingCollection keys = PgpUtil.loadPublicKeys(part.getInputStream());
                this.ring = PgpUtil.getKeysForEmail(keys, this.email);
            }
        }

        private boolean isKeyAttachment(MimePart part) throws MessagingException {
            String fileName;
            String disposition = part.getDisposition();
            return disposition != null && disposition.equalsIgnoreCase("attachment") && (fileName = part.getFileName()) != null && fileName.endsWith(".asc") && !part.isMimeType("application/pgp-encrypted") && !part.isMimeType("application/pgp-signature");
        }

        public PGPPublicKeyRing getKeyRing() {
            return this.ring;
        }
    }

    private static final class ValidateVisitor
    extends BaseMessageVisitor {
        private final Set<EValidationType> validations;
        private final String email;
        private final PGPPublicKeyRing ring;
        private boolean valid = false;

        public ValidateVisitor(Set<EValidationType> validations, String email, PGPPublicKeyRing ring) {
            this.validations = validations;
            this.email = email;
            this.ring = ring;
        }

        @Override
        public void visit(MimeMultipart multi) throws Exception {
            ContentType type = new ContentType(multi.getContentType());
            log.trace("MIME type: {}", (Object)type);
            if (type.match("multipart/signed") && "application/pgp-signature".equalsIgnoreCase(type.getParameter("protocol"))) {
                log.debug("Found '{}' content.", (Object)type);
                if (this.sanityCheck(multi) && this.validations.contains((Object)EValidationType.SIGNATURE)) {
                    this.valid = this.validate(multi);
                }
            }
            super.visit(multi);
        }

        private boolean sanityCheck(MimeMultipart mp) throws MessagingException {
            if (mp.getCount() != 2) {
                log.warn("PGP signature does not have expected part count. Two expected, but found: {}", (Object)mp.getCount());
                return false;
            }
            if (!mp.getBodyPart(1).isMimeType("application/pgp-signature")) {
                log.warn("PGP signature does not have expected content type. Found: {}", (Object)mp.getBodyPart(1).getContentType());
                return false;
            }
            log.debug("Sanity check of PGP signature successful.");
            return true;
        }

        private boolean validate(MimeMultipart mp) throws Exception {
            log.debug("Validating message.");
            MimeBodyPart contentPart = (MimeBodyPart)mp.getBodyPart(0);
            MimeBodyPart sigPart = (MimeBodyPart)mp.getBodyPart(1);
            PGPPublicKeyRing keyRing = this.ring;
            if (keyRing == null) {
                ExtractVisitor extractVisitor = new ExtractVisitor(this.email);
                extractVisitor.visit((MimePart)contentPart);
                keyRing = extractVisitor.getKeyRing();
            }
            if (keyRing == null) {
                log.warn("Cannot verify PGP signature, as no public key was available.");
                return false;
            }
            ByteArrayOutputStream os = new ByteArrayOutputStream();
            contentPart.writeTo((OutputStream)os);
            byte[] contentBytes = os.toByteArray();
            os.reset();
            sigPart.writeTo((OutputStream)os);
            byte[] sigBytes = os.toByteArray();
            return PgpUtil.verify(contentBytes, sigBytes, keyRing.getPublicKey());
        }

        public boolean isValid() {
            return this.valid;
        }
    }
}

