/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer.validate;

import java.security.KeyStore;
import java.security.cert.Certificate;
import java.security.cert.PKIXParameters;
import java.security.cert.X509Certificate;
import java.util.EnumSet;
import java.util.Iterator;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.mail.Message;
import javax.mail.Part;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import net.savignano.snotify.atlassian.common.enums.EKeyPurpose;
import net.savignano.snotify.atlassian.common.enums.EKeySource;
import net.savignano.snotify.atlassian.common.enums.EKeyValidity;
import net.savignano.snotify.atlassian.common.enums.EValidationType;
import net.savignano.snotify.atlassian.common.security.key.publicly.SnotifySmimePublicKey;
import net.savignano.snotify.atlassian.common.util.SecurityUtil;
import net.savignano.snotify.atlassian.common.util.SmimeUtil;
import net.savignano.snotify.atlassian.mailer.validate.AMailValidator;
import net.savignano.snotify.atlassian.mailer.visitor.BaseMessageVisitor;
import net.savignano.thirdparty.org.bouncycastle.cert.X509CertificateHolder;
import net.savignano.thirdparty.org.bouncycastle.cms.SignerInformation;
import net.savignano.thirdparty.org.bouncycastle.cms.SignerInformationVerifier;
import net.savignano.thirdparty.org.bouncycastle.cms.jcajce.JcaSimpleSignerInfoVerifierBuilder;
import net.savignano.thirdparty.org.bouncycastle.i18n.ErrorBundle;
import net.savignano.thirdparty.org.bouncycastle.mail.smime.SMIMESigned;
import net.savignano.thirdparty.org.bouncycastle.mail.smime.validator.SignedMailValidator;
import net.savignano.thirdparty.org.bouncycastle.mail.smime.validator.SignedMailValidatorException;
import net.savignano.thirdparty.org.bouncycastle.util.Store;
import net.savignano.thirdparty.org.bouncycastle.x509.PKIXCertPathReviewer;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class SmimeMailValidator
extends AMailValidator<SnotifySmimePublicKey> {
    private static final Logger log = LoggerFactory.getLogger(SmimeMailValidator.class);
    private final PKIXParameters pkixParams;

    public SmimeMailValidator(PKIXParameters pkixParams) {
        this.pkixParams = pkixParams;
    }

    @Override
    public Set<EValidationType> getValidationCapability() {
        return EnumSet.of(EValidationType.SIGNATURE, EValidationType.CERT_PATH);
    }

    @Override
    protected SnotifySmimePublicKey getValidityKey(EKeyValidity validity) {
        return new SnotifySmimePublicKey(validity, EKeySource.EMAIL);
    }

    @Override
    protected boolean isSigned(MimeMessage msg) {
        return SmimeUtil.isMessageSigned((Message)msg);
    }

    @Override
    protected boolean validate(MimeMessage msg, Set<EValidationType> validations, String email) throws Exception {
        ValidateVisitor visitor = new ValidateVisitor(this.pkixParams, validations);
        visitor.visit(msg);
        return visitor.isValid();
    }

    @Override
    protected SnotifySmimePublicKey extract(MimeMessage msg, String email) throws Exception {
        ExtractVisitor visitor = new ExtractVisitor(email);
        visitor.visit(msg);
        X509Certificate cert = visitor.getCertificate();
        if (cert == null) {
            return this.getValidityKey(EKeyValidity.NOT_FOUND);
        }
        SnotifySmimePublicKey key = new SnotifySmimePublicKey(cert, email);
        key.setKeySource(EKeySource.EMAIL);
        return key;
    }

    private static final class ExtractVisitor
    extends Visitor {
        private final String email;
        private X509Certificate cert;

        public ExtractVisitor(String email) {
            this.email = email;
        }

        @Override
        public void handle(SMIMESigned signed) throws Exception {
            log.debug("Extracting public key for email: {}", (Object)this.email);
            Store<X509CertificateHolder> certificateHolders = signed.getCertificates();
            KeyStore keyStore = SmimeUtil.convertToKeyStore(certificateHolders, "PKCS12", null);
            this.cert = SmimeUtil.getValidCertForEmail(keyStore, this.email, EKeyPurpose.ENCRYPTION);
        }

        public X509Certificate getCertificate() {
            return this.cert;
        }
    }

    private static final class ValidateVisitor
    extends Visitor {
        private boolean valid = false;
        private final PKIXParameters pkixParams;
        private final Set<EValidationType> validations;

        public ValidateVisitor(PKIXParameters pkixParams, Set<EValidationType> validations) {
            this.pkixParams = pkixParams;
            this.validations = validations;
        }

        @Override
        public void visit(MimeMessage msg) throws Exception {
            if (this.pkixParams != null) {
                this.pkixParams.setDate(msg.getSentDate());
                this.handle(new SignedMailValidator(msg, this.pkixParams));
            } else {
                super.visit(msg);
            }
        }

        private void handle(SignedMailValidator validator) throws SignedMailValidatorException {
            Iterator<SignerInformation> it = validator.getSignerInformationStore().getSigners().iterator();
            this.valid = it.hasNext();
            while (this.valid && it.hasNext()) {
                SignerInformation signerInfo = it.next();
                log.debug("Checking signer ID for certificate with serial number: {}", (Object)signerInfo.getSID().getSerialNumber());
                SignedMailValidator.ValidationResult result = validator.getValidationResult(signerInfo);
                if (this.validations.contains((Object)EValidationType.SIGNATURE)) {
                    this.valid = result.isVerifiedSignature();
                }
                if (this.valid && this.validations.contains((Object)EValidationType.CERT_PATH)) {
                    if (this.validations.contains((Object)EValidationType.SIGNATURE)) {
                        this.valid = result.isValidSignature();
                    } else {
                        PKIXCertPathReviewer review = result.getCertPathReview();
                        boolean bl = this.valid = review != null && review.isValidCertPath();
                    }
                }
                if (this.valid || !log.isWarnEnabled()) continue;
                this.logValidationResult(result, signerInfo);
            }
        }

        private void logValidationResult(SignedMailValidator.ValidationResult result, SignerInformation signerInfo) {
            PKIXCertPathReviewer review = result.getCertPathReview();
            List<? extends Certificate> certPathCerts = result.getCertPath().getCertificates();
            StringBuilder builder = new StringBuilder(500);
            builder.append("Validation for signer with certificate ID ");
            builder.append(signerInfo.getSID().getSerialNumber());
            builder.append(" failed. Verified signature: ");
            builder.append(result.isVerifiedSignature());
            builder.append(". Cert path valid: ");
            builder.append(review.isValidCertPath());
            builder.append("\n");
            builder.append("  Validation errors: ");
            List errors = result.getErrors();
            this.logErrors(errors, builder);
            builder.append("  Cert path validation errors:\n");
            for (int i = -1; i < certPathCerts.size(); ++i) {
                if (i == -1) {
                    builder.append("    Global errors: ");
                } else {
                    X509Certificate cert = (X509Certificate)certPathCerts.get(i);
                    builder.append("    Errors for cert \"");
                    builder.append(cert.getSubjectX500Principal());
                    builder.append("\" with ID ");
                    builder.append(SmimeUtil.getSerialNumber(cert));
                    builder.append(": ");
                }
                this.logErrors(review.getErrors(i), builder);
            }
            log.warn(builder.toString());
        }

        private void logErrors(List<ErrorBundle> errors, StringBuilder builder) {
            switch (errors.size()) {
                case 0: {
                    builder.append("No errors reported.\n");
                    break;
                }
                case 1: {
                    this.logErrorBundle(errors.get(0), builder);
                    builder.append("\n");
                    break;
                }
                default: {
                    builder.append("\n");
                    for (ErrorBundle error : errors) {
                        this.logErrorBundle(error, builder);
                        builder.append("\n");
                    }
                }
            }
        }

        private void logErrorBundle(ErrorBundle error, StringBuilder builder) {
            builder.append(error.getId());
            builder.append(": ");
            builder.append(error.getSummary(Locale.ENGLISH));
        }

        @Override
        public void handle(SMIMESigned signed) throws Exception {
            log.debug("Validating message.");
            Store<X509CertificateHolder> certificateHolders = signed.getCertificates();
            Iterator<SignerInformation> signerInformations = signed.getSignerInfos().getSigners().iterator();
            this.valid = signerInformations.hasNext();
            while (this.valid && signerInformations.hasNext()) {
                SignerInformation signerInformation = signerInformations.next();
                log.debug("Checking signer ID for certificate with serial number: {}", (Object)signerInformation.getSID().getSerialNumber());
                X509CertificateHolder holder = certificateHolders.getMatches(signerInformation.getSID()).iterator().next();
                JcaSimpleSignerInfoVerifierBuilder builder = new JcaSimpleSignerInfoVerifierBuilder();
                builder.setProvider(SecurityUtil.getProvider());
                SignerInformationVerifier verifier = builder.build(holder);
                this.valid = signerInformation.verify(verifier);
            }
        }

        public boolean isValid() {
            return this.valid;
        }
    }

    private static abstract class Visitor
    extends BaseMessageVisitor {
        private Visitor() {
        }

        @Override
        public void visit(MimePart part) throws Exception {
            super.visit(part);
            ContentType type = new ContentType(part.getContentType());
            log.trace("MIME type: {}", (Object)type);
            if (type.match("multipart/signed")) {
                String protocol = type.getParameter("protocol");
                if (protocol != null && (protocol.equals("application/pkcs7-signature") || protocol.equals("application/x-pkcs7-signature"))) {
                    log.debug("Found '{}' content.", (Object)type);
                    MimeMultipart mp = (MimeMultipart)part.getContent();
                    String encoding = part.getEncoding();
                    SMIMESigned signed = encoding == null ? new SMIMESigned(mp) : new SMIMESigned(mp, encoding);
                    this.handle(signed);
                }
            } else if ((type.match("application/pkcs7-mime") || type.match("application/x-pkcs7-mime")) && "signed-data".equalsIgnoreCase(type.getParameter("smime-type"))) {
                log.debug("Found '{}' content.", (Object)type);
                SMIMESigned signed = new SMIMESigned((Part)part);
                this.handle(signed);
            }
        }

        public abstract void handle(SMIMESigned var1) throws Exception;
    }
}

