/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.bitbucket.common;

import com.atlassian.plugin.spring.scanner.annotation.component.BitbucketComponent;
import com.atlassian.plugin.spring.scanner.annotation.imports.ComponentImport;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.pluginsettings.PluginSettings;
import com.atlassian.sal.api.pluginsettings.PluginSettingsFactory;
import net.savignano.snotify.atlassian.common.ASnotifyProjectProperties;
import org.apache.commons.lang.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@BitbucketComponent
public class SnotifyRepositoryProperties
extends ASnotifyProjectProperties {
    private static final Logger log = LoggerFactory.getLogger(SnotifyRepositoryProperties.class);
    @ComponentImport
    private PluginSettingsFactory factory;

    @Override
    protected String getString(String key, String projectName) {
        String value;
        try {
            PluginSettings props = this.getProps(projectName);
            value = (String)props.get(key);
        }
        catch (Exception e) {
            log.error("Property exception loading application property " + key + ".", (Throwable)e);
            return null;
        }
        if (StringUtils.isBlank((String)value)) {
            log.trace("App property \"{}\" is considered null.", (Object)key);
            return null;
        }
        log.trace("App property \"{}\" is: {}", (Object)key, (Object)value);
        return value;
    }

    @Override
    protected void setString(String key, String value, String projectName) {
        try {
            log.trace("Setting app property \"{}\" to: {}", (Object)key, (Object)value);
            PluginSettings props = this.getProps(projectName);
            if (value == null) {
                props.remove(key);
            } else {
                props.put(key, (Object)value);
            }
            if (log.isTraceEnabled()) {
                String newValue = (String)props.get(key);
                if (value == null ? newValue != null : !value.equals(newValue)) {
                    log.error("Setting of app property \"{}\" failed. Expected value: \"{}\". Actual value: \"{}\"", new Object[]{key, value, newValue});
                }
            }
        }
        catch (Exception e) {
            log.error("Property exception setting application property " + key + ".", (Throwable)e);
        }
    }

    private PluginSettings getProps(String repositoryKey) {
        if (this.factory == null) {
            log.trace("Injection of PluginSettingsFactory failed. Loading manually.");
            this.factory = (PluginSettingsFactory)ComponentLocator.getComponent(PluginSettingsFactory.class);
        }
        return this.factory.createSettingsForKey(repositoryKey);
    }
}

