/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.bitbucket.mailer;

import com.atlassian.bitbucket.server.ApplicationPropertiesService;
import com.atlassian.sal.api.ApplicationProperties;
import com.atlassian.sal.api.UrlMode;
import com.atlassian.sal.api.component.ComponentLocator;
import com.atlassian.sal.api.message.I18nResolver;
import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.Locale;
import java.util.Set;
import javax.mail.Address;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.MimeMessage;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.ISnotifyAppProperties;
import net.savignano.snotify.atlassian.common.ISnotifyProjectProperties;
import net.savignano.snotify.atlassian.common.ISnotifyUserProperties;
import net.savignano.snotify.atlassian.common.NormalizedVersion;
import net.savignano.snotify.atlassian.common.enums.ECryptographyType;
import net.savignano.snotify.atlassian.common.enums.EEncryptionTypePriority;
import net.savignano.snotify.atlassian.common.enums.EKeyValidity;
import net.savignano.snotify.atlassian.common.security.key.publicly.ISnotifyPublicKey;
import net.savignano.snotify.atlassian.common.security.key.publicly.SnotifyPgpPublicKey;
import net.savignano.snotify.atlassian.common.security.key.publicly.SnotifySmimePublicKey;
import net.savignano.snotify.atlassian.common.util.MessageUtil;
import net.savignano.snotify.atlassian.mailer.AAtlassianMailKeyExtractor;
import net.savignano.snotify.atlassian.mailer.AAtlassianMailer;
import net.savignano.snotify.atlassian.mailer.MessageAndAddress;
import net.savignano.snotify.atlassian.mailer.encrypt.PgpMailEncryptor;
import net.savignano.snotify.atlassian.mailer.encrypt.SmimeMailEncryptor;
import net.savignano.snotify.atlassian.mailer.keysource.pgp.PgpEncryptionKeyManager;
import net.savignano.snotify.atlassian.mailer.keysource.pgp.PgpPublicKeyManager;
import net.savignano.snotify.atlassian.mailer.keysource.smime.SmimeEncryptionKeyManager;
import net.savignano.snotify.bitbucket.common.BitbucketUser;
import net.savignano.snotify.bitbucket.common.SnotifyI18n;
import net.savignano.snotify.bitbucket.mailer.keysource.smime.BitbucketSmimeKeyManager;
import net.savignano.snotify.bitbucket.mailer.util.MessageBuilder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitbucketMailer
extends AAtlassianMailer<BitbucketUser> {
    private static final String SNOTIFY_NAME = "S/Notify for Bitbucket";
    private static final Logger log = LoggerFactory.getLogger(BitbucketMailer.class);
    private static final String TICKET_REPLACEMENT = "%TICKET%";

    public BitbucketMailer(Session session, ISnotifyAppProperties appProps, ISnotifyUserProperties userProps, ISnotifyProjectProperties projectProps) {
        super(session, appProps, userProps, projectProps);
    }

    @Override
    protected MimeMessage getFailureMessage(MessageAndAddress msgAndAddress, EKeyValidity validity) throws MessagingException {
        Locale locale;
        ApplicationPropertiesService applicationProperties;
        BitbucketUser user = (BitbucketUser)this.getUser(msgAndAddress.address);
        I18nResolver i18nResolver = (I18nResolver)ComponentLocator.getComponent(I18nResolver.class);
        if (user != null) {
            log.debug("Getting locale for user: {}", (Object)user);
            applicationProperties = (ApplicationPropertiesService)ComponentLocator.getComponent(ApplicationPropertiesService.class);
            locale = applicationProperties.getLocale();
        } else {
            log.debug("Getting default locale.");
            applicationProperties = (ApplicationPropertiesService)ComponentLocator.getComponent(ApplicationPropertiesService.class);
            locale = applicationProperties.getLocale();
        }
        log.debug("Used locale for address \"{}\": {}", (Object)msgAndAddress.address, (Object)locale);
        SnotifyI18n i18n = new SnotifyI18n(i18nResolver, locale);
        MessageBuilder builder = new MessageBuilder((Message)msgAndAddress.message, i18n);
        builder.additional(this.getAppProps().getString(EProperty.TWEAK_REPORT_MESSAGE_ADDITIONAL_TEXT));
        if (this.getAppProps().getBoolean(EProperty.REPORT_MESSAGE_SHOW_LINK)) {
            // empty if block
        }
        if (validity == EKeyValidity.ERROR) {
            return builder.buildInternalErrorInfoMail();
        }
        EEncryptionTypePriority type = this.getTypePriority();
        builder.encryptionType(type);
        builder.editPgpInfo(this.getAppProps().getBoolean(EProperty.ALLOW_PGP_PUBLIC_KEY_OVERWRITE));
        builder.editSmimeInfo(this.getAppProps().getBoolean(EProperty.ALLOW_SMIME_CERTIFICATE_OVERWRITE));
        return builder.buildMissingKeyInfoMail();
    }

    protected SmimeMailEncryptor getSmimeEncryptor(Address toAddress, Address fromAddress) {
        BitbucketUser user = (BitbucketUser)this.getUser(toAddress);
        BitbucketSmimeKeyManager manager = user == null ? new BitbucketSmimeKeyManager(MessageUtil.getEmail(toAddress), this.getAppProps(), this.getUserProps()) : new BitbucketSmimeKeyManager(user, this.getAppProps(), this.getUserProps());
        SmimeEncryptionKeyManager senderManager = new SmimeEncryptionKeyManager(MessageUtil.getEmail(fromAddress), this.getAppProps());
        SmimeMailEncryptor encryptor = new SmimeMailEncryptor(this.getSession(), (SnotifySmimePublicKey)manager.getKey());
        encryptor.setSenderPublicKey((ISnotifyPublicKey)senderManager.getKey());
        encryptor.setHostName(this.getHostName());
        encryptor.setSnotifyName(SNOTIFY_NAME);
        encryptor.setVersion(new NormalizedVersion(this.getVersion()));
        return encryptor;
    }

    protected PgpMailEncryptor getPgpEncryptor(Address toAddress, Address fromAddress) {
        BitbucketUser user = (BitbucketUser)this.getUser(toAddress);
        PgpPublicKeyManager manager = user == null ? new PgpPublicKeyManager(MessageUtil.getEmail(toAddress), this.getAppProps(), this.getUserProps()) : new PgpPublicKeyManager(user, this.getAppProps(), this.getUserProps());
        PgpEncryptionKeyManager senderManager = new PgpEncryptionKeyManager(MessageUtil.getEmail(fromAddress), this.getAppProps());
        PgpMailEncryptor encryptor = new PgpMailEncryptor(this.getSession(), (SnotifyPgpPublicKey)manager.getKey());
        encryptor.setSenderPublicKey((ISnotifyPublicKey)senderManager.getKey());
        encryptor.setHostName(this.getHostName());
        encryptor.setSnotifyName(SNOTIFY_NAME);
        encryptor.setVersion(new NormalizedVersion(this.getVersion()));
        Long tweakAlgorithm = this.getAppProps().getLong(EProperty.TWEAK_PGP_SYMMETRIY_KEY_ALGORITHM);
        if (tweakAlgorithm != null) {
            encryptor.setForceSymmetricKeyAlgorithm(tweakAlgorithm.intValue());
        }
        return encryptor;
    }

    @Override
    protected List<String> extractProjectKeys(MimeMessage msg) {
        return Collections.emptyList();
    }

    @Override
    protected List<BitbucketUser> getUsers(Address address) {
        return BitbucketUser.lookupUsers(address);
    }

    @Override
    protected boolean hasValidKey(BitbucketUser user, ECryptographyType cryptography) {
        switch (cryptography) {
            case NONE: {
                return false;
            }
            case PGP: {
                return ((SnotifyPgpPublicKey)new PgpPublicKeyManager(user, this.getAppProps(), this.getUserProps()).getKey()).isValid();
            }
            case SMIME: {
                return ((SnotifySmimePublicKey)new BitbucketSmimeKeyManager(user, this.getAppProps(), this.getUserProps()).getKey()).isValid();
            }
        }
        log.error("Unhandled cryptography: {}", (Object)cryptography);
        return false;
    }

    @Override
    protected String getSubjectReplacement(MimeMessage msg) {
        String replacement = super.getSubjectReplacement(msg);
        if (replacement != null && this.getAppProps().getBoolean(EProperty.SUBJECT_PROTECTION_KEEP_ID)) {
            if (this.getAppProps().getString(EProperty.TWEAK_SUBJECT_PROTECTION_REPLACEMENT) == null) {
                replacement = "(%TICKET%) " + replacement;
            }
            log.debug("Subject replacement pattern: {}", (Object)replacement);
            replacement = this.replaceTicket(msg, replacement);
            replacement = replacement.replace(" ()", "");
        }
        return replacement;
    }

    private String replaceTicket(MimeMessage msg, String replacement) {
        int index = replacement.indexOf(TICKET_REPLACEMENT);
        if (index == -1) {
            return replacement;
        }
        log.debug("Extracting primary issue key.");
        String baseUrl = this.getBaseUrl();
        String issueId = this.getSubjectIssue(msg, baseUrl);
        return replacement.replace(TICKET_REPLACEMENT, issueId == null ? "" : issueId);
    }

    private String getSubjectIssue(MimeMessage msg, String baseUrl) {
        AAtlassianMailKeyExtractor extractor = null;
        List<String> keys = this.extractKeys(msg, extractor);
        String subject = null;
        try {
            subject = msg.getSubject();
        }
        catch (MessagingException e) {
            log.error("Could not get subject from email. Error message: " + e.getMessage(), (Throwable)e);
        }
        log.debug("Looking for issue reference in subject: {}", (Object)subject);
        String issueId = null;
        if (subject != null) {
            for (String key : keys) {
                if (!subject.contains(key)) continue;
                issueId = key;
                break;
            }
        }
        log.debug("Issue ID from subject: {}", issueId);
        return issueId;
    }

    private List<String> extractKeys(MimeMessage msg, AAtlassianMailKeyExtractor extractor) {
        Set<String> keys;
        String msgId = MessageUtil.getMessageId(msg);
        try {
            keys = extractor.getKeys(msg);
        }
        catch (Exception e) {
            log.error("Could not extract keys for email " + msgId + ". Error message: " + e.getMessage(), (Throwable)e);
            keys = Collections.emptySet();
        }
        log.debug("Reference(s) found in email {}: {}", (Object)msgId, keys);
        return new ArrayList<String>(keys);
    }

    private String getBaseUrl() {
        ApplicationProperties bitbucketProps = (ApplicationProperties)ComponentLocator.getComponent(ApplicationProperties.class);
        return bitbucketProps.getBaseUrl(UrlMode.CANONICAL);
    }
}

