/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.bitbucket.mailer.keysource.smime;

import com.atlassian.bitbucket.user.ApplicationUser;
import com.atlassian.bitbucket.user.DetailedUser;
import com.atlassian.bitbucket.user.UserAdminService;
import com.atlassian.crowd.embedded.api.Directory;
import com.atlassian.crowd.exception.DirectoryNotFoundException;
import com.atlassian.crowd.manager.directory.DirectoryManager;
import com.atlassian.sal.api.component.ComponentLocator;
import java.util.AbstractMap;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.function.Supplier;
import javax.naming.ConfigurationException;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.ISnotifyAppProperties;
import net.savignano.snotify.atlassian.common.ISnotifyUserProperties;
import net.savignano.snotify.atlassian.common.connector.AtlassianLdapConnector;
import net.savignano.snotify.atlassian.common.enums.EKeySource;
import net.savignano.snotify.atlassian.common.security.access.IKeyLoader;
import net.savignano.snotify.atlassian.common.security.access.smime.SmimeLdapLoader;
import net.savignano.snotify.atlassian.common.security.key.publicly.SnotifySmimePublicKey;
import net.savignano.snotify.atlassian.mailer.keysource.smime.SmimePublicKeyManager;
import net.savignano.snotify.bitbucket.common.BitbucketUser;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class BitbucketSmimeKeyManager
extends SmimePublicKeyManager {
    private static final Logger log = LoggerFactory.getLogger(BitbucketSmimeKeyManager.class);

    public BitbucketSmimeKeyManager(String address, ISnotifyAppProperties appProps, ISnotifyUserProperties userProps) {
        super(address, appProps, userProps);
    }

    public BitbucketSmimeKeyManager(BitbucketUser user, ISnotifyAppProperties appProps, ISnotifyUserProperties userProps) {
        super(user, appProps, userProps);
    }

    @Override
    protected List<Map.Entry<EKeySource, Supplier<Optional<IKeyLoader<SnotifySmimePublicKey>>>>> getKeyLoaders() {
        List<Map.Entry<EKeySource, Supplier<Optional<IKeyLoader<SnotifySmimePublicKey>>>>> loaders = super.getKeyLoaders();
        loaders.add(new AbstractMap.SimpleEntry<EKeySource, Supplier<Optional>>(EKeySource.LDAP, this::createLdapLoader));
        return loaders;
    }

    private Optional<IKeyLoader<SnotifySmimePublicKey>> createLdapLoader() {
        AtlassianLdapConnector connector;
        Directory directory;
        if (!this.getAppProps().getBoolean(EProperty.USER_DIRECTORY_LDAP_QUERY_SMIME)) {
            log.debug("Retrieving certificate from LDAP server is disabled.");
            return Optional.empty();
        }
        DetailedUser user = this.getDetailedUser(((BitbucketUser)this.getUser()).getActualUser());
        if (user == null) {
            return Optional.empty();
        }
        String directoryName = user.getDirectoryName();
        String userName = user.getName();
        DirectoryManager manager = (DirectoryManager)ComponentLocator.getComponent(DirectoryManager.class);
        try {
            directory = manager.findDirectoryByName(directoryName);
        }
        catch (DirectoryNotFoundException e) {
            log.error("Could not find directory with name " + directoryName + ". Error message: " + e.getMessage(), (Throwable)e);
            return Optional.empty();
        }
        if (!AtlassianLdapConnector.isConnector(directory)) {
            log.debug("Directory {} is not connecting to an LDAP.", (Object)directory.getName());
            return Optional.empty();
        }
        try {
            connector = AtlassianLdapConnector.createConnector(directory);
        }
        catch (ConfigurationException e) {
            log.error("Could not create an LDAP from directory " + directory.getName() + ". Error message: " + e.getMessage());
            return Optional.empty();
        }
        String userFilter = "(" + connector.getUserNameKey() + "=" + userName + ")";
        SmimeLdapLoader loader = new SmimeLdapLoader(connector, userFilter);
        loader.setKeySource(EKeySource.LDAP);
        loader.setEmail(this.getAddress());
        loader.setExpectP7b(this.getAppProps().getBoolean(EProperty.TWEAK_EXPECT_P7B_IN_LDAP));
        return Optional.of(loader);
    }

    private DetailedUser getDetailedUser(ApplicationUser user) {
        if (user instanceof DetailedUser) {
            return (DetailedUser)user;
        }
        UserAdminService service = (UserAdminService)ComponentLocator.getComponent(UserAdminService.class);
        return service.getUserDetails(user);
    }
}

