/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.thirdparty.org.bouncycastle.openpgp;

import java.io.EOFException;
import java.io.InputStream;
import net.savignano.thirdparty.org.bouncycastle.bcpg.BCPGInputStream;
import net.savignano.thirdparty.org.bouncycastle.bcpg.InputStreamPacket;
import net.savignano.thirdparty.org.bouncycastle.bcpg.SymmetricEncIntegrityPacket;
import net.savignano.thirdparty.org.bouncycastle.bcpg.SymmetricKeyEncSessionPacket;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPDataValidationException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPEncryptedData;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PBEDataDecryptorFactory;
import net.savignano.thirdparty.org.bouncycastle.openpgp.operator.PGPDataDecryptor;
import net.savignano.thirdparty.org.bouncycastle.util.io.TeeInputStream;

public class PGPPBEEncryptedData
extends PGPEncryptedData {
    SymmetricKeyEncSessionPacket keyData;

    PGPPBEEncryptedData(SymmetricKeyEncSessionPacket keyData, InputStreamPacket encData) {
        super(encData);
        this.keyData = keyData;
    }

    public int getSymmetricAlgorithm(PBEDataDecryptorFactory dataDecryptorFactory) throws PGPException {
        byte[] key = dataDecryptorFactory.makeKeyFromPassPhrase(this.keyData.getEncAlgorithm(), this.keyData.getS2K());
        byte[] sessionData = dataDecryptorFactory.recoverSessionData(this.keyData.getEncAlgorithm(), key, this.keyData.getSecKeyData());
        return sessionData[0];
    }

    public InputStream getDataStream(PBEDataDecryptorFactory dataDecryptorFactory) throws PGPException {
        try {
            boolean zeroesCheckPassed;
            int keyAlgorithm = this.keyData.getEncAlgorithm();
            byte[] key = dataDecryptorFactory.makeKeyFromPassPhrase(keyAlgorithm, this.keyData.getS2K());
            boolean withIntegrityPacket = this.encData instanceof SymmetricEncIntegrityPacket;
            byte[] sessionData = dataDecryptorFactory.recoverSessionData(this.keyData.getEncAlgorithm(), key, this.keyData.getSecKeyData());
            byte[] sessionKey = new byte[sessionData.length - 1];
            System.arraycopy(sessionData, 1, sessionKey, 0, sessionKey.length);
            PGPDataDecryptor dataDecryptor = dataDecryptorFactory.createDataDecryptor(withIntegrityPacket, sessionData[0] & 0xFF, sessionKey);
            this.encStream = new BCPGInputStream(dataDecryptor.getInputStream(this.encData.getInputStream()));
            if (withIntegrityPacket) {
                this.truncStream = new PGPEncryptedData.TruncatedStream(this.encStream);
                this.integrityCalculator = dataDecryptor.getIntegrityCalculator();
                this.encStream = new TeeInputStream(this.truncStream, this.integrityCalculator.getOutputStream());
            }
            byte[] iv = new byte[dataDecryptor.getBlockSize()];
            for (int i = 0; i != iv.length; ++i) {
                int ch = this.encStream.read();
                if (ch < 0) {
                    throw new EOFException("unexpected end of stream.");
                }
                iv[i] = (byte)ch;
            }
            int v1 = this.encStream.read();
            int v2 = this.encStream.read();
            if (v1 < 0 || v2 < 0) {
                throw new EOFException("unexpected end of stream.");
            }
            boolean repeatCheckPassed = iv[iv.length - 2] == (byte)v1 && iv[iv.length - 1] == (byte)v2;
            boolean bl = zeroesCheckPassed = v1 == 0 && v2 == 0;
            if (!repeatCheckPassed && !zeroesCheckPassed) {
                throw new PGPDataValidationException("data check failed.");
            }
            return this.encStream;
        }
        catch (PGPException e) {
            throw e;
        }
        catch (Exception e) {
            throw new PGPException("Exception creating cipher", e);
        }
    }
}

