/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer.decrypt;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.Session;
import javax.mail.internet.ContentDisposition;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimePart;
import javax.mail.util.ByteArrayDataSource;
import net.savignano.snotify.atlassian.common.Constants;
import net.savignano.snotify.atlassian.common.security.key.secret.SnotifyPgpDecryptionKey;
import net.savignano.snotify.atlassian.common.util.MessageUtil;
import net.savignano.snotify.atlassian.common.util.PgpUtil;
import net.savignano.snotify.atlassian.mailer.decrypt.AMailDecryptor;
import net.savignano.snotify.atlassian.mailer.visitor.BaseMessageVisitor;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class PgpMailDecryptor
extends AMailDecryptor<SnotifyPgpDecryptionKey> {
    private static final String CONTENT_TYPE_ENCRYPTED = "multipart/encrypted";
    private static final String CONTENT_TYPE_ENCRYPTED_PROTOCOL_PARAM = "protocol";
    private static final String CONTENT_TYPE_ENCRYPTED_PROTOCOL_VALUE = "application/pgp-encrypted";
    private static final String CONTENT_TYPE_PGP_ENCRYPTED_PART1 = "application/pgp-encrypted";
    private static final String CONTENT_TYPE_PGP_ENCRYPTED_PART2 = "application/octet-stream";
    private static final Logger log = LoggerFactory.getLogger(PgpMailDecryptor.class);
    private boolean checkInline;

    public static final boolean isMessageEncrypted(Message message) {
        if (!(message instanceof MimeMessage)) {
            log.debug("Message is not a MIME message, so can't be PGP encrypted. Encountered message class: {}", message.getClass());
            return false;
        }
        final boolean[] encrypted = new boolean[1];
        BaseMessageVisitor visitor = new BaseMessageVisitor(){

            @Override
            public void visit(MimePart part) throws Exception {
                if (encrypted[0]) {
                    return;
                }
                if (PgpMailDecryptor.isPgpEncrypted(part)) {
                    encrypted[0] = true;
                } else {
                    super.visit(part);
                }
            }
        };
        try {
            visitor.visit((MimeMessage)message);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return encrypted[0];
    }

    private static final boolean isPgpEncrypted(MimePart part) throws MessagingException {
        ContentType contentType = new ContentType(part.getContentType());
        if (contentType.match(CONTENT_TYPE_ENCRYPTED)) {
            return "application/pgp-encrypted".equalsIgnoreCase(contentType.getParameter(CONTENT_TYPE_ENCRYPTED_PROTOCOL_PARAM));
        }
        return false;
    }

    public static final boolean isMessageEncryptedInline(Message message) {
        if (!(message instanceof MimeMessage)) {
            log.debug("Message is not a MIME message, so can't be PGP encrypted. Encountered message class: {}", message.getClass());
            return false;
        }
        final boolean[] encrypted = new boolean[1];
        BaseMessageVisitor visitor = new BaseMessageVisitor(){

            @Override
            public void visit(MimePart part) throws Exception {
                if (encrypted[0]) {
                    return;
                }
                if (PgpMailDecryptor.isPgpEncryptedInlineText((Part)part)) {
                    encrypted[0] = true;
                } else if (PgpMailDecryptor.isPgpEncryptedInlineAttachment(part)) {
                    encrypted[0] = true;
                } else {
                    super.visit(part);
                }
            }
        };
        try {
            visitor.visit((MimeMessage)message);
        }
        catch (Exception e) {
            log.error(e.getMessage(), (Throwable)e);
        }
        return encrypted[0];
    }

    private static final boolean isPgpEncryptedInlineText(Part part) throws MessagingException, IOException {
        return part.isMimeType("text/plain") && ((String)part.getContent()).startsWith("-----BEGIN PGP MESSAGE-----");
    }

    private static final boolean isPgpEncryptedInlineAttachment(MimePart part) throws MessagingException {
        if ("attachment".equalsIgnoreCase(part.getDisposition())) {
            ContentDisposition contentDisposition = new ContentDisposition(part.getHeader("Content-Disposition", null));
            String filename = contentDisposition.getParameter("filename");
            return filename != null && filename.endsWith(".pgp");
        }
        return false;
    }

    public PgpMailDecryptor(Session session, SnotifyPgpDecryptionKey privateKey) {
        super(session, privateKey);
    }

    @Override
    protected void decrypt(MimeMessage msg) throws IOException, MessagingException {
        if (log.isTraceEnabled()) {
            ByteArrayOutputStream debugBaos = new ByteArrayOutputStream();
            msg.writeTo((OutputStream)debugBaos);
            log.trace("Original email:\n{}\n", (Object)debugBaos.toString());
        }
        BaseMessageVisitor visitor = new BaseMessageVisitor(){

            @Override
            public void visit(MimePart part) throws Exception {
                if (PgpMailDecryptor.isPgpEncrypted(part)) {
                    if (PgpMailDecryptor.this.sanityCheck(part)) {
                        PgpMailDecryptor.this.decryptPgp((Part)part, (Multipart)part.getContent());
                        this.setChanged(true);
                    }
                } else if (PgpMailDecryptor.this.isCheckInline() && PgpMailDecryptor.isPgpEncryptedInlineText((Part)part)) {
                    PgpMailDecryptor.this.decryptPgpInlineText(part);
                    this.setChanged(true);
                } else if (PgpMailDecryptor.this.isCheckInline() && PgpMailDecryptor.isPgpEncryptedInlineAttachment(part)) {
                    PgpMailDecryptor.this.decryptPgpInlineAttachment(part);
                    this.setChanged(true);
                } else {
                    super.visit(part);
                }
            }
        };
        try {
            visitor.visit(msg);
        }
        catch (Exception e) {
            throw new MessagingException("Could not decrypt email. Failure message: " + e.getMessage(), e);
        }
        if (log.isTraceEnabled()) {
            ByteArrayOutputStream debugBaos = new ByteArrayOutputStream();
            msg.writeTo((OutputStream)debugBaos);
            log.trace("Final email:\n{}\n", (Object)debugBaos.toString());
        }
    }

    private boolean sanityCheck(MimePart part) throws MessagingException, IOException {
        Multipart mp;
        if (!part.isMimeType(CONTENT_TYPE_ENCRYPTED)) {
            log.warn("PGP encryption does not have expected content type. Found: {}", (Object)part.getContentType());
        }
        if ((mp = (Multipart)part.getContent()).getCount() != 2) {
            log.warn("PGP encryption does not have expected part count. Two expected, but found: {}", (Object)mp.getCount());
            return false;
        }
        String contentType = mp.getContentType();
        if (contentType == null || !contentType.startsWith(CONTENT_TYPE_ENCRYPTED)) {
            log.warn("PGP encryption does not have expected content type. Found: {}", (Object)mp.getContentType());
            return false;
        }
        if (!mp.getBodyPart(0).isMimeType("application/pgp-encrypted")) {
            log.warn("PGP encryption version part does not have expected content type. Found: {}", (Object)mp.getBodyPart(0).getContentType());
            return false;
        }
        if (!mp.getBodyPart(1).isMimeType(CONTENT_TYPE_PGP_ENCRYPTED_PART2)) {
            log.warn("PGP encryption content part does not have expected content type. Found: {}", (Object)mp.getBodyPart(1).getContentType());
            return false;
        }
        return true;
    }

    private void decryptPgp(Part parentPart, Multipart contentPart) throws MessagingException, IOException {
        log.debug("Decrypting PGP message.");
        BodyPart part = contentPart.getBodyPart(1);
        byte[] decrypted = this.decryptPart((Part)part);
        MimeMessage message = new MimeMessage(this.getSession(), (InputStream)new ByteArrayInputStream(decrypted));
        parentPart.setDisposition(null);
        parentPart.setContent(message.getContent(), message.getContentType());
        MessageUtil.copyNonMatchingHeaders((Part)message, parentPart, Constants.STRUCTURAL_MIME_HEADERS);
    }

    private void decryptPgpInlineText(MimePart part) throws MessagingException, IOException {
        log.debug("Decrypting inline text.");
        byte[] decrypted = this.decryptPart((Part)part);
        ContentType contentType = new ContentType(part.getContentType());
        String charset = contentType.getParameter("charset");
        charset = charset == null ? "UTF-8" : charset;
        part.setText(new String(decrypted, charset), charset);
    }

    private void decryptPgpInlineAttachment(MimePart part) throws MessagingException, IOException {
        log.debug("Decrypting inline attachment.");
        byte[] decrypted = this.decryptPart((Part)part);
        ByteArrayDataSource dsEncrypted = new ByteArrayDataSource(decrypted, CONTENT_TYPE_PGP_ENCRYPTED_PART2);
        part.setDataHandler(new DataHandler((DataSource)dsEncrypted));
        ContentDisposition contentDisposition = new ContentDisposition(part.getHeader("Content-Disposition", null));
        String filename = contentDisposition.getParameter("filename");
        filename = filename.substring(0, filename.length() - 4);
        contentDisposition.setParameter("filename", filename);
        part.setHeader("Content-Disposition", contentDisposition.toString());
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    private byte[] decryptPart(Part part) throws IOException, MessagingException {
        try (InputStream is = part.getInputStream();){
            byte[] byArray = PgpUtil.decrypt(is, ((SnotifyPgpDecryptionKey)this.getPrivateKey()).getKey(), ((SnotifyPgpDecryptionKey)this.getPrivateKey()).getPassword(), true);
            return byArray;
        }
        catch (PGPException e) {
            if (!"checksum mismatch at in checksum of 20 bytes".equals(e.getMessage())) throw new MessagingException(e.getMessage(), (Exception)e);
            throw new MessagingException("Supplied password was wrong to extract private key.", (Exception)e);
        }
    }

    public boolean isCheckInline() {
        return this.checkInline;
    }

    public void setCheckInline(boolean checkInline) {
        this.checkInline = checkInline;
    }
}

