/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer.encrypt;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.text.MessageFormat;
import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.ContentDisposition;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimePart;
import javax.mail.internet.MimeUtility;
import javax.mail.util.ByteArrayDataSource;
import net.savignano.snotify.atlassian.common.security.key.publicly.SnotifyPgpPublicKey;
import net.savignano.snotify.atlassian.common.util.PgpUtil;
import net.savignano.snotify.atlassian.mailer.encrypt.PgpMailEncryptor;
import net.savignano.snotify.atlassian.mailer.visitor.BaseMessageVisitor;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPException;
import org.apache.commons.io.IOUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InlinePgpMailEncryptor
extends PgpMailEncryptor {
    private static final Logger log = LoggerFactory.getLogger(InlinePgpMailEncryptor.class);
    private static final String XENCRPYTED_MAIL_VALUE = "by {0} {1} at {2} using PGP inline encryption with {3}";

    public InlinePgpMailEncryptor(Session session, SnotifyPgpPublicKey publicKey) {
        super(session, publicKey);
    }

    @Override
    protected void encrypt(MimeMessage msg) throws IOException, MessagingException {
        log.debug("Encrypting message with msg ID: {}", (Object)msg.getMessageID());
        if (log.isTraceEnabled()) {
            ByteArrayOutputStream debugBaos = new ByteArrayOutputStream();
            msg.writeTo((OutputStream)debugBaos);
            log.trace("Original email:\n{}\n", (Object)debugBaos.toString());
        }
        BaseMessageVisitor visitor = new BaseMessageVisitor(){

            @Override
            public void visit(MimePart part) throws Exception {
                if (part.isMimeType("text/plain")) {
                    this.encryptText(part);
                } else if (StringUtils.equalsIgnoreCase((CharSequence)part.getDisposition(), (CharSequence)"attachment")) {
                    this.encryptAttachment(part);
                } else {
                    super.visit(part);
                }
            }

            private void encryptText(MimePart part) throws MessagingException, IOException, PGPException {
                log.debug("Found text/plain to encrypt.");
                ContentType contentType = new ContentType(part.getContentType());
                String text = (String)part.getContent();
                String charset = contentType.getParameter("charset");
                charset = charset == null ? "UTF-8" : charset;
                byte[] encrypted = PgpUtil.encrypt(text.getBytes(charset), InlinePgpMailEncryptor.this.getUsedKeys(), InlinePgpMailEncryptor.this.getSymmetricKeyAlgorithm(), true, true);
                part.setText(new String(encrypted, charset), charset);
                this.setChanged(true);
            }

            private void encryptAttachment(MimePart part) throws MessagingException, IOException, PGPException {
                log.debug("Found attachment to encrypt.");
                ContentDisposition contentDisposition = new ContentDisposition(part.getHeader("Content-Disposition", null));
                String filename = contentDisposition.getParameter("filename");
                if (filename != null) {
                    filename = filename + ".pgp";
                    contentDisposition.setParameter("filename", filename);
                }
                ByteArrayOutputStream os = new ByteArrayOutputStream();
                try (InputStream is = part.getInputStream();){
                    IOUtils.copy((InputStream)is, (OutputStream)os);
                }
                byte[] encrypted = PgpUtil.encrypt(os.toByteArray(), InlinePgpMailEncryptor.this.getUsedKeys(), InlinePgpMailEncryptor.this.getSymmetricKeyAlgorithm(), false, true);
                ByteArrayDataSource dsEncrypted = new ByteArrayDataSource(encrypted, "application/octet-stream");
                part.setDataHandler(new DataHandler((DataSource)dsEncrypted));
                part.setHeader("Content-Disposition", contentDisposition.toString());
                this.setChanged(true);
            }
        };
        try {
            visitor.visit(msg);
        }
        catch (Exception e) {
            throw new MessagingException(e.getLocalizedMessage(), e);
        }
        if (visitor.isChanged()) {
            log.debug("Successfully encrypted message with msg ID: {}", (Object)msg.getMessageID());
            String xencryptedMailValue = this.getXencryptedMailValue(this.getSymmetricKeyAlgorithm());
            msg.addHeader("X-Encrypted", MimeUtility.fold((int)("X-Encrypted".length() + 2), (String)xencryptedMailValue));
            msg.saveChanges();
            if (log.isTraceEnabled()) {
                ByteArrayOutputStream debugBaos = new ByteArrayOutputStream();
                msg.writeTo((OutputStream)debugBaos);
                log.trace("Final email:\n{}\n", (Object)debugBaos.toString());
            }
        } else {
            log.warn("Found no text/plain content part, nor an attachment in message with ID {}. Nothing was encrypted.", (Object)msg.getMessageID());
        }
    }

    @Override
    protected String getXencryptedMailValue(int encryptionAlgorithm) {
        return MessageFormat.format(XENCRPYTED_MAIL_VALUE, this.getSnotifyName(), this.getVersion(), this.getHostName(), PgpUtil.getSymmetricCipherName(encryptionAlgorithm));
    }
}

