/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer.keysource;

import java.io.IOException;
import java.util.Calendar;
import java.util.HashMap;
import java.util.Map;
import javax.security.auth.DestroyFailedException;
import net.savignano.snotify.atlassian.common.EProperty;
import net.savignano.snotify.atlassian.common.ISnotifyAppProperties;
import net.savignano.snotify.atlassian.common.enums.EKeySource;
import net.savignano.snotify.atlassian.common.enums.EKeyValidity;
import net.savignano.snotify.atlassian.common.security.key.secret.ISnotifySecretKey;
import net.savignano.snotify.atlassian.mailer.keysource.AKeyManager;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class APrivateKeyManager<T extends ISnotifySecretKey<?>>
extends AKeyManager<T> {
    private static final Logger log = LoggerFactory.getLogger(APrivateKeyManager.class);
    private static final Map<Class<?>, Map<String, ? extends ISnotifySecretKey<?>>> cachedKeys = new HashMap();
    private static final Map<Class<?>, Map<String, Calendar>> cachedTimeStamps = new HashMap();
    private Calendar cachedTimeStamp;
    private T cachedKey;

    public APrivateKeyManager(String address, ISnotifyAppProperties appProps) {
        super(address, appProps);
        this.initValues();
    }

    private void initValues() {
        Map<String, Calendar> timeStampMap = cachedTimeStamps.get(this.getCacheClass());
        if (timeStampMap == null) {
            timeStampMap = new HashMap<String, Calendar>();
            cachedTimeStamps.put(this.getCacheClass(), timeStampMap);
        }
        this.cachedTimeStamp = timeStampMap.get(this.getAddress());
        Map<String, ISnotifySecretKey<?>> keyMap = cachedKeys.get(this.getCacheClass());
        if (keyMap == null) {
            keyMap = new HashMap();
            cachedKeys.put(this.getCacheClass(), keyMap);
        }
        this.cachedKey = keyMap.get(this.getAddress());
    }

    protected void clearCache() {
        cachedKeys.get(this.getCacheClass()).clear();
        cachedTimeStamps.get(this.getCacheClass()).clear();
    }

    @Override
    protected T getCachedKey() {
        if (this.cachedKey == null) {
            return (T)((ISnotifySecretKey)this.getValidityKey(EKeyValidity.NOT_FOUND, EKeySource.UNKNOWN));
        }
        return this.cachedKey;
    }

    @Override
    protected void setCachedKey(T key) throws IOException {
        ISnotifySecretKey<?> oldKey;
        this.cachedKey = key;
        Map<String, ISnotifySecretKey<?>> map = cachedKeys.get(this.getCacheClass());
        if (key == null) {
            log.debug("Clearing key from cache.");
            oldKey = map.remove(this.getAddress());
        } else {
            log.debug("Storing new key in cache: {}", key);
            oldKey = map.put(this.getAddress(), (ISnotifySecretKey<?>)key);
        }
        if (oldKey != null && oldKey != key) {
            try {
                log.debug("Destroying old key: {}", oldKey);
                oldKey.destroy();
            }
            catch (DestroyFailedException e) {
                log.error("Could not destroy old key. Error message: " + e.getMessage(), (Throwable)e);
            }
        }
        this.setCachedTimeStamp(Calendar.getInstance());
    }

    @Override
    protected boolean isCachedKeyUsable(T key) {
        if (!super.isCachedKeyUsable(key)) {
            return false;
        }
        if (key.isDestroyed()) {
            log.debug("Cached key unusable: Key already destroyed.");
            return false;
        }
        return true;
    }

    @Override
    protected boolean isCacheAutomaticallyExpired() {
        if (super.isCacheAutomaticallyExpired()) {
            return true;
        }
        if (this.getCachedTimeStamp() == null) {
            log.debug("Cache automatically expired: No cache timestamp.");
            return true;
        }
        if (Calendar.getInstance().get(5) != this.getCachedTimeStamp().get(5)) {
            log.debug("Cache automatically expired: New day.");
            return true;
        }
        return false;
    }

    @Override
    protected boolean isCacheManuallyExpired() {
        Long expireTimeStamp;
        if (super.isCacheManuallyExpired()) {
            return true;
        }
        if (this.getCachedTimeStamp() != null && (expireTimeStamp = this.getAppProps().getLong(EProperty.EXPIRE_KEYS_PRIVATE_TIMESTAMP)) != null && expireTimeStamp > this.getCachedTimeStamp().getTimeInMillis()) {
            log.debug("Cache manually expired: Timestamp expired.");
            return true;
        }
        return false;
    }

    protected Calendar getCachedTimeStamp() {
        return this.cachedTimeStamp;
    }

    protected void setCachedTimeStamp(Calendar cachedTimeStamp) {
        this.cachedTimeStamp = cachedTimeStamp;
        Map<String, Calendar> map = cachedTimeStamps.get(this.getCacheClass());
        map.put(this.getAddress(), cachedTimeStamp);
    }

    protected abstract Class<?> getCacheClass();
}

