/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer.sign;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.OutputStream;
import javax.mail.MessagingException;
import javax.mail.Session;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeMessage;
import javax.mail.internet.MimePart;
import net.savignano.snotify.atlassian.common.security.key.secret.SnotifyPgpSignKey;
import net.savignano.snotify.atlassian.common.util.PgpUtil;
import net.savignano.snotify.atlassian.mailer.sign.AMailSigner;
import net.savignano.snotify.atlassian.mailer.visitor.BaseMessageVisitor;
import net.savignano.thirdparty.org.bouncycastle.openpgp.PGPSecretKey;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class InlinePgpMailSigner
extends AMailSigner<SnotifyPgpSignKey> {
    private static final Logger log = LoggerFactory.getLogger(InlinePgpMailSigner.class);

    public InlinePgpMailSigner(Session session, SnotifyPgpSignKey privateKey) {
        super(session, privateKey);
    }

    @Override
    protected void sign(MimeMessage msg) throws IOException, MessagingException {
        log.debug("Signing message with msg ID: {}", (Object)msg.getMessageID());
        if (log.isTraceEnabled()) {
            ByteArrayOutputStream debugBaos = new ByteArrayOutputStream();
            msg.writeTo((OutputStream)debugBaos);
            log.trace("Original email:\n{}\n", (Object)debugBaos.toString());
        }
        final PGPSecretKey key = ((SnotifyPgpSignKey)this.getPrivateKey()).getKey();
        final char[] password = ((SnotifyPgpSignKey)this.getPrivateKey()).getPassword();
        int algorithm = 8;
        BaseMessageVisitor visitor = new BaseMessageVisitor(){

            @Override
            public void visit(MimePart part) throws Exception {
                ContentType contentType = new ContentType(part.getContentType());
                if (contentType.match("text/plain")) {
                    log.debug("Found text/plain part to sign.");
                    String text = (String)part.getContent();
                    String charset = contentType.getParameter("charset");
                    charset = charset == null ? "UTF-8" : charset;
                    StringBuilder builder = new StringBuilder(3 * text.length());
                    builder.append("-----BEGIN PGP SIGNED MESSAGE-----\r\n");
                    builder.append("Hash: ");
                    builder.append(PgpUtil.getHashName(8));
                    builder.append("\r\n\r\n");
                    builder.append(text);
                    builder.append("\r\n");
                    log.debug("Signing text part with key: {}", (Object)key);
                    byte[] signedBytes = PgpUtil.sign(text.getBytes(charset), key, password, 8, true);
                    builder.append(new String(signedBytes, charset));
                    part.setText(builder.toString(), charset);
                    this.setChanged(true);
                } else {
                    super.visit(part);
                }
            }
        };
        try {
            visitor.visit(msg);
        }
        catch (Exception e) {
            throw new MessagingException(e.getLocalizedMessage(), e);
        }
        if (visitor.isChanged()) {
            log.debug("Successfully signed message with msg ID: {}", (Object)msg.getMessageID());
            if (log.isTraceEnabled()) {
                ByteArrayOutputStream debugBaos = new ByteArrayOutputStream();
                msg.writeTo((OutputStream)debugBaos);
                log.trace("Final email:\n{}\n", (Object)debugBaos.toString());
            }
        } else {
            log.warn("Found no text/plain content part in message with ID {}. Nothing was signed.", (Object)msg.getMessageID());
        }
    }
}

