/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer.visitor;

import javax.activation.DataHandler;
import javax.activation.DataSource;
import javax.mail.BodyPart;
import javax.mail.Multipart;
import javax.mail.Part;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimeBodyPart;
import javax.mail.internet.MimeMultipart;
import javax.mail.internet.MimePart;
import javax.mail.util.ByteArrayDataSource;
import net.savignano.snotify.atlassian.mailer.visitor.ContentTypeVisitor;
import net.savignano.thirdparty.org.bouncycastle.mail.smime.SMIMESigned;

public class OpaqueSignatureConverter
extends ContentTypeVisitor {
    private static final String SIGNATURE_CONVERTED_HEADER = "X-Snotify-Signature-Converted";

    @Override
    protected boolean isRelevant(ContentType type) {
        return (type.match("application/pkcs7-mime") || type.match("application/x-pkcs7-mime")) && "signed-data".equalsIgnoreCase(type.getParameter("smime-type"));
    }

    @Override
    protected void handlePart(MimePart part) throws Exception {
        if (Boolean.parseBoolean(part.getHeader(SIGNATURE_CONVERTED_HEADER, null))) {
            this.getLogger().info("Opaque signature already converted in message with ID: {}", (Object)this.getMsgId());
            return;
        }
        ContentType type = new ContentType(part.getContentType());
        this.getLogger().debug("Found '{}' content. Converting opaque signature.", (Object)type);
        this.getLogger().info("Converting opaque signature from message {} into clear signature.", (Object)this.getMsgId());
        SMIMESigned smimeSigned = new SMIMESigned((Part)part);
        MimeBodyPart contentPart = smimeSigned.getContent();
        MimeBodyPart signaturePart = new MimeBodyPart();
        signaturePart.setDisposition(part.getDisposition());
        signaturePart.setFileName(part.getFileName());
        signaturePart.setHeader("Content-Transfer-Encoding", part.getHeader("Content-Transfer-Encoding", null));
        signaturePart.setHeader(SIGNATURE_CONVERTED_HEADER, Boolean.TRUE.toString());
        ByteArrayDataSource ds = new ByteArrayDataSource(part.getInputStream(), part.getContentType());
        signaturePart.setDataHandler(new DataHandler((DataSource)ds));
        String protocol = type.getBaseType();
        MimeMultipart mp = new MimeMultipart("signed; protocol=\"" + protocol + "\"");
        mp.addBodyPart((BodyPart)contentPart);
        mp.addBodyPart((BodyPart)signaturePart);
        part.setDisposition(null);
        part.setContent((Multipart)mp);
        this.setChanged(true);
    }
}

