/*
 * Decompiled with CFR 0.152.
 */
package net.savignano.snotify.atlassian.mailer.visitor;

import java.util.ArrayList;
import java.util.Collections;
import java.util.List;
import java.util.regex.MatchResult;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.mail.internet.ContentType;
import javax.mail.internet.MimePart;
import net.savignano.snotify.atlassian.mailer.visitor.ContentTypeVisitor;

public class RegexVisitor
extends ContentTypeVisitor {
    private final Pattern pattern;
    private final List<MatchResult> matches = new ArrayList<MatchResult>();

    public RegexVisitor(Pattern pattern) {
        this.pattern = pattern;
        this.getLogger().trace("Pattern used: {}", (Object)pattern.pattern());
    }

    @Override
    protected boolean isRelevant(ContentType contentType) {
        return contentType.match("text/*");
    }

    @Override
    protected void handlePart(MimePart part) throws Exception {
        this.getLogger().trace("Found text content. Content transfer encoding: {}", (Object)part.getHeader("Content-Transfer-Encoding", null));
        Object content = part.getContent();
        if (content instanceof String) {
            this.checkForMatch((String)content);
        } else {
            this.getLogger().warn("Expected content of type string, but was: {}", content == null ? null : content.getClass());
        }
    }

    private void checkForMatch(String content) {
        Matcher matcher = this.pattern.matcher(content);
        while (matcher.find()) {
            this.getLogger().trace("Found match: {}", (Object)matcher.group());
            this.matches.add(matcher.toMatchResult());
        }
    }

    @Override
    protected void reset() {
        super.reset();
        this.matches.clear();
    }

    public List<MatchResult> getMatches() {
        return Collections.unmodifiableList(this.matches);
    }
}

